////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;


/**
 */
public class BoundingBox
{
    public int x1, y1, x2, y2;
    
    public BoundingBox()
    {
    }
    
    public BoundingBox(int _x, int _y, int _w, int _h)
    {
        x1 = _x;
        y1 = _y;
        x2 = _x + _w;
        y2 = _y + _h;
        
        if (_w < 0) { int t = x1; x1 = x2; x2 = t; }
        if (_h < 0) { int t = y1; y1 = y2; y2 = t; }
    }
    
    /**
     * Tests for intersection between the two bounding boxes.
     * 
     * @param bbox The other bounding box.
     * @return True if the bounding boxes overlap.
     */
    public boolean intersects( BoundingBox bbox )
    {
        if ( (bbox.x2 <= x1 || x2 <= bbox.x1) &&
             (bbox.y2 <= y1 || y2 <= bbox.y1) )
            return false;
        return true;
    }
    
    /**
     * Tests if the bounding box contains the given point.
     * 
     * @param x The x coord.
     * @param y The y coord.
     * @return True if the point is contained.
     */
    public boolean contains( int x, int y )
    {
        return (x >= x1) && (x <= x2) && (y >= y1) && (y <= y2);
    }
    
    /**
     * Converts this bbox to string.
     */
    public String toString()
    {
        return "(" + FP.toString(x1) + "," + FP.toString(y1) + "),(" + FP.toString(x2) + "," + FP.toString(y2) + ")";
    }
}
