/*
 * Decompiled with CFR 0.152.
 */
package StarifficEditorGame;

import StarifficEditorGame.Collidable;
import StarifficEditorGame.FP;
import StarifficEditorGame.LevelObject;
import StarifficEditorGame.Verlet;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class WallSphere
extends LevelObject
implements Collidable {
    public int mode;
    public int bump_power;
    public int pos_x;
    public int pos_y;
    public int radius;
    public int radius2;
    public int color;
    private int m_bumper;
    private static int[] g_temp_vec = new int[2];
    private static final int g_friction_amount = FP.toFP(1.0f);
    private static final int g_bumper_min = FP.toFP(0.1f);
    private static final int g_bumper_max = FP.toFP(0.4f);
    private static final int g_bumper_speed = FP.toFP(2.0f);

    public void update(int time_secs) {
        if (this.mode == 2) {
            this.m_bumper -= FP.mul(g_bumper_speed, time_secs);
            if (this.m_bumper < g_bumper_min) {
                this.m_bumper = g_bumper_min;
            }
        }
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        int size_x = FP.toInt(FP.mul(this.radius, scale_x) * 2);
        int size_y = FP.toInt(FP.mul(this.radius, scale_y) * 2);
        int tl_x = FP.toInt(FP.mul(this.pos_x - this.radius - top_x, scale_x));
        int tl_y = FP.toInt(FP.mul(this.pos_y - this.radius - top_y, scale_y));
        g.setColor(this.color);
        g.fillArc(tl_x, tl_y, size_x, size_y, 0, 360);
        if (this.mode == 2) {
            int bumper = FP.toInt(FP.mul(this.m_bumper, scale_x));
            g.drawArc(tl_x - bumper, tl_y - bumper, size_x + bumper * 2, size_y + bumper * 2, 0, 360);
        }
    }

    public void load(DataInputStream in) throws IOException {
        this.pos_x = in.readInt();
        this.pos_y = in.readInt();
        this.mode = in.readByte();
        this.bump_power = in.readInt();
        this.color = in.readInt();
        this.radius = in.readInt();
        this.radius2 = FP.mul(this.radius, this.radius);
    }

    public void resolveCollision(Verlet v) {
        if (this.mode == 1) {
            return;
        }
        int dx = v.pos[0] - this.pos_x;
        int dy = v.pos[1] - this.pos_y;
        if (Math.abs(dx) >= this.radius || Math.abs(dy) >= this.radius) {
            return;
        }
        int dist2 = FP.mul(dx, dx) + FP.mul(dy, dy);
        if (dist2 >= this.radius2) {
            return;
        }
        int dist = FP.sqrt(dist2);
        if (dist <= 0) {
            return;
        }
        dx = FP.div(dx, dist);
        dy = FP.div(dy, dist);
        if (this.mode == 2) {
            this.level.star.bump(v, dx, dy, this.bump_power);
            this.m_bumper = g_bumper_max;
        }
        if (this.mode == 3) {
            this.level.star.kill();
            return;
        }
        v.pos[0] = this.pos_x + FP.mul(dx, this.radius);
        v.pos[1] = this.pos_y + FP.mul(dy, this.radius);
        WallSphere.g_temp_vec[0] = -dy;
        WallSphere.g_temp_vec[1] = dx;
        v.applyFriction(g_temp_vec, g_friction_amount);
    }
}

