import java.io.*;
import javax.microedition.lcdui.Graphics;

public abstract class LevelObject
{
    public static final int MODE_NORMAL = 0;
    public static final int MODE_NO_COLLISIONS = 1;
    public static final int MODE_BUMPER = 2;
    public static final int MODE_DEATH = 3;
    
    public Level level;
    public BoundingBox bounding_box;
    
    /** Draw order number (is drawn lower first (under)). */
    int draw_index;
    /** Number used internally by the Levels regionFetch(). */ 
    int region_fetch_cache;
    
    /**
     * Updates the level object.
     * 
     * @param time_secs
     */
    public abstract void update( int time_secs );

    /**
     * Renders the level object.
     */
    public abstract void render( Graphics g, int top_x, int top_y, int scale_x, int scale_y );
    
    /**
     * Loads the object from the stream.
     * 
     * @param in The data stream.
     * @throws IOException
     */
    public abstract void load(DataInputStream in) throws IOException;
}
