package javax.microedition.rms;

import java.applet.*;
import java.io.*;
import java.util.*;

public class RecordStore
{
    private static final String STM_NAME = "stariffic.cfg";
    
    public static Applet g_cur_applet;
    public static boolean g_use_file_io = false;
    
    public static RecordStore openRecordStore(String name, boolean create)
    {
        if (g_cur_applet == null)
            throw new Error();
        return new RecordStore();
    }

    public RecordEnumeration enumerateRecords(Object filter, Object comp, boolean keepUpdated)
    {
        // Use file IO
        if ( g_use_file_io )
        {
            boolean has_data = false;
            
            try
            {
                InputStream in = new FileInputStream(STM_NAME);
                in.close();
                has_data = true;
            }
            catch (Throwable t)
            { }
            
            return new RecordEnumeration( has_data );
        }
        
        // Use applet IO
        boolean has_data = false;
        
        try
        {
            InputStream in = g_cur_applet.getAppletContext().getStream( STM_NAME );
            if ( in != null )
            {
                in.close();
                has_data = true;
            }
        }
        catch ( Throwable t )
        {
        }
        
        return new RecordEnumeration( has_data );
    }

    public void closeRecordStore()
    {
    }

    public byte[] getRecord(int id)
    {
        InputStream in = null;
        
        if ( g_use_file_io )
        {
            try { in = new FileInputStream( STM_NAME ); }
            catch ( Throwable t ) { }
        }
        else
        {
            in = g_cur_applet.getAppletContext().getStream( STM_NAME );
        }
        if ( in == null )
            throw new Error();
        
        try
        {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            
            while ( true )
            {
                int v = in.read();
                if ( v < 0 )
                    break;
                baos.write( v );
            }
            
            return baos.toByteArray();
        }
        catch ( Throwable t )
        {
            throw new Error();
        }
        finally
        {
            try { in.close(); } catch ( Throwable t ) { }
        }
    }

    public int addRecord(byte[] data, int off, int len)
    {
        setRecord( 1, data, off, len );
        return 1;
    }

    public void setRecord(int id, byte[] data, int off, int len)
    {
        if ( g_use_file_io )
        {
            OutputStream out = null;
            try
            {
                out = new FileOutputStream( STM_NAME );
                out.write( data, off, len );
            }
            catch ( Throwable t )
            {
                t.printStackTrace();
            }
            finally
            {
                try { out.close(); } catch ( Throwable t ) { }
            }
            return;
        }

        // Use applet IO
        try
        {
            g_cur_applet.getAppletContext().setStream( STM_NAME, new ByteArrayInputStream( data, off, len ) );
            
/*          System.out.println("Applet streams after save:");
            Iterator keys = g_cur_applet.getAppletContext().getStreamKeys();
            while ( keys.hasNext() )
                System.out.println( keys.next() );*/
        }
        catch ( Throwable t )
        {
            System.out.println( "Saving applet stream failed:" );
            t.printStackTrace();
        }
    }
}
