////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.lcdui.*;

/**
 * A simple particle system.
 */
public class ParticleSystem
{
    private static final int PARTICLE_SIZE = FP.toFP(0.3f);
    
    private Particle m_active;
    private Particle m_free;
    
    public ParticleSystem( int max_particles )
    {
        m_active = new Particle();
        m_free = new Particle();
        
        // Allocate the free particles
        Particle last = m_free;
        for ( int i = 0; i < max_particles; ++i )
        {
            Particle p = new Particle();
            last.next = p;
            last = p;
        }
    }
    
    public void addParticle( int[] pos, int[] vel, int col, int time )
    {
        Particle p = allocate();
        if ( p == null )
            return;
        
        p.time_left = time;
        
        Vec2.set( p.pos, pos );
        if ( vel != null )
            Vec2.set( p.vel, vel );
        else
            Vec2.set( p.vel, 0, 0 );
        p.col = col;
    }
    
    /**
     * Updates the particle system.
     * 
     * @param fp_secs Fixed point seconds of time to update.
     * @param gravity The particle gravity.
     */
    public void update( int fp_secs, int[] gravity )
    {
        Particle last = m_active;
        for ( Particle p = m_active.next; p != null; )
        {
            boolean delete = false;
            
            // Reduce time
            p.time_left -= fp_secs;
            if (p.time_left <= 0)
                delete = true;
            
            // Move and make gravity
            Vec2.addScaled( p.pos, p.pos, p.vel, fp_secs );
            Vec2.addScaled( p.vel, p.vel, gravity, fp_secs );
            
            // Next; delete this is needed
            if (delete)
            {
                last.next = p.next;
                p.next = m_free.next;
                m_free.next = p;
                
                p = last.next;
            }
            else
            {
                last = p;
                p = p.next;
            }
        }
    }
    
    /**
     * Renders the particle system.
     */
    public void render( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        int size = FP.toInt( FP.mul( PARTICLE_SIZE, scale_x) );
        int size2 = size / 2;
        
        for ( Particle p = m_active.next; p != null; p = p.next )
        {
            int x = FP.toInt( FP.mul(p.pos[ 0 ] - top_x, scale_x) );
            int y = FP.toInt( FP.mul(p.pos[ 1 ] - top_y, scale_y) );
            
            g.setColor( p.col );
            g.fillRect( x-size2, y-size2, size, size );
        }
    }
    
    /**
     * Allocates a new particle.
     * 
     * @return The particle (null == no more memory).
     */
    private Particle allocate()
    {
        if ( m_free.next == null )
            return null;
        
        Particle p = m_free.next;
        m_free.next = p.next;
        
        p.next = m_active.next;
        m_active.next = p;
        
        return p;
    }
    
    private static class Particle
    {
        public Particle next;
        
        public int time_left;
        public int[] pos = new int[2];
        public int[] vel = new int[2];
        
        public int col;
    }
}
