////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.rms.*;
import java.io.*;

/**
 * Hiscore holder.
 */
public class Hiscores
{
    private int m_manifest_id;
    private int[] m_scores;
    
    public Hiscores(int manifest_id, int levels)
    {
        if ( !load() || m_manifest_id != manifest_id || m_scores.length != levels )
        { // Create new
            m_manifest_id = manifest_id;
            m_scores = new int[ levels ];
            
            for ( int i = 0; i < m_scores.length; ++i )
                m_scores[ i ] = FP.toFP( -1 );
        }
    }
    
    /**
     * Returns the level score.
     * 
     * @param level The level index.
     * @return The level score or -1 (FP) if invalid level or not scored yet.
     */
    public int getScore( int level )
    {
        if ( level < 0 || level >= m_scores.length )
            return FP.toFP(-1);
        return m_scores[ level ];
    }

    /**
     * Updates the score for the given level.
     * If this is better than the last, then it's updated.
     * 
     * @param level The level index.
     * @param score The new score.
     */
    public void updateScore( int level, int score )
    {
        if ( level < 0 || level >= m_scores.length )
            return;
        
        int old = m_scores[ level ];
        if ( score < old || old < 0 )
        {
            m_scores[ level ] = score;
            save();
        }
    }
    
    /**
     * Saves the hiscores.
     */
    public boolean save()
    {
        RecordStore rs = null;
        try
        {
            rs = RecordStore.openRecordStore("starffic", true);
            
            // Get the record id
            RecordEnumeration renum = rs.enumerateRecords( null, null, false );
            int id = -1;
            if (renum.hasNextElement())
                id = renum.nextRecordId();
            renum.destroy();
            
            // Read the data
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream( baos );
            
            out.writeInt( m_manifest_id );
            
            out.writeShort( m_scores.length );
            for ( int i = 0; i < m_scores.length; ++i )
                out.writeInt( m_scores[ i ] );
                                
            out.close();
            byte[] rdata = baos.toByteArray();
            
            // Set the record
            if ( id == -1 )
                rs.addRecord( rdata, 0, rdata.length );
            else
                rs.setRecord( id, rdata, 0, rdata.length );
        }
        catch (Throwable t)
        {
            System.out.println( "Hiscore save error:" );
            t.printStackTrace();
            return false;
        }
        finally
        {
            try { if (rs != null) rs.closeRecordStore(); } catch (Throwable t) { }
        }
        return true;
    }
    
    /**
     * Loads the hiscores.
     *
     */
    private boolean load()
    {
        RecordStore rs = null;
        try
        {
            rs = RecordStore.openRecordStore("starffic", false);
            
            // Get the record id
            RecordEnumeration renum = rs.enumerateRecords( null, null, false );
            if (!renum.hasNextElement())
            {
                renum.destroy();
                return false;
            }
            int id = renum.nextRecordId();
            renum.destroy();
            
            // Get the record
            byte[] rdata = rs.getRecord( id );
            
            // Read the data
            DataInputStream in = new DataInputStream( new ByteArrayInputStream( rdata ) );
            
            m_manifest_id = in.readInt();
            
            int amt = in.readShort();
            m_scores = new int[ amt ];
            for ( int i = 0; i < amt; ++i )
                m_scores[ i ] = in.readInt();
                                
            in.close();
        }
        catch (Throwable t)
        {
            System.out.println( "Hiscore load error:" );
            t.printStackTrace();
            return false;
        }
        finally
        {
            try { if (rs != null) rs.closeRecordStore(); } catch (Throwable t) { }
        }
        return true;
    }
}
