import java.applet.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import javax.microedition.media.*;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.*;

public class GameApp extends Frame
{
    private WebApplet m_applet;
    
    public GameApp( boolean fullscreen )
    {
        super( "Stariffic" );
        setLocation( 0, 0 );
        if ( fullscreen )
        {
            setExtendedState( MAXIMIZED_BOTH );
            setUndecorated( true );
        }
        else
        {
            setSize( 640, 480 );
        }

        // Add a listener for closing
        addWindowListener(
                new WindowAdapter()
                {
                    public void windowClosing(WindowEvent e)
                    {
                        m_applet.stop();
                        System.exit(0);
                    }
                }
        );
        
        // Configure the libraries
        MIDlet.g_allow_exit = true;
        Manager.g_use_sound_api = true;
        RecordStore.g_use_file_io = true;
        StarifficEditorGame.Res.pc_can_exit = true;

        // Add the applet view
        m_applet = new WebApplet(); 
        add( m_applet );
        addKeyListener(m_applet);
        m_applet.start();
        
        // Create a blank cursor and set it
        int[] pixels = new int[16 * 16];
        Image image = Toolkit.getDefaultToolkit().createImage( new MemoryImageSource(16, 16, pixels, 0, 16) );
        Cursor transparent_cursor =
                Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisible_cursor");
        
        m_applet.setCursor( transparent_cursor );
    }
    
    public static void main(String[] args)
    {
        boolean fullscreen = true;
        for ( int i = 0; i < args.length; ++i )
        {
            if ( args[i].equals("-windowed"))
                fullscreen = false;
        }
        
        GameApp app = new GameApp(fullscreen);
        app.setVisible( true );
    }
}
