/*
 * Decompiled with CFR 0.152.
 */
public class Verlet {
    public int[] pos = Vec2.create();
    public int[] old_pos = Vec2.create();
    private static final int[] g_temp_vec = new int[2];

    public void resetPos(int[] new_pos) {
        Vec2.set(this.pos, new_pos);
        Vec2.set(this.old_pos, new_pos);
    }

    public void setVelocity(int[] vel) {
        Vec2.sub(this.old_pos, this.pos, vel);
    }

    public void addVelocity(int[] vel) {
        Vec2.sub(this.old_pos, vel);
    }

    public void getVelocity(int[] dest_vel) {
        Vec2.sub(dest_vel, this.pos, this.old_pos);
    }

    public void movePosRel(int[] delta_vec) {
        Vec2.add(this.pos, delta_vec);
        Vec2.add(this.old_pos, delta_vec);
    }

    public void applyFriction(int[] tangent, int amt) {
        this.getVelocity(g_temp_vec);
        amt = FP.mul(amt, Vec2.dot(tangent, g_temp_vec));
        Vec2.addScaled(g_temp_vec, g_temp_vec, tangent, -amt);
        this.setVelocity(g_temp_vec);
    }

    public void bump(int nx, int ny, int amt) {
        this.getVelocity(g_temp_vec);
        g_temp_vec[0] = g_temp_vec[0] + FP.mul(nx, amt);
        g_temp_vec[1] = g_temp_vec[1] + FP.mul(ny, amt);
        this.setVelocity(g_temp_vec);
    }

    public void integrate(int time_step_2, int[] accel) {
        int i = 0;
        while (i < 2) {
            int old = this.old_pos[i];
            this.old_pos[i] = this.pos[i];
            this.pos[i] = (this.pos[i] << 1) - old;
            if (accel[i] != 0) {
                int n = i;
                this.pos[n] = this.pos[n] + FP.mul(accel[i], time_step_2);
            }
            ++i;
        }
    }
}

