/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

public final class Rectangle {
    private int width;
    private int height;
    private int x;
    private int y;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setX(x);
        this.setY(y);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public boolean intersect(Rectangle rectangle) {
        return this.inside(rectangle.x, rectangle.y) || this.inside(rectangle.x + rectangle.width, rectangle.y) || this.inside(rectangle.x + rectangle.width, rectangle.y + rectangle.height) || this.inside(rectangle.x, rectangle.y + rectangle.height) || rectangle.inside(this.x, this.y) || rectangle.inside(this.x + this.width, this.y) || rectangle.inside(this.x + this.width, this.y + this.height) || rectangle.inside(this.x, this.y + this.height);
    }

    private boolean inside(int x, int y) {
        return x <= this.getX() + this.getWidth() && x >= this.getX() && y <= this.getY() + this.getHeight() && y >= this.getY();
    }

    public String toString() {
        return "X:" + this.x + " Y:" + this.y + " W:" + this.width + " H:" + this.height;
    }
}

