/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.BSplineCurve;
import cellrace.Car;
import cellrace.ChoiceLine;
import cellrace.Line;
import cellrace.Player;
import cellrace.Point;
import cellrace.Polygon;
import cellrace.PolygonGraphics;
import cellrace.Rectangle;
import cellrace.StraightLine;
import cellrace.Utils;
import cellrace.Vector;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import smallxml.DocHandler;
import smallxml.QDParser;
import utils.Cache;
import utils.Draw;
import utils.Messages;
import utils.PropertyChangeEvent;
import utils.PropertyChangeListener;
import utils.StringTokenizer;
import utils.Timer;

public class Course
extends Messages
implements PropertyChangeListener {
    public final Polygon innerCircle = new Polygon();
    public final Polygon outerCircle = new Polygon();
    public final Polygon smallInnerCircle = new Polygon();
    public final Polygon smallOuterCircle = new Polygon();
    private Grid[] grids;
    private Line startLine;
    private Line[] intermediates;
    private Image roadPattern;
    private Image backgroudPattern;
    public static final int MAX_GRID = 16;
    public static final int MAX_INTERMEDIATE = 16;
    private PlacedImage[] sprites;
    private Rectangle bounds;
    private Player currentPlayer;
    private Image offScreenImage;
    private Player[] players;
    private double ratio;
    private Image[] choices;
    private Image[] selectedChoices;
    private StraightLine chosenPoint = null;
    private int chosenNr = -1;
    private Graphics gx;
    private int chosenGear = -2;
    public static final int GEAR_UP = 1;
    public static final int GEAR_DOWN = -1;
    public static final int GEAR_SAME = 0;
    public static final int GEAR_NONE = -2;
    public static final int GREY = -7303024;
    public static final int MAX_ROUND = 2;

    public void clear() {
        this.innerCircle.clear();
        this.outerCircle.clear();
        this.smallInnerCircle.clear();
        this.smallOuterCircle.clear();
        this.resetHighlight();
        this.offScreenImage = null;
        Cache.remove("score");
        Cache.remove("tree");
        this.grids = null;
        this.players = null;
        this.choices = null;
        this.selectedChoices = null;
        this.currentPlayer = null;
        this.bounds = null;
        this.sprites = null;
        this.backgroudPattern = null;
        this.roadPattern = null;
        this.intermediates = null;
        this.startLine = null;
        this.chosenGear = -2;
        this.chosenNr = -1;
        this.chosenPoint = null;
    }

    public Course(String name) throws Exception {
        this.setBounds(this.loadData(name));
        Image[][] tmp = Utils.createChoiceImages(-1, this.getGrids()[0].getHeigth() * 8 / 14);
        this.choices = tmp[0];
        this.selectedChoices = tmp[1];
    }

    public Vector getStartGrid(int gridposition) {
        return this.grids[gridposition].getMiddle();
    }

    public Vector getStartGridDirection(int gridposition) {
        return this.grids[gridposition].getStartGridDirection();
    }

    public void drawMiniCourse(Graphics g) {
        int i;
        this.gx = g;
        Timer.start("mini course");
        g.setColor(-1);
        if (this.smallOuterCircle.getNrPoints() == 0) {
            i = 0;
            while (i < this.outerCircle.getNrPoints()) {
                this.smallOuterCircle.addPoint((int)((double)this.outerCircle.getXPoints()[i] * this.getRatio()), (int)((double)this.outerCircle.getYPoints()[i] * this.getRatio()));
                ++i;
            }
        }
        PolygonGraphics.drawPolygon(g, this.smallOuterCircle.getXPoints(), this.smallOuterCircle.getYPoints());
        if (this.smallInnerCircle.getNrPoints() == 0) {
            i = 0;
            while (i < this.innerCircle.getNrPoints()) {
                this.smallInnerCircle.addPoint((int)((double)this.innerCircle.getXPoints()[i] * this.getRatio()), (int)((double)this.innerCircle.getYPoints()[i] * this.getRatio()));
                ++i;
            }
        }
        PolygonGraphics.drawPolygon(g, this.smallInnerCircle.getXPoints(), this.smallInnerCircle.getYPoints());
        Timer.stop("mini course");
    }

    public Image drawCourse(int x, int y, int width, int height) {
        Rectangle r = new Rectangle(x, y, width, height);
        Timer.start("course");
        Timer.start("init");
        if (this.offScreenImage == null || this.offScreenImage.getHeight() != height || this.offScreenImage.getWidth() != width) {
            this.offScreenImage = Image.createImage((int)width, (int)height);
        }
        Graphics g = this.offScreenImage.getGraphics();
        g.translate(-x, -y);
        g.setColor(-1);
        g.fillRect(x, y, width, height);
        Timer.stop("init");
        Timer.start("polygon");
        g.setColor(-16777216);
        PolygonGraphics.fillPolygon(g, this.outerCircle.getXPoints(), this.outerCircle.getYPoints());
        g.setColor(-1);
        g.drawString("hallo", 0, 0, 20);
        PolygonGraphics.fillPolygon(g, this.innerCircle.getXPoints(), this.innerCircle.getYPoints());
        g.setColor(-2236963);
        Timer.stop("polygon");
        Timer.start("startline");
        Draw.drawLine(g, this.startLine.getX1(), this.startLine.getY1(), this.startLine.getX2(), this.startLine.getY2(), 3);
        g.setColor(-13619152);
        Draw.drawLine(g, this.startLine.getX1(), this.startLine.getY1(), this.startLine.getX2(), this.startLine.getY2(), 2);
        Timer.stop("startline");
        Timer.start("redwhite");
        BSplineCurve.bspline("outerCircle", g, this.outerCircle.getXPoints(), this.outerCircle.getYPoints(), -4509648, -4473925, -3395536, -3355444, -2281424, -2236963, r);
        BSplineCurve.bspline("innerCircle", g, this.innerCircle.getXPoints(), this.innerCircle.getYPoints(), -4509648, -4473925, -3395536, -3355444, -2281424, -2236963, r);
        Timer.stop("redwhite");
        Timer.start("grid");
        g.setColor(-986896);
        int j = 0;
        while (j < this.getGrids().length) {
            this.getGrids()[j].drawGrid(g);
            ++j;
        }
        Timer.stop("grid");
        Timer.start("background");
        Image background = Draw.applyTexture(this.offScreenImage, this.backgroudPattern, this.roadPattern);
        Timer.stop("background");
        Timer.start("sprite");
        Image copy = Image.createImage((int)background.getWidth(), (int)background.getHeight());
        Graphics g2 = copy.getGraphics();
        g2.drawImage(background, 0, 0, 20);
        g2.translate(-x, -y);
        int i = 0;
        while (i < this.sprites.length) {
            Image sprite = Utils.createThumbnail("tree", this.sprites[i].getName(), this.sprites[i].getRectangle().getWidth(), this.sprites[i].getRectangle().getHeight());
            g2.drawImage(sprite, this.sprites[i].rectangle.getX(), this.sprites[i].rectangle.getY(), 20);
            ++i;
        }
        Timer.stop("sprite");
        Timer.stop("course");
        return copy;
    }

    public void drawRound(Graphics g, int x, int y) {
        Player[] players = this.getPlayers();
        int i = 0;
        while (i < players.length) {
            Image car;
            Vector v = new Vector(-1.0, 0.0);
            double angle = players[i].getPosition().getDirection().angel(v);
            if (!v.leftOf(players[i].getPosition().getDirection())) {
                angle = Math.PI * 2 - angle;
            }
            angle = angle / Math.PI * 180.0;
            Point translate = new Point(0, players[i].getCar().getCarImage().getHeight() / 2);
            if (!players[i].isCrashed()) {
                car = Draw.rotate(players[i].getCar().getCarImage(), translate, (int)angle);
                g.drawImage(car, (int)players[i].getPosition().getStart().getX() - x + translate.getX(), (int)players[i].getPosition().getStart().getY() - y + translate.getY(), 20);
            } else {
                car = Draw.rotate(players[i].getCar().getCrashedCarImage(), translate, (int)angle);
                g.drawImage(car, (int)players[i].getPosition().getStart().getX() - x + translate.getX(), (int)players[i].getPosition().getStart().getY() - y + translate.getY(), 20);
            }
            g.setColor(players[i].isCrashed() ? -7303024 : players[i].getCar().getCarColor());
            g.fillRoundRect((int)(players[i].getPosition().getStart().getX() * this.getRatio()) - 3, (int)(players[i].getPosition().getStart().getY() * this.getRatio()) - 3, 6, 6, 3, 3);
            ++i;
        }
    }

    public void drawChoices(Graphics g, int biasx, int biasy) {
        ChoiceLine[] next = this.checkValidity(this.getCurrentPlayer(), biasx, biasy);
        int i = 0;
        while (next != null && i < next.length) {
            if (next[i] != null && next[i].isValid()) {
                int width = this.choices[8 - i].getWidth();
                int heigth = this.choices[8 - i].getHeight();
                if (this.chosenPoint != null && next[i].equals(this.chosenPoint)) {
                    Vector v = this.getCurrentPlayer().getPosition().getStart();
                    g.setColor(this.getCurrentPlayer().getCar().getCarColor());
                    g.drawLine((int)v.getX() - biasx, (int)v.getY() - biasy, (int)this.chosenPoint.getX1() - biasx, (int)this.chosenPoint.getY1() - biasy);
                    g.drawImage(this.selectedChoices[8 - i], (int)next[i].getStart().getX() - width / 2 - biasx, (int)next[i].getStart().getY() - heigth / 2 - biasy, 20);
                } else {
                    g.drawImage(this.choices[8 - i], (int)next[i].getStart().getX() - width / 2 - biasx, (int)next[i].getStart().getY() - heigth / 2 - biasy, 20);
                }
            }
            ++i;
        }
    }

    public void drawScore(Graphics g, int x, int y) {
        int heigth = y;
        int i = this.players.length - 1;
        while (i >= 0) {
            Image bi = null;
            bi = this.players[i] == this.getCurrentPlayer() ? Utils.writeLine("score", this.players[i].getName(), 0x60000000) : Utils.writeLine("score", this.players[i].getName(), 0);
            g.drawImage(bi, 0, heigth -= bi.getHeight(), 20);
            --i;
        }
    }

    public void drawGameOver(Graphics g, int width, int height) {
        Image gameover = Utils.createThumbnail("tmp", "gameover", -1, (int)((double)height * this.getRatio()), false);
        g.drawImage(gameover, (width - gameover.getWidth()) / 2, gameover.getHeight() / 2, 20);
        height = gameover.getHeight() / 2 + gameover.getHeight();
        int i = 0;
        while (i < this.players.length) {
            StringBuffer sb = new StringBuffer();
            sb.append(i + 1);
            sb.append(".");
            sb.append(this.players[i].getName());
            sb.append("-");
            String nr = "";
            if (this.players[i].isFinished() && this.players[i].getScore().getRound() == 2) {
                nr = "" + this.players[i].getScore().getStep();
            }
            int j = nr.length();
            while (j < 3) {
                sb.append(" ");
                ++j;
            }
            sb.append(nr);
            Image line = Utils.writeLine("score", sb.toString(), 0x60000000);
            if (i == 0) {
                height += line.getHeight();
            }
            g.drawImage(line, (width - line.getWidth()) / 2, height, 20);
            height += line.getHeight() + 2;
            ++i;
        }
    }

    public void drawHistory(Graphics g, int x, int y) {
        int i = 0;
        while (i < this.players.length) {
            Car car = this.players[i].getCar();
            g.setColor(car.getCarColor());
            int len = this.players[i].getHistory().size() - 5;
            int j = len < 1 ? 1 : len;
            while (j < this.players[i].getHistory().size()) {
                Vector oldValue = (Vector)this.players[i].getHistory().elementAt(j - 1);
                Vector newValue = (Vector)this.players[i].getHistory().elementAt(j);
                g.drawLine((int)oldValue.getX() - x, (int)oldValue.getY() - y, (int)newValue.getX() - x, (int)newValue.getY() - y);
                ++j;
            }
            ++i;
        }
    }

    public void highlight(Point point, int x, int y) {
        ChoiceLine[] next = this.checkValidity(this.getCurrentPlayer(), x, y);
        int i = 0;
        while (next != null && i < next.length) {
            if (next[i] != null) {
                int width = this.choices[8 - i].getWidth() / 2;
                if (next[i].getStart().toPoint().distance(point) < width && next[i].isValid()) {
                    this.chosenPoint = next[i];
                    this.chosenNr = i;
                    if (i >= 0 && i < 3) {
                        this.chosenGear = -1;
                    } else if (i >= 3 && i < 6) {
                        this.chosenGear = 0;
                    } else if (i >= 6 && i < 9) {
                        this.chosenGear = 1;
                    }
                    return;
                }
                this.chosenPoint = null;
                this.chosenGear = -2;
                this.chosenNr = -1;
            }
            ++i;
        }
    }

    public boolean isHighlight(int nr) {
        if (this.isHighlight()) {
            return this.chosenNr == nr;
        }
        return false;
    }

    public boolean isHighlight() {
        return this.chosenPoint != null && this.chosenGear != -2 && this.chosenNr != -1;
    }

    public void highlight(int nr, int x, int y) {
        ChoiceLine[] next = this.checkValidity(this.getCurrentPlayer(), x, y);
        if (next[nr] != null && next[nr].isValid()) {
            this.chosenPoint = next[nr];
            this.chosenNr = nr;
            if (nr >= 0 && nr < 3) {
                this.chosenGear = -1;
            } else if (nr >= 3 && nr < 6) {
                this.chosenGear = 0;
            } else if (nr >= 6 && nr < 9) {
                this.chosenGear = 1;
            }
            return;
        }
        this.chosenPoint = null;
        this.chosenGear = -2;
        this.chosenNr = -1;
    }

    private boolean intersect(Polygon a, Polygon b) {
        int i = 0;
        while (i < a.getNrPoints()) {
            if (b.contains(a.getXPoints()[i], a.getYPoints()[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < b.getNrPoints()) {
            if (a.contains(b.getXPoints()[i], b.getYPoints()[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ChoiceLine[] checkValidity(Player player, int x, int y) {
        ChoiceLine[] next = this.getCurrentPlayer().getChoices();
        int i = 0;
        while (i < next.length) {
            if (next[i] != null) {
                if (this.outerCircle.contains(next[i].getStart().toPoint()) && !this.innerCircle.contains(next[i].getStart().toPoint())) {
                    StraightLine tmp = new StraightLine(this.getCurrentPlayer().getPosition().getStart(), next[i].getDirection());
                    Vector[] v = tmp.split(5);
                    int j = 0;
                    while (j < v.length) {
                        if (!this.outerCircle.contains(v[j].toPoint()) || this.innerCircle.contains(v[j].toPoint())) {
                            next[i].setValid(false);
                            break;
                        }
                        next[i].setValid(true);
                        ++j;
                    }
                    int k = 0;
                    while (k < this.players.length) {
                        if (this.players[k] != player && next[i].isValid()) {
                            if (!this.intersect(this.players[k].getBounds(this.players[k].getPosition()), player.getBounds(next[i]))) {
                                next[i].setValid(true);
                            } else {
                                next[i].setValid(false);
                            }
                        }
                        ++k;
                    }
                } else {
                    next[i].setValid(false);
                }
            }
            ++i;
        }
        i = 0;
        while (i < next.length) {
            if (next[i] != null && next[i].isValid()) {
                return next;
            }
            ++i;
        }
        player.setCrashed(true);
        return next;
    }

    public void end() {
        this.firePropertyChange("GAME_OVER", null, null);
    }

    private Rectangle loadData(String name) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(name);
        InputStreamReader br = new InputStreamReader(is);
        final Hashtable gridTmp = new Hashtable();
        final java.util.Vector spritesTmp = new java.util.Vector();
        final Hashtable patternTmp = new Hashtable();
        final Hashtable intermediatesTmp = new Hashtable();
        System.err.println("loading data");
        QDParser.parse(new DocHandler(){
            String patternName = null;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void startElement(String tag, Hashtable h) throws Exception {
                System.err.println("found element " + tag);
                if (tag.equals("path")) {
                    Point point;
                    Enumeration e;
                    if (!h.containsKey("inkscape:label")) throw new Exception("Parser Error, label not found");
                    System.err.println("found inkscape:label");
                    if (!h.containsKey("d")) throw new Exception("Parser Error, d not found");
                    System.err.println("found d");
                    String data = (String)h.get("d");
                    java.util.Vector points = this.getPoints(data);
                    String attribute = (String)h.get("inkscape:label");
                    System.err.println("found attribute " + attribute);
                    if (attribute.equals("#outer")) {
                        System.err.println("found element outer");
                        e = points.elements();
                        while (e.hasMoreElements()) {
                            point = (Point)e.nextElement();
                            Course.this.outerCircle.addPoint(point.getX(), point.getY());
                        }
                        if (h.containsKey("style")) {
                            String name = (String)h.get("style");
                            if ((name = this.getNameFromStyle(name)) != null) {
                                Course.this.roadPattern = (Image)patternTmp.get(name);
                            }
                        }
                    }
                    if (attribute.equals("#inner")) {
                        System.err.println("found element inner");
                        e = points.elements();
                        while (e.hasMoreElements()) {
                            point = (Point)e.nextElement();
                            Course.this.innerCircle.addPoint(point.getX(), point.getY());
                        }
                    }
                    if (attribute.equals("#start")) {
                        System.err.println("found element start");
                        if (points.size() != 2) throw new Exception("Parser Error, Startline needs exactely two points");
                        Course.this.startLine = new Line((Point)points.elementAt(0), (Point)points.elementAt(1));
                    }
                    int i = 1;
                    while (i < 16) {
                        if (attribute.equals("#grid" + i)) {
                            System.err.println("found element grid" + i);
                            Grid tmp = new Grid();
                            Enumeration it = points.elements();
                            Point pointOld = null;
                            while (it.hasMoreElements()) {
                                Point point2 = (Point)it.nextElement();
                                if (pointOld != null) {
                                    tmp.addGrid(new Line(pointOld.getX(), pointOld.getY(), point2.getX(), point2.getY()));
                                }
                                pointOld = point2;
                            }
                            gridTmp.put(new Integer(i - 1), tmp);
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < 16) {
                        if (attribute.equals("#intermediate" + i)) {
                            System.err.println("found element intermediate" + i);
                            Point p1 = (Point)points.elementAt(0);
                            Point p2 = (Point)points.elementAt(1);
                            System.err.println(attribute);
                            intermediatesTmp.put(new Integer(i - 1), new Line(p1.getX(), p1.getY(), p2.getX(), p2.getY()));
                        }
                        ++i;
                    }
                    return;
                }
                if (tag.equals("pattern")) {
                    this.patternName = (String)h.get("id");
                    return;
                }
                if (tag.equals("rect")) {
                    if (!h.containsKey("inkscape:label") || !h.containsKey("style") || !h.containsKey("width") || !h.containsKey("height") || !h.containsKey("x") || !h.containsKey("y") || !h.get("inkscape:label").equals("#background")) return;
                    String name = (String)h.get("style");
                    name = this.getNameFromStyle(name);
                    Course.this.backgroudPattern = (Image)patternTmp.get(name);
                    return;
                }
                if (!tag.equals("image")) return;
                if (!h.containsKey("xlink:href") || !h.containsKey("x") || !h.containsKey("y") || !h.containsKey("width") || !h.containsKey("height")) throw new Exception("Parser Error, image not found");
                try {
                    System.err.println("load /" + h.get("xlink:href"));
                    Image image = Utils.createImage("sprite", (String)h.get("xlink:href"));
                    if (this.patternName != null) {
                        patternTmp.put(this.patternName, image);
                    } else {
                        int x = (int)Double.parseDouble((String)h.get("x"));
                        int y = (int)Double.parseDouble((String)h.get("y"));
                        int width = (int)Double.parseDouble((String)h.get("width"));
                        int height = (int)Double.parseDouble((String)h.get("height"));
                        PlacedImage placedImage = new PlacedImage((String)h.get("xlink:href"), image, new Rectangle(x, y, width, height));
                        System.err.println("add sprite x=" + x + " y=" + y + " w=" + width + " h=" + height);
                        spritesTmp.addElement(placedImage);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new Exception("Parser Error, nfe" + nfe);
                }
                this.patternName = null;
            }

            private String getNameFromStyle(String value) {
                int start = value.indexOf("fill:url(#");
                int stop = value.indexOf(")", start);
                value = start >= 0 && stop > 0 && start < stop ? value.substring(start + "fill:url(#".length(), stop) : null;
                return value;
            }

            public void endElement(String tag) throws Exception {
            }

            public void startDocument() throws Exception {
            }

            public void endDocument() throws Exception {
                System.err.println("End of document");
                Course.this.setGrids(new Grid[gridTmp.size()]);
                Enumeration<Object> e = gridTmp.keys();
                while (e.hasMoreElements()) {
                    Integer myint = (Integer)e.nextElement();
                    Course.this.getGrids()[myint.intValue()] = (Grid)gridTmp.get(myint);
                }
                Course.this.sprites = new PlacedImage[spritesTmp.size()];
                e = spritesTmp.elements();
                int i = 0;
                while (e.hasMoreElements()) {
                    ((Course)Course.this).sprites[i] = (PlacedImage)e.nextElement();
                    ++i;
                }
                Course.this.intermediates = new Line[intermediatesTmp.size() + 1];
                ((Course)Course.this).intermediates[0] = Course.this.startLine;
                e = intermediatesTmp.keys();
                while (e.hasMoreElements()) {
                    Integer myint = (Integer)e.nextElement();
                    ((Course)Course.this).intermediates[myint.intValue() + 1] = (Line)intermediatesTmp.get(myint);
                }
            }

            public void text(String str) throws Exception {
            }

            private java.util.Vector getPoints(String line) throws Exception {
                java.util.Vector<Point> returnList = new java.util.Vector<Point>();
                if (line.indexOf("M ") != 0) {
                    throw new Exception("parser error in line handling (M 123,13 L 23,43)");
                }
                line = line.substring(2);
                if (line.indexOf(" z") > 0) {
                    line = line.substring(0, line.length() - 2);
                }
                StringTokenizer st = new StringTokenizer(line, "L");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    try {
                        double x = Double.parseDouble(token.substring(0, token.indexOf(44)));
                        double y = Double.parseDouble(token.substring(token.indexOf(44) + 1));
                        Point p = new Point((int)x, (int)y);
                        returnList.addElement(p);
                    }
                    catch (NumberFormatException nfe) {
                        throw new Exception("Parser Error, nfe" + nfe);
                    }
                }
                return returnList;
            }
        }, br);
        if (this.outerCircle.getNrPoints() == 0) {
            throw new RuntimeException("No outer circle found");
        }
        if (this.innerCircle.getNrPoints() == 0) {
            throw new RuntimeException("No inner circle found");
        }
        if (this.getGrids().length == 0) {
            throw new RuntimeException("No grides found");
        }
        if (this.startLine == null) {
            throw new RuntimeException("No startline found");
        }
        Rectangle courseSize = new Rectangle();
        courseSize.setWidth(this.outerCircle.getBounds().getWidth() + this.outerCircle.getBounds().getX() + 20);
        courseSize.setHeight(this.outerCircle.getBounds().getHeight() + this.outerCircle.getBounds().getY() + 20);
        return courseSize;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setCurrentPlayer(Player currentPlayer) {
        Player tmp = this.getCurrentPlayer();
        this.currentPlayer = currentPlayer;
        this.firePropertyChange("CURRENT_PLAYER", tmp, currentPlayer);
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setGrids(Grid[] grids) {
        this.grids = grids;
    }

    public Grid[] getGrids() {
        return this.grids;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SET_POSITON")) {
            Line raceLine;
            Player p = (Player)evt.getSource();
            Vector v1 = (Vector)((StraightLine)evt.getNewValue()).getStart().clone();
            Vector v2 = (Vector)((StraightLine)evt.getOldValue()).getStart().clone();
            StraightLine startLine2 = this.startLine.toStraightLine();
            if (startLine2.intersect(raceLine = new Line((int)v2.getX(), (int)v2.getY(), (int)v1.getX(), (int)v1.getY())) != null) {
                System.err.println("Player " + p.getName() + " Intersection point" + startLine2.intersect(raceLine));
                System.err.println("Startline  " + p.getName() + " " + startLine2 + " has been crossed by " + raceLine);
                int round = p.getScore().incRound();
                if (round >= 2) {
                    System.err.println("Player " + p.getName() + " has finished");
                    p.setFinished(true);
                }
            }
            v1.sub(v2);
            StraightLine step = new StraightLine(v2, v1);
            this.checkIntermediates(p, step);
        }
    }

    private void checkIntermediates(Player player, StraightLine step) {
        int inter = 1;
        int i = 0;
        while (i < this.intermediates.length) {
            double distance = this.checkIntermediate(this.intermediates[i], step);
            if (!Double.isNaN(distance)) {
                System.err.print("Player " + player.getName() + " crossed intermediate " + inter);
                player.getScore().updateScore(inter, distance);
            } else {
                player.getScore().addScore(step.getLength());
            }
            ++inter;
            ++i;
        }
    }

    private double checkIntermediate(Line line, StraightLine step) {
        Point point2D = step.intersect(line);
        if (point2D == null) {
            return Double.NaN;
        }
        System.err.println("Yes crossed the line, distance is " + point2D.distance(step.getStop().toPoint()));
        return point2D.distance(step.getStop().toPoint());
    }

    public void setPlayers(Player[] players) {
        this.players = players;
    }

    public Player[] getPlayers() {
        return this.players;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }

    public StraightLine getChosenPoint() {
        return this.chosenPoint;
    }

    public int getChosenGear() {
        return this.chosenGear;
    }

    public void checkSlipStream(Player player) {
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i] != player) {
                if (this.intersect(this.players[i].getBounds(this.players[i].getPosition()), player.getSlipStreamBounds())) {
                    player.getCar().setSlipstream(true);
                    System.err.println("slipstream on");
                } else {
                    player.getCar().setSlipstream(false);
                    System.err.println("slipstream off");
                }
            }
            ++i;
        }
    }

    public void resetHighlight() {
        this.chosenGear = -2;
        this.chosenNr = -1;
        this.chosenPoint = null;
    }

    public class Grid {
        final Line[] grids = new Line[3];
        private int current = 0;

        void addGrid(Line line) {
            this.grids[this.current] = line;
            ++this.current;
        }

        void drawGrid(Graphics g) {
            int i = 0;
            while (i < this.grids.length) {
                g.setColor(-3223858);
                Draw.drawLine(g, this.grids[i].getX1(), this.grids[i].getY1(), this.grids[i].getX2(), this.grids[i].getY2(), 2);
                g.setColor(-1118482);
                Draw.drawLine(g, this.grids[i].getX1(), this.grids[i].getY1(), this.grids[i].getX2(), this.grids[i].getY2(), 1);
                ++i;
            }
        }

        Vector getMiddle() {
            double x = 0.0;
            double y = 0.0;
            int size = this.grids.length;
            int i = 0;
            while (i < size) {
                x += (double)this.grids[i].getX1();
                y += (double)this.grids[i].getY1();
                x += (double)this.grids[i].getX2();
                y += (double)this.grids[i].getY2();
                ++i;
            }
            return new Vector(x / (double)(size * 2), y / (double)(size * 2));
        }

        Vector getStartGridDirection() {
            Vector v1 = new Vector(this.grids[0].getX1(), this.grids[0].getY1());
            Vector v2 = new Vector(this.grids[0].getX2(), this.grids[0].getY2());
            v2.sub(v1);
            return v2;
        }

        public int getHeigth() {
            return this.grids[1].length();
        }
    }

    private class PlacedImage {
        private final Image image;
        private final Rectangle rectangle;
        private final String name;

        public PlacedImage(String name, Image image, Rectangle rectangle) {
            this.image = image;
            this.rectangle = rectangle;
            this.name = name;
        }

        private Image getImage() {
            return this.image;
        }

        private Rectangle getRectangle() {
            return this.rectangle;
        }

        public String getName() {
            return this.name;
        }
    }
}

