/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Rectangle;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Car {
    private Image carImage;
    private Image crashedCarImage;
    private GearBox gearBox;
    private Rectangle dimension;
    private boolean slipstream = false;
    private double slipfactor = 0.1;
    private int carColor;
    private int currentGear;

    public void clear() {
        this.currentGear = 0;
    }

    public Car(Image carImage, Image crashedCarImage, int carColor) {
        this.dimension = new Rectangle(carImage.getWidth(), carImage.getHeight());
        this.setCarImage(carImage);
        this.setCrashedCarImage(crashedCarImage);
        this.gearBox = new GearBox();
        this.setCarColor(carColor);
    }

    public Rectangle getBounds() {
        return this.dimension;
    }

    public void addGear(double angle, double distance) {
        this.gearBox.addGear(angle, distance);
    }

    public int gearSize() {
        return this.gearBox.getGears().size();
    }

    public double getGearAngle(int gear, boolean ignoreSlipstream) {
        if (!this.isSlipstream() || ignoreSlipstream) {
            return ((GearBox.Gear)this.gearBox.getGears().elementAt(gear)).getAngle();
        }
        return ((GearBox.Gear)this.gearBox.getGears().elementAt(gear)).getAngle() / (1.0 + this.slipfactor * (double)this.getCurrentGear());
    }

    public double getGearDistance(int gear, boolean ignoreSlipstream) {
        if (!this.isSlipstream() || ignoreSlipstream) {
            return ((GearBox.Gear)this.gearBox.getGears().elementAt(gear)).getDistance();
        }
        return ((GearBox.Gear)this.gearBox.getGears().elementAt(gear)).getDistance() * (1.0 + this.slipfactor * (double)this.getCurrentGear());
    }

    private void setCarImage(Image carImage) {
        this.carImage = carImage;
    }

    public Image getCarImage() {
        return this.carImage;
    }

    public Image getCrashedCarImage() {
        return this.crashedCarImage;
    }

    public void setCrashedCarImage(Image crashedCarImage) {
        this.crashedCarImage = crashedCarImage;
    }

    public void setSlipstream(boolean slipstream) {
        this.slipstream = slipstream;
    }

    public boolean isSlipstream() {
        return this.slipstream;
    }

    public void setCarColor(int carColor) {
        this.carColor = carColor;
    }

    public int getCarColor() {
        return this.carColor;
    }

    public void setCurrentGear(int currentGear) {
        this.currentGear = currentGear;
    }

    public int getCurrentGear() {
        return this.currentGear;
    }

    public void incCurrentGear() {
        ++this.currentGear;
    }

    public void decCurrentGear() {
        --this.currentGear;
    }

    private class GearBox {
        private Vector gears = new Vector();

        public void addGear(double angle, double distance) {
            this.gears.addElement(new Gear(angle, distance));
        }

        public Vector getGears() {
            return this.gears;
        }

        private class Gear {
            private double angle;
            private double distance;

            public Gear(double angle, double distance) {
                this.setDistance(distance);
                this.setAngle(angle);
            }

            private void setDistance(double distance) {
                this.distance = distance;
            }

            public double getDistance() {
                return this.distance;
            }

            private void setAngle(double angle) {
                this.angle = angle;
            }

            public double getAngle() {
                return this.angle;
            }
        }
    }
}

