#ifndef levelselector_h
#define levelselector_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "eventhandler.h"

//############################################################################
// Define ####################################################################
//############################################################################

// Forward declaration.
class LevelItem;

//############################################################################
// Class #####################################################################
//############################################################################

/** The Challenge screen. A singleton, that presents the challenge selection.
 */
class LevelSelector :
  public EventHandler
{
  protected:
    /** All the distinct challenges available. */
    std::vector<LevelItem*> items;

    /** Map mapping level names to items. */
    std::map<std::string, LevelItem*> item_map;

    /** Current level item to hilight. */
    size_t current_item;

    /** Score file. */
    std::string score_file;

  public:
    LevelSelector(const char*);
    virtual ~LevelSelector();

  protected:
    void read_scores(const char*);
    void save_scores();

  public:
    virtual void draw(libfhi::Surface*);
    virtual void keydown(int);

  public:
    inline LevelItem* get_current_level();
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get the level currently selected.
 * @return Level pointer.
 */
LevelItem* LevelSelector::get_current_level()
{
  return this->items[this->current_item];
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

