#include "gamestorymode.h"

#include "entity.h"
#include "weapon.h"

//############################################################################
// Construction ##############################################################
//############################################################################

/** Default constructor.
 * @param filename Filename to load the parameters from.
 */
GameStoryMode::GameStoryMode(const char *filename)
  : Game(filename)
{
  // Create entity.
  Entity *plr = this->entity_new(ENTITY_R_9A, FACTION_ENEMY);
  plr->set_pos(16.0f, 15.0f);

  // Create new player.
  plr = this->entity_new(ENTITY_RX_10, FACTION_ENEMY);
  plr->set_pos(16.0f, 14.5f);

  // We follow and control our player.
  this->follow = plr;
  this->player = plr;

  // There is no bullet time in story mode.
  Weapon::set_slowdown(1.0f);
}

/** Default destructor. */
GameStoryMode::~GameStoryMode()
{
  // Do nothing.
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Only clear here, leave drawing method itself to the Game.
 * @param screen Screen to output to.
 */
void GameStoryMode::draw(libfhi::Surface *screen)
{
  // Clear only the depth buffer, since all will be drawn.
  screen->clear(libfhi::Boundary::ZBUFFER_MAX);

  // Use host drawing method for objects.
  Game::draw(screen);
}

//############################################################################
// End #######################################################################
//############################################################################

