#ifndef enums_h
#define enums_h

//############################################################################
// Definitions ###############################################################
//############################################################################

/** No faction. */
static const int FACTION_NONE = 0x0;

/** Faction. */
static const int FACTION_ENEMY = 0x1;

/** Faction. */
static const int FACTION_PLAYER = 0x2;

/** Mask for faction data. */
static const int FACTION_MASK = 0x3;

/** Shift for number index. */
static const int FACTION_SHIFT = 2;

/** Weapon types are limited, they are iterated all in one. */
enum WeaponEnum
{
  WEAPON_BLASTER_BYDO,
  WEAPON_BLASTER_NORMAL,
  WEAPON_BULLET_BYDO,
  WEAPON_GEMINI,
  WEAPON_MISSILE_EYEBALL,
  WEAPON_MISSILE_LRM,
  WEAPON_MISSILE_NULAYLAF,
  WEAPON_MISSILE_PHOTON,
  WEAPON_MISSILE_SRM,
  WEAPON_PULSAR,
  WEAPON_TAITO_LASER,
  WEAPON_WAVE_CANNON_DEVIL_WAVE,	
  WEAPON_WAVE_CANNON_MINI_BURST,
  WEAPON_WAVE_CANNON_PHOTON_BELT,
  WEAPON_WAVE_CANNON_SHOCK,
  WEAPON_WAVE_CANNON_STANDARD,
  WEAPON_COUNT
};

/** Entity types are listed here. */
enum EntityEnum
{
  ENTITY_B_1A3,
  ENTITY_B_1D3,
  ENTITY_BX_2,
  ENTITY_GENON,
  ENTITY_INTERDIMENSIONAL_BATTLESHIP,
  ENTITY_LIGHTBYDO,
  ENTITY_NULAYLAF,
  ENTITY_NULAYRAGOM,
  ENTITY_PSYVARIAR_BOSS,
  ENTITY_R_11A,
  ENTITY_R_11S2,
  ENTITY_R_13A,
  ENTITY_R_13B,
  ENTITY_R_9A,
  ENTITY_R_9B2,
  ENTITY_R_9D,
  ENTITY_R_9D2,
  ENTITY_R_9DH2,
  ENTITY_R_9DV2,
  ENTITY_R_9K,
  ENTITY_R_9O,
  ENTITY_RVA_818,
  ENTITY_RX_10,
  ENTITY_SURGE,
  ENTITY_TX_T,
  ENTITY_COUNT
};

/** Limited number of commands to check through. */
enum CommandEnum
{
  COMMAND_FORWARD = 0,
  COMMAND_BACKWARD,
  COMMAND_RIGHT,
  COMMAND_LEFT,
  COMMAND_FIRE,
  COMMAND_ABSORB,
  COMMAND_TARGET,
  COMMAND_TOTAL
};

/** Type of a particle. There are several different ones. */
enum ParticleEnum
{
  PARTICLE_SPARK = 0,
  PARTICLE_PUFF,
  PARTICLE_EXPLOSION,
  PARTICLE_HEX,
  PARTICLE_BOOM
};

/** The encyclopedia page types. */
enum EncyclopediaEnum
{
  ENCYCLOPEDIAPAGE_NORMAL,
  ENCYCLOPEDIAPAGE_SPECIFICATION
};

/** Enum for differentiating thursters. */
enum ThursterEnum
{
  THURST_FW = 0,
  THURST_BK,
  THURST_RT,
  THURST_LT,
  THURSTER_COUNT
};

/** Different types of effects. */
enum EffectEnum
{
  EFFECT_DEFAULT = 0,
  EFFECT_BEAM = 1,
  EFFECT_THURSTER = 2,
  EFFECT_CHARGE = 3
};

//############################################################################
// Inline methods ############################################################
//############################################################################

/** Tells if two factions can collide.
 * @param op1 First faction.
 * @param op2 Second faction.
 * @return True if yes, false if no.
 */
inline bool is_faction_collidable(int op1, int op2)
{
  return (op1 != op2);
}

/** Tell if is same faction.
 * @param op1 First faction.
 * @param op2 Second faction.
 * @return True if yes, false if no.
 */
inline bool is_faction_same(int op1, int op2)
{
  return ((op1 & FACTION_MASK) == (op2 & FACTION_MASK));
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

