#ifndef constants_h
#define constants_h

//############################################################################
// Includes ##################################################################
//############################################################################

#include "libfhi.h"

#include "enums.h"

//############################################################################
// Defined variables #########################################################
//############################################################################

/** Maximum number of absorb fire targets. */
static const int ABSORB_FIRE_TARGETS = 42;

/** Maximum time spent in absorb state. */
static const int ABSORB_TIME_MAX = 500;

/** Wait time threshold. */
static const int ABSORB_WAIT_THRESHOLD = 300;

/** Absorb time penalty multiplier. */
static const float ABSORB_TIME_PENALTY = -1.2f;

/** Default aiming distance. */
static const float AI_DEFAULT_AIM_PROXIMITY = 5.0f;

/** Probability, with which the dumbwalker forgets to track enemies. */
static const int AI_DUMBWALKER_FORGET = 2;

/** Number of feasible targets AI considers when selecting them. */
static const int AI_FEASIBLE_TARGETS = 5;

/** The angle difference AI requires to fire. */
static const int AI_FIRE_ARC = 2000;

/** The possible number of nodes AI looks forward to for orientation. */
static const int AI_NODE_LOOKAHEAD = 8;

/** The possible number of nodes AI skips if it happens to be close. */
static const int AI_NODE_SKIP = 5;

/** Minimum delay for a new AI path search. */
static const int AI_PATH_SEARCH_DELAY = 75;

/** Proximity (squared) in which AI has reached it's destination. */
static const float AI_REACH_PROXIMITY = 1.0f;

/** Possibility with which the rtype ai reselects it's destination. */
static const int AI_RETHINK_BATTLESHIP = 5000;

/** Possibility with which the rtype ai reselects it's destination. */
static const int AI_RETHINK_DUMBWALKER = 200;

/** Possibility with which the rtype ai reselects it's destination. */
static const int AI_RETHINK_RTYPE = 750;

/** Turret fire arc, do not try to fire if angle difference greater. */
static const int AI_TURRET_FIRE_ARC = 5000;

/** Turret reselect probability. */
static const int AI_TURRET_RESELECT_DELAY = 50;

/** Turret reselect probability. */
static const int AI_TURRET_RESELECT = 350;

/** Distance the turrets track targets. */
static const float AI_TURRET_TRACK_DISTANCE = 5.5f;

/** The number of times AI tries to get the point anew. */
static const int AI_VINCINITY_RETRY_COUNT = 20;

/** Square radius within which vincinity selection works. */
static const float AI_VINCINITY_SELECTION = 4.0f;

/** How many tics does it take to generate charge particles. */
static const int EFFECT_CHARGE_TOLERANCE = 25;

/** Probability with which entities bleed. */
static const int ENTITY_BLEED_BORDER = 4;

/** Probability with which entities bleed. */
static const int ENTITY_BLEED_PROBABILITY = 100;

/** How many tomes to try to insert an entity before giving up? */
static const int ENTITY_INSERTION_TRY_COUNT = 256;

/** Tilt maximum. */
static const int ENTITY_TILT_MAXIMUM = 4096;

/** Maxmimum object difficulty. */
static const int GAME_DIFFICULTY_MAX = 5;

/** How much tame it takes for the game to end after player death. */
static const int GAME_END_DELAY = 200;

/** How many entities does one phase point represent. */
static const int GAME_PHASE_POINT_RATIO = 8;

/** Game phase timeout. */
static const int GAME_PHASE_TIMEOUT = 400;

/** Safe distance to leave between the player and any generated entity. */
static const float GAME_SAFE_DISTANCE = 8.0f;

/** Survival bullet slowdown scale. */
static const float GAME_SURVIVAL_BULLET_SLOWDOWN = 0.55f;

/** Time bonus scale (seconds) for multipliers (see: Mars Matrix). */
static const int GAME_TIME_BONUS_AREA = 8;

/** Time bonus granularity, should be same as ticks per second. */
static const int GAME_TIME_BONUS_GRANULARITY = 100;

/** Ligth bydo revolve speed. */
static const int LIGHTBYDO_REVOLVE_SPEED = 512;

/** Regeneration speed of light bydo. */
static const int LIGHTBYDO_REGEN_SPEED = 1;

/** Air density multiplier. */
static const float PHYSICS_AIR_DENSITY_MULTIPLIER = 4.0f;

/** Air density constant. */
static const float PHYSICS_DEFAULT_AIR_DENSITY = 1.2255f;

/** Drag divergence safety limit - how much of max_speed to allow */
static const float PHYSICS_DRAG_DIVERGENCE_SAFETY_LIMIT = 0.95f;

/** Frame count it takes to accelerate into full rotation speed. */
static const int ROTATION_ACCELERATION_TIME = 5;

/** Sound fade scales to 0 in this distance. */
static const float SOUND_FADE_AREA = 3.0f;

/** Sound fade starts at this distance. */
static const float SOUND_FADE_THRESHOLD = 4.0f;

/** Determines the width of terrain collision lines. */
static const float TERRAIN_COLLISION_LINE_WIDTH = 0.05f;

/** Default depth of the bottom plane we see. */
static const float TERRAIN_DEFAULT_BOTTOM_DEPTH = 16.0f;

/** Default collision plane (grayscale color value). */
static const int TERRAIN_DEFAULT_COLLISION_PLANE = 200;

/** Size of one collision tile (eight-screen). */
static const int TERRAIN_TILE_COLLISION = 2;

/** Size of full screen heightmap data. */
static const int TERRAIN_TILE_SCREEN = 16;

/** Size of one visual subtile (half-screen). */
static const int TERRAIN_TILE_VISUAL = 8;

/** Milliseconds it takes to tick once more. */
static const uint32_t TIMER_MILLISECONDS = 10;

/** Advancement of homing weapons target selection. */
static const float WEAPON_HOMING_TARGET_ADVANCE = 2.0f;

/** Number of targets a homing weapon picks. */
static const int WEAPON_HOMING_TARGETS = 3;

/** How far from will homing weapons select targets. */
static const float WEAPON_HOMING_TARGET_RADIUS_SQR = 70.0f;

/** Sample wait frames until playing next. */
static const int SOUND_SAMPLE_WAIT = 6;

/** View ratio. */
static const float VIEW_RATIO = 0.25f;

/** How much screen space does string input take. */
static const float VIEW_STRING_INPUT = 0.3f;

//############################################################################
// Derivative constants ######################################################
//############################################################################

/** Derivation of turret track. */
static const float AI_TURRET_TRACK_DISTANCE_SQR = AI_TURRET_TRACK_DISTANCE *
    AI_TURRET_TRACK_DISTANCE;

/** Length of one coordinate in meters (screen is assumed 64 meters). */
static const float PHYSICS_STEP_SPACE = 64.0f /
    static_cast<float>(TERRAIN_TILE_SCREEN / TERRAIN_TILE_COLLISION);

/** Time step of one tick. */
static const float PHYSICS_STEP_TIME =
    static_cast<float>(TIMER_MILLISECONDS) / 1000.0f;

/** Visual dimension (dependant on tile size and game view area) */
const float TERRAIN_VISUAL_DIMENSION =
    static_cast<float>(TERRAIN_TILE_VISUAL / TERRAIN_TILE_COLLISION);

/** View area size. */
static const float VIEW_AREA = static_cast<float>(TERRAIN_TILE_SCREEN /
    TERRAIN_TILE_COLLISION);

//############################################################################
// Derieved order 2 ##########################################################
//############################################################################

/** Maximum distance of absorb fire target for it to be included in spam. */
static const float ABSORB_FIRE_MAX_RANGE = VIEW_AREA * 0.7f * 1.414213f;

/** Derivation of physics step time. */
static const float PHYSICS_STEP_TIME_HALF = PHYSICS_STEP_TIME * 0.5f;

/** Derivation of physics step time. */
static const float PHYSICS_STEP_TIME_SQR = PHYSICS_STEP_TIME *
    PHYSICS_STEP_TIME;

/** Derivation pf physics step space. */
static const float PHYSICS_STEP_SPACE_INV = 1.0f / PHYSICS_STEP_SPACE;

/** Derivation of view area. */
static const float VIEW_AREA_HALF = VIEW_AREA * 0.5f;

/** Camera plane position. */
static const float VIEW_CAMERA_PLANE = VIEW_AREA * 0.5f / VIEW_RATIO;

//############################################################################
// Derieved order 3 ##########################################################
//############################################################################

/** Derieved froma absorb fire max range. */
static const float ABSORB_FIRE_MAX_RANGE_SQR = ABSORB_FIRE_MAX_RANGE *
    ABSORB_FIRE_MAX_RANGE;

//############################################################################
// End #######################################################################
//############################################################################

#endif

