#include "libfhi_postmodel.h"
#include "libfhi_mesh.h"

#include <iostream>

using namespace libfhi;

//############################################################################
// Constructor / destructor ##################################################
//############################################################################

/** Default constructor. */
PostModel::PostModel()
: Attributable(DEFAULT_ATTR), mesh(NULL), skel(NULL)
{
  // Do nothing.
}

/** Alternate constructor.
 * @param op Mesh to adapt.
 */
PostModel::PostModel(Mesh *op)
: Attributable(DEFAULT_ATTR), mesh(NULL), skel(NULL)
{
  this->adapt(op);
}

/** Default destructor. */
PostModel::~PostModel()
{
  mesh = NULL;
  skel = NULL;
}

//############################################################################
// Luokan funktiot ###########################################################
//############################################################################

/** Adapt a mesh.
 * @param op Mesh to use from now on.
 */
void PostModel::adapt(Mesh *op)
{
  mesh = op;

  if(mesh)
  {
    skel = mesh->get_skeleton();
  }
  else
  {
    std::cerr << "Warning: adapting an empty mesh.\n";
  }
}

//############################################################################
// Debug #####################################################################
//############################################################################

#ifdef LIBFHI_DEBUG

/** Print this mesh into a stream.
 * @param s The stream to output to.
 * @return Modified stream.
 */
std::ostream& PostModel::print(std::ostream &s) const
{
  s << "\nAttributes: " << attributes << "\n";
  Orientation::print(s);
  s << "\n" << (*mesh);
  return s;
}

#endif

//############################################################################
// Loppu #####################################################################
//############################################################################

