#include "libfhi_camera.h"

using namespace libfhi;

//############################################################################
// Luokan funktiot ###########################################################
//############################################################################

Camera::Camera()
  : Orientation()
{
  this->vm.identity();
}

/** Another constructor.
 * @param xr [in] X rotation.
 * @param yr [in] Y rotation.
 * @param zr [in] Z rotation.
 * @param x [in] X position.
 * @param y [in] Y position.
 * @param z [in] Z position.
 */
Camera::Camera(uint16_t xr, uint16_t yr, uint16_t zr, float x, float y,
    float z)
{
  set_angles(xr, yr, zr);
  set_pos(x, y, z);
}

/** Another constructor.
 * @param xr [in] X rotation.
 * @param yr [in] Y rotation.
 * @param zr [in] Z rotation.
 * @param op_pos [in] Position to set.
 */
Camera::Camera(uint16_t xr, uint16_t yr, uint16_t zr, const Vector3& op_pos)
{
  set_angles(xr, yr, zr);
  set_pos(op_pos);
}

/** Default destructor.
 */
Camera::~Camera()
{
  // Do nothing.
}

/** Copy given camera.
 * @param src [in] The camera to copy.
 */
void Camera::copy(Camera *src)
{
  Orientation::copy(src);
  this->vm = src->vm;
}

//############################################################################
// Tick ######################################################################
//############################################################################

void Camera::tick()
{
  Orientation::tick();

  // Make a view transformation matrix off this matrix.
  this->vm.view_matrix(this->om);
}

//############################################################################
// Loppu #####################################################################
//############################################################################

