#!BPY

"""
Name: 'libfhi-modelformat (.msh)...'
Blender: 241
Group: 'Export'
Tooltip: 'Export selected mesh to FHI-model (.msh)'
"""

__author__ = "Sami Vuolli"
__url__ = ("blender", "elysiun", "http://remora.dyndns.org/")
__version__ = "0.03"

__bpydoc__ = """\
This script exports mesh into a .msh file.

Usage:<br>
	Select meshes to be exported and run this script from "File->Export" menu.
"""

import Blender, meshtools
from Blender import Material
import sys

class vert:
  co=[0.0, 0.0, 0.0]
  m=0
  
def save_mesh(filename):
  if filename.find('.msh', -4) <= 0: filename += '.msh'
  file = open(filename, "wb")
  
  objects = Blender.Object.GetSelected()
  obj = objects[0]
  mesh = objects[0].data
  
  std = sys.stdout
  sys.stdout=file
  
  verts = []
  vdict = {}

  print "scale 1 1 1"
  
  for material in mesh.materials:
    print "color %f %f %f" % (material.R, material.G, material.B)
    
  for face in mesh.faces:
    for v in face.v:
      index = v.index
      key = index, face.materialIndex
      if not vdict.has_key(key):
	vdict[key] = len(verts)
	nv = vert()
	nv.co = v.co
	nv.m = face.materialIndex
	verts.append(nv)

  for (i, v) in enumerate(verts):
    print "vertex %f %f %f %i" % (v.co[0], v.co[1], v.co[2], v.m)
	  
  for face in mesh.faces:
    if len(face.v) == 3:
      print "triangle %i %i %i" % (
	  vdict[face[0].index, face.materialIndex],
	  vdict[face[1].index, face.materialIndex],
	  vdict[face[2].index, face.materialIndex])
    else:
      print "triangle %i %i %i" % (
	  vdict[face[0].index, face.materialIndex],
	  vdict[face[1].index, face.materialIndex],
	  vdict[face[2].index, face.materialIndex])
      print "triangle %i %i %i" % (
	  vdict[face[0].index, face.materialIndex],
	  vdict[face[2].index, face.materialIndex],
	  vdict[face[3].index, face.materialIndex])
      
  sys.stdout=std
  file.close()
  meshtools.print_boxed("ok!")

Blender.Window.FileSelector(save_mesh, "Export mesh")

