#ifndef libfhi_postmodel_include
#define libfhi_postmodel_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_attributable.h"
#include "libfhi_orientation.h"
#include "libfhi_mesh.h"

namespace libfhi {

//############################################################################
// Definet ###################################################################
//############################################################################
 
// Forward declaration
class Skin;

//############################################################################
// Luokka ####################################################################
//############################################################################

class PostModel :
  public Attributable,
  public Orientation
{
  public:
#ifdef LIBFHI_DEBUG
    DEBUG_PRINT_PROTOTYPE(PostModel)
#endif
 
  public:
    /** Is the model trawn at all (default)? */
    static const uint8_t ATTR_DRAW = 0x01;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_1 = 0x02;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_2 = 0x04;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_3 = 0x08;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_4 = 0x10;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_5 = 0x20;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_6 = 0x40;

    /** Reserved for user applications. */
    static const uint8_t ATTR_USER_7 = 0x80;

    /** Default attributes. */
    static const uint8_t DEFAULT_ATTR = ATTR_DRAW;

  private:
    /** The mesh linked to this postmodel. */
    Mesh *mesh;

    /** The skeleton linked to this postmodel (that is, the mesh). */
    void *skel;

  public:
    PostModel();
    PostModel(Mesh*);
    ~PostModel();

    void adapt(Mesh*);

    // Inline.
    inline Mesh* get_mesh();
    inline bool has_draw() const;
    inline void set_frame(float op);
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get the mesh data associated to this model.
 * @return A pointer to the mesh.
 */
Mesh* PostModel::get_mesh()
{
  return mesh;
}

/** Tell if this model is drawn.
 * @return True if yes, false if no.
 */
bool PostModel::has_draw() const
{
  return (attributes & ATTR_DRAW);
}

/** Set the model frame.
 * @param op New frame.
 */
void PostModel::set_frame(float)
{
  // TODO: Implement skeletons
}

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

