#ifndef libfhi_misc_include
#define libfhi_misc_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_default.h"

// Streams
#include <ostream>
#include <iostream>

namespace libfhi {

//############################################################################
// Functions #################################################################
//############################################################################

// Init functions.
bool init_libfhi();
bool quit_libfhi();

// File functions
bool fexists(const char *filename);
int fsize(FILE*);
int fsize(const char*);

// String functions
int strdecodeutf8(char*&);
int strlenl(const char*);

// Stream functions
std::ostream& ostream_delay(int, std::ostream& = std::cout);

//############################################################################
// Memory set inline functions ###############################################
//############################################################################

/** Memset template initializes n units to given value at given target.
 * @param dst [out] Memory target.
 * @param value [in] Value to initialize to.
 * @param num [in] Value count.
 */
template <class Type>
inline void memset_template(Type *dst, Type value, int num)
{
  do
  {
    *(dst++) = value;
  } while(--num);
}

/** A wrapper for memory set. Should work in most cases.
 * @param dst [out] Memory target to clean.
 * @param value [in] Value to clean to.
 * @param size [in] Size (in bytes) to clean.
 */
template <class Type>
inline void memset(void *dst, Type value, int size)
{
  memset_template(static_cast<Type*>(dst), value, size / sizeof(Type));
}

/* Specializations of the template. */

template <>
inline void memset<uint16_t>(void *dst, uint16_t value, int size)
{
  uint32_t val = value;
  memset_template(static_cast<uint32_t*>(dst), (val << 16) | val, size / 4);
}

template <>
inline void memset<int16_t>(void *dst, int16_t value, int size)
{
  uint32_t val = value;
  memset_template(static_cast<uint32_t*>(dst), (val << 16) | val, size / 4);
}

template <>
inline void memset<uint8_t>(void *dst, uint8_t value, int size)
{
  uint32_t val = value;
  memset_template(static_cast<uint32_t*>(dst),
      (val << 24) | (val << 16) | (val << 8) | val,
      size / 4);
}

template <>
inline void memset<int8_t>(void *dst, int8_t value, int size)
{
  uint32_t val = value;
  memset_template(static_cast<uint32_t*>(dst),
      (val << 24) | (val << 16) | (val << 8) | val,
      size / 4);
}

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

