#ifndef stringinput_h
#define stringinput_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

#include <string>

//############################################################################
// Class #####################################################################
//############################################################################

/** StringInput handles one inputted string with a header text.
 */
class StringInput
{
  private:
    /** The last string input. */
    static std::string last_string;

  private:
    /** The string displayed. */
    std::string input;

    /** The header text displayed. */
    std::string header;

  public:
    StringInput(const std::string&);
    ~StringInput();

  public:
    void draw(float, libfhi::Surface*);
    bool keydown(int);
    void keyup(int);

  public:
    inline const std::string& get_input() const;
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Return the inputted string.
 * @return Const string reference.
 */
const std::string& StringInput::get_input() const
{
  return this->input;
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

