#ifndef particlesystem_h
#define particlesystem_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "particle.h"

#include <list>

//############################################################################
// Class #####################################################################
//############################################################################

/** ParticleSystem is the collection of all particles in-game. It takes care
 * of drawing them all.
 */
class ParticleSystem
  : public libfhi::CanonicalDB<ParticleSystem>
{
  private:
    /** Listing of all particles. */
    std::list<Particle*> particles;

    /** Mesh containing all the particles. */
    libfhi::Mesh *msh;

    /** PostModel containing the mesh. */
    libfhi::PostModel *model;

    /** Maximum number of particles visible in this. */
    size_t visible_count;

  public:
    ParticleSystem();
    ParticleSystem(const char*);
    ~ParticleSystem();

    void add(const libfhi::Color4&, const libfhi::Vector2&, float, uint16_t,
	int);
    void add(const libfhi::Color4&, const libfhi::Vector2&,
	const libfhi::Vector2&, int);
    void clear_particles();
    void draw(const libfhi::Vector2&);
    void generate_mesh(size_t, float);
    void tick();
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

