half texel = 	1.0f / 128.0f;
half texFix =  (1.0f/256.0f) * 0.5f;

const half gaussianCoefs[7] = { 
0.035994,
0.10934,
0.212965,
0.265962,
0.212965,
0.10934,
0.035994
};

texture renderTexture;

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput {
    float4 position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
    float4 color		: COLOR;
};

struct QuadVertexOutput {
    float4 position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
};


QuadVertexOutput QuadProjection(VertexInput IN) {
    QuadVertexOutput OUT;
    
    OUT.position = float4( IN.Position , 1.0f );
    OUT.uvCoord = IN.uvCoord + texFix;
    
    return OUT;
}

VertexOutput VS_QuadHorizontal(VertexInput IN, uniform int index ) {
    VertexOutput OUT;
    
    OUT.position = float4( IN.Position , 1.0f );
    
    OUT.uvCoord = IN.uvCoord + float2( texel * (index-3), 0.0f );
    OUT.color = gaussianCoefs[ index ];
    
    return OUT;
}

VertexOutput VS_QuadVertical(VertexInput IN, uniform int index) {
    VertexOutput OUT;
    
    OUT.position = float4( IN.Position , 1.0f );
    
    OUT.uvCoord = IN.uvCoord + float2( 0.0f, texel * (index-3) );
    OUT.color = gaussianCoefs[ index ];
    
    return OUT;
}

technique BlurX
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 0 );
		PixelShader = NULL;
		
		ZEnable = false;	
		AlphaBlendEnable = false;
		
		texture[0] = <renderTexture>;
		addressu[0] = CLAMP;
		addressv[0] = CLAMP;
		mipfilter[0] = LINEAR;
		minfilter[0] = LINEAR;
		magfilter[0] = LINEAR;
    }
    pass p1
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 1 );

		ZEnable = false;
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend = one;
		
		texture[0] = <renderTexture>;
		addressu[0] = CLAMP;
		addressv[0] = CLAMP;
		mipfilter[0] = LINEAR;
		minfilter[0] = LINEAR;
		magfilter[0] = LINEAR;
    }
    pass p2
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 2 );
    }
    pass p3
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 3 );
    }
    pass p4
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 4 );
    }
    pass p5
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 5 );
    }
    pass p6
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal( 6 );
    }
}

technique BlurY
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 0 );
		PixelShader = NULL;
		
		ZEnable = false;	
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend = one;
		
		texture[0] = <renderTexture>;
		addressu[0] = CLAMP;
		addressv[0] = CLAMP;
		mipfilter[0] = LINEAR;
		minfilter[0] = LINEAR;
		magfilter[0] = LINEAR;
    }
    pass p1
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 1 );
    }
    pass p2
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 2 );
    }
    pass p3
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 3 );
    }
    pass p4
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 4 );
    }
    pass p5
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 5 );
    }
    pass p6
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical( 6 );
    }
}

technique CopyTexture
{
	pass p0
	{
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = NULL;
		
		ZWriteEnable = false;
		
		texture[0] = <renderTexture>;
		addressu[0] = CLAMP;
		addressv[0] = CLAMP;
		mipfilter[0] = LINEAR;
		minfilter[0] = LINEAR;
		magfilter[0] = LINEAR;
	}
}