half texel = 	1.0f / 128.0f;
half texFix =  (1.0f/256.0f) * 0.5f;

const half gaussianCoefs[7] = { 
0.035994,
0.10934,
0.212965,
0.265962,
0.212965,
0.10934,
0.035994
};

texture renderTexture;

sampler textureSampler = sampler_state 
{
    texture = <renderTexture>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = NONE;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput {
    float4 HPosition	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct GlowVertexOutput {
    float4 HPosition	: POSITION;
    half2 uvCoord0	: TEXCOORD0;
    half2 uvCoord1	: TEXCOORD1;
    half2 uvCoord2	: TEXCOORD2;
    half2 uvCoord3	: TEXCOORD3;
};



VertexOutput QuadProjection(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    OUT.uvCoord = IN.uvCoord + texFix;
    
    return OUT;
}

GlowVertexOutput VS_QuadHorizontal_1(VertexInput IN) {
    GlowVertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    
    float2 coords = IN.uvCoord;
    float2 addCoords = float2( texel, 0.0f );
    
    OUT.uvCoord0 = coords - addCoords*3;
    OUT.uvCoord1 = coords - addCoords*2;
    OUT.uvCoord2 = coords - addCoords;
    OUT.uvCoord3 = coords;
    
    return OUT;
}

GlowVertexOutput VS_QuadHorizontal_2(VertexInput IN) {
    GlowVertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    
    float2 coords = IN.uvCoord;
    float2 addCoords = float2( texel, 0.0f );
    
    OUT.uvCoord0 = coords + addCoords*3;
    OUT.uvCoord1 = coords + addCoords*2;
    OUT.uvCoord2 = coords + addCoords;
    OUT.uvCoord3 = coords;
    
    return OUT;
}

GlowVertexOutput VS_QuadVertical_1(VertexInput IN) {
    GlowVertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    
    float2 coords = IN.uvCoord;
    float2 addCoords = float2( 0.0f, texel );
    
    OUT.uvCoord0 = coords - addCoords*3;
    OUT.uvCoord1 = coords - addCoords*2;
    OUT.uvCoord2 = coords - addCoords;
    OUT.uvCoord3 = coords;
    
    return OUT;
}

GlowVertexOutput VS_QuadVertical_2(VertexInput IN) {
    GlowVertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    
    float2 coords = IN.uvCoord;
    float2 addCoords = float2( 0.0f, texel );
    
    OUT.uvCoord0 = coords + addCoords*3;
    OUT.uvCoord1 = coords + addCoords*2;
    OUT.uvCoord2 = coords + addCoords;
    OUT.uvCoord3 = coords;
    
    return OUT;
}

half4 GaussianBlur_1( GlowVertexOutput IN ) : COLOR
{
	half4 color = tex2D( textureSampler, IN.uvCoord0 ) * gaussianCoefs[0].xxxx;
	color += tex2D( textureSampler, IN.uvCoord1 ) * gaussianCoefs[1].xxxx;
	color += tex2D( textureSampler, IN.uvCoord2 ) * gaussianCoefs[2].xxxx;
	color += tex2D( textureSampler, IN.uvCoord3 ) * gaussianCoefs[3].xxxx;
	
	return color;
}

half4 GaussianBlur_2( GlowVertexOutput IN ) : COLOR
{
	half4 color = tex2D( textureSampler, IN.uvCoord0 ) * gaussianCoefs[6].xxxx;
	color += tex2D( textureSampler, IN.uvCoord1 ) * gaussianCoefs[5].xxxx;
	color += tex2D( textureSampler, IN.uvCoord2 ) * gaussianCoefs[4].xxxx;
	
	return color;
}

float4 PS_CopyTexture( VertexOutput IN ) : COLOR
{
	return tex2D( textureSampler, IN.uvCoord );
}

technique BlurX
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal_1();
		PixelShader = compile ps_1_1 GaussianBlur_1();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = false;
		srcBlend = one;
		destBlend =zero;
    }
    pass p1
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal_2();
		PixelShader = compile ps_1_1 GaussianBlur_2();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend = one;
    }
}

technique BlurY
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical_1();
		PixelShader = compile ps_1_1 GaussianBlur_1();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend = one;
    }
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical_2();
		PixelShader = compile ps_1_1 GaussianBlur_2();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =one;
    }
}

technique CopyTexture
{
	pass p0
	{
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_1_1 PS_CopyTexture();
		
		ZWriteEnable = false;
	}
}

technique CopyTextureBlended
{
	pass p0
	{
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_1_1 PS_CopyTexture();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =invsrcColor;
	}
}