half texel = 	1.0f / 128.0f;

const half gaussianCoefs[7] = { 
0.035994,
0.10934,
0.212965,
0.265962,
0.212965,
0.10934,
0.035994
};

texture renderTexture;

sampler textureSampler = sampler_state 
{
    texture = <renderTexture>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = NONE;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput {
    float4 HPosition	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct GlowVertexOutput {
    float4 HPosition	: POSITION;
    half2 uvCoord0	: TEXCOORD0;
    half2 uvCoord1	: TEXCOORD1;
    half2 uvCoord2	: TEXCOORD2;
    half2 uvCoord3	: TEXCOORD3;
    half2 uvCoord4	: TEXCOORD4;
    half2 uvCoord5	: TEXCOORD5;
    half2 uvCoord6	: TEXCOORD6;
};



VertexOutput QuadProjection(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    OUT.uvCoord = IN.uvCoord;
    
    return OUT;
}

GlowVertexOutput VS_QuadHorizontal(VertexInput IN) {
    GlowVertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    
    float2 coords = IN.uvCoord;
    float2 addCoords = float2( texel, 0.0f );
    
    OUT.uvCoord0 = coords - addCoords*3;
    OUT.uvCoord1 = coords - addCoords*2;
    OUT.uvCoord2 = coords - addCoords;
    OUT.uvCoord3 = coords;
    OUT.uvCoord4 = coords + addCoords;
    OUT.uvCoord5 = coords + addCoords*2;
    OUT.uvCoord6 = coords + addCoords*3;
    
    return OUT;
}

GlowVertexOutput VS_QuadVertical(VertexInput IN) {
    GlowVertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    
    float2 coords = IN.uvCoord;
    float2 addCoords = float2( 0.0f, texel );
    
    OUT.uvCoord0 = coords - addCoords*3;
    OUT.uvCoord1 = coords - addCoords*2;
    OUT.uvCoord2 = coords - addCoords;
    OUT.uvCoord3 = coords;
    OUT.uvCoord4 = coords + addCoords;
    OUT.uvCoord5 = coords + addCoords*2;
    OUT.uvCoord6 = coords + addCoords*3;
    
    return OUT;
}

half4 GaussianBlur( GlowVertexOutput IN ) : COLOR
{
	half4 color = tex2D( textureSampler, IN.uvCoord0 ) * gaussianCoefs[0].xxxx;
	color += tex2D( textureSampler, IN.uvCoord1 ) * gaussianCoefs[1].xxxx;
	color += tex2D( textureSampler, IN.uvCoord2 ) * gaussianCoefs[2].xxxx;
	color += tex2D( textureSampler, IN.uvCoord3 ) * gaussianCoefs[3].xxxx;
	color += tex2D( textureSampler, IN.uvCoord4 ) * gaussianCoefs[4].xxxx;
	color += tex2D( textureSampler, IN.uvCoord5 ) * gaussianCoefs[5].xxxx;
	color += tex2D( textureSampler, IN.uvCoord6 ) * gaussianCoefs[6].xxxx;
	
	return color;
}

float4 PS_CopyTexture( VertexOutput IN ) : COLOR
{
	return tex2D( textureSampler, IN.uvCoord );
}

technique BlurX
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadHorizontal();
		PixelShader = compile ps_2_0 GaussianBlur();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =zero;
    }
}

technique BlurY
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadVertical();
		PixelShader = compile ps_2_0 GaussianBlur();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =invsrcColor;
    }
}

technique CopyTexture
{
	pass p0
	{
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_1_1 PS_CopyTexture();
		
		ZWriteEnable = false;
	}
}