HYPER_WIDTH = 3
function P_hypergridp() {
    document.getElementById('d').style.backgroundColor = 'white'
    velocity = new Vector3D(1, 0, 0)
    pisteet = new Array(HYPER_WIDTH)
    kuvat = new Array(HYPER_WIDTH)
    for (var i = 0; i < HYPER_WIDTH; ++i) {
        pisteet[i] = new Array(HYPER_WIDTH)
        kuvat[i] = new Array(HYPER_WIDTH)
        for (var j = 0; j < HYPER_WIDTH; ++j) {
            pisteet[i][j] = new Array(HYPER_WIDTH)
            kuvat[i][j] = new Array(HYPER_WIDTH)
            for (var k = 0; k < HYPER_WIDTH; ++k) {
                var r = Math.random() * 2
                pisteet[i][j][k] = new Vector3D(i - HYPER_WIDTH / 2, j - HYPER_WIDTH / 2, k - HYPER_WIDTH / 2)
                kuvat[i][j][k] = new Pic('data/invp.png', 16, 16)
                kuvat[i][j][k].alpha(r / 4 + 0.5)
            }
        }
    }
    txt = new Text('<span style="font-family:sans-serif;color:black"><strong>Scanning...</strong></span>') 
    txt.img.style.paddingLeft = '16px'
    txt.img.style.zIndex = 800
    txt.img.style.fontSize = '24px'
    txt.alpha(0)
    P_hypergrid(0)
}

function P_hypergride() {
    for (var i = 0; i < HYPER_WIDTH; ++i) {
        for (var j = 0; j < HYPER_WIDTH; ++j) {
            for (var k = 0; k < HYPER_WIDTH; ++k) {
                delete pisteet[i][j][k]
                kuvat[i][j][k].free()
                delete kuvat[i][j][k]
            }
            delete pisteet[i][j]
            delete kuvat[i][j]
        }
        delete pisteet[i]
        delete kuvat[i]
    }
    delete pisteet
    txt.free()
    ROTATION_MATRIX.reset()
    OFFSET_VECTOR.reset()
}

function P_hypergrid(pttime) {
    var horj = 0
    OFFSET_VECTOR.x = Math.sin(pttime / 2000) / 2
    OFFSET_VECTOR.y = Math.sin(2+pttime / 3000) / 2
    OFFSET_VECTOR.z = Math.sin(4+pttime / 2600) / 2 + 6
    rotate3d1(pttime / 1100)
    rotate3d2(pttime / 1300)
    rotate3d3(pttime / 900)
    txt.alpha(0.5+.5*Math.sin(pttime/250))
    horj = -.25 + Math.sin(pttime / 600) / 10 
    if (pttime < 2000) {
        horj -= 1 - pttime/2000
    }
    else if (pttime > 10000) {
        horj -= (pttime - 10000) / 2000
    }
    txt.alpha(1.5 + 3 * horj)
    for (var i = 0; i < HYPER_WIDTH; ++i) {
        for (var j = 0; j < HYPER_WIDTH; ++j) {
            for (var k = 0; k < HYPER_WIDTH; ++k) {
                kuvat[i][j][k].move3d(pisteet[i][j][k], HYPER_WIDTH * 6)
                kuvat[i][j][k].alpha(horj + 0.7+0.3*Math.sin((i*12) + (j*33) + k + pttime / 90))
            }
        }
    }
    ROTATION_MATRIX.reset()
}
