var TAN_MU = 1.5; /* tan of horizontal viewing angle */
var TAN_NU;

var SLOMO = 1;
var refreshRate = 10 * SLOMO; /* 100fps is enough for anyone (- Bill Gates, 2006) */

var canvas;
var props;

var CANVAS_WIDTH;
var CANVAS_HEIGHT;
var CANVAS_CENTRE_X;
var CANVAS_CENTRE_Y;
var PROJECTION_CENTRE_X;
var PROJECTION_CENTRE_Y;
var X_PROJ_COEFF;
var Y_PROJ_COEFF;

var ctx;
var startTime;
var stopped = false;
var frameCount = 0;

function go() {
	props = document.getElementById('props');
	canvas = document.getElementById('canvas');
	ctx = canvas.getContext('2d');
	CANVAS_WIDTH = canvas.width;
	CANVAS_HEIGHT = canvas.height;
	CANVAS_CENTRE_X = PROJECTION_CENTRE_X = CANVAS_WIDTH / 2;
	CANVAS_CENTRE_Y = PROJECTION_CENTRE_Y = CANVAS_HEIGHT / 2;
	TAN_NU = TAN_MU * (CANVAS_HEIGHT / CANVAS_WIDTH);
	
	X_PROJ_COEFF = (CANVAS_WIDTH / 2) / TAN_MU;
	Y_PROJ_COEFF = (CANVAS_HEIGHT / 2) / TAN_NU;
	
	initHelixScene();
	initStonehengeScene();
	initTorusScene();
	initFlowerScene();
	
	if (SOUND) {
		playMp3();
	} else {
		startTime = new Date().getTime();
		tick();
	}
}
function playMp3() {
	document.getElementById('mp3player').SetVariable('my_bitrate', 128 );
	// document.getElementById('mp3player').SetVariable('autolaunch', true );
	document.getElementById('mp3player').SetVariable('url', 'data/gallions_reach.mp3');
	if (document.getElementById('mp3player').GetVariable('autolaunch')) {
		// document.getElementById('debug').value = 'got handle';
		checkMp3Status();
	} else {
		//document.getElementById('debug').value = 'not got handle';
		setTimeout(playMp3, 20);
	}
}
function checkMp3Status() {
	if (document.getElementById('mp3player').GetVariable && document.getElementById('mp3player').GetVariable('PlayStatus') == 'Playing') {
		//document.getElementById('debug').value = 'playing';
		startTime = new Date().getTime();
		tick();
	} else {
		//document.getElementById('debug').value = 'not playing';
		setTimeout(checkMp3Status, 20);
	}
}

endScreen = new Image();
endScreen.src = 'data/swirling.jpg';

var startedHelixScene = false;
var startedStonehengeScene = false;
var startedTorusScene = false;
var startedFlowerScene = false;

function tick() {
	var t = ((new Date().getTime()) - startTime) / SLOMO;
	frameCount++;
	
	if (t < 40000) {
		if (!startedHelixScene) {
			startHelixScene(); startedHelixScene = true;
		}
		doHelixScene(t);
	} else if (t < 79000) {
		if (!startedStonehengeScene) {
			startStonehengeScene(); startedStonehengeScene = true;
		}
		doStonehengeScene(t - 40000);
	} else if (t < 118000) {
		if (!startedTorusScene) {
			startTorusScene(); startedTorusScene = true;
		}
		doTorusScene(t - 79000);
	} else if (t < 122000) {
		ctx.fillStyle = "#000000";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);	
	} else if (t < 167000) {
		if (!startedFlowerScene) {
			startFlowerScene(); startedFlowerScene = true;
		}
		doFlowerScene(t - 122000);
	} else {
		ctx.drawImage(endScreen, 0, 0);
		stopped = true;
	}
	
	/* if (!startedFlowerScene) {
		startFlowerScene(); startedFlowerScene = true;
	}
	doFlowerScene(t); */
			
	if (!stopped) {
		setTimeout(tick, refreshRate);
	}
}

function stop() {
	stopped = true;
	if (SOUND) {
		var mp3player = document.getElementById('mp3player');
		document.getElementById('mp3playercontainer').removeChild(mp3player);
	}
	alert(frameCount * 1000 / ((new Date().getTime()) - startTime) + ' FPS');
}
