// main.js

var initStep = 0;
var resX,resY,w,h;
var running = true;
var kuvahead;

var hexChars = "0123456789ABCDEF";
function Dec2Hex (Dec) { var a = Dec % 16; var b = (Dec - a)/16; hex = "%" + hexChars.charAt(b) + hexChars.charAt(a); return hex; }

var dec2hex = Array(256);
for(var i=0;i<=255;i++)
{
	dec2hex[i] = Dec2Hex(i);
}

function bmp8(w,h)
{
	var size = 54 + 1024 + w * h;
	return "data:image/bmp;charset=iso-8859-1,BM" + dec2hex[size&255] + dec2hex[(size>>8)&255] + dec2hex[(size>>16)&255] + dec2hex[(size>>24)&255] + "%00%00%00%00%36%00%00%00%28%00%00%00" + dec2hex[w&255] + dec2hex[(w>>8)&255] + dec2hex[(w>>16)&255] + dec2hex[(w>>24)&255] + dec2hex[h&255] + dec2hex[(h>>8)&255] + dec2hex[(h>>16)&255] + dec2hex[(h>>24)&255] + "%01%00%08%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00";
}

function bmp24(w,h)
{
	var size = 54 + w * h * 3;
	return "data:image/bmp;charset=iso-8859-1,BM" + dec2hex[size&255] + dec2hex[(size>>8)&255] + dec2hex[(size>>16)&255] + dec2hex[(size>>24)&255] + "%00%00%00%00%36%00%00%00%28%00%00%00" + dec2hex[w&255] + dec2hex[(w>>8)&255] + dec2hex[(w>>16)&255] + dec2hex[(w>>24)&255] + dec2hex[h&255] + dec2hex[(h>>8)&255] + dec2hex[(h>>16)&255] + dec2hex[(h>>24)&255] + "%01%00%18%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00%00";
}

function resizeStage(x,y)
{
	elemPic1.style.width = x;
	elemPic2.style.width = x;
	elemPic1.style.height = y;
	elemPic2.style.height = y;
}

function hideStage()
{
	elemPic1.style.visibility = "hidden";
	elemPic2.style.visibility = "hidden";
}

function showStage()
{
	elemPic1.style.visibility = "visible";
	elemPic2.style.visibility = "visible";
}

var fadeLevel = 0, fadeStep = 0.1, fadeDuration = 2;

function fadeIn()
{
	if(fadeLevel<1)
	{
		fadeLevel += fadeStep;
		elemPic1.style.opacity = fadeLevel;
		elemPic2.style.opacity = fadeLevel;
	}
}

function setFade(fade)
{
	fadeLevel = fade;
	elemPic1.style.opacity = fadeLevel;
	elemPic2.style.opacity = fadeLevel;
}

function fadeOut()
{
	if(fadeLevel>0)
	{
		fadeLevel -= fadeStep;
		elemPic1.style.opacity = fadeLevel;
		elemPic2.style.opacity = fadeLevel;
	}
}

var alkuTime = 17.6, polyTime = 34.3, tunnelTime = 50.5, scrollerTime = 106, tunnel2Time = 115, poly2Time = 125;

var flashit = new Array(2,2.3,2.6,3,4,5,6,7,8,9);
var flashTole = 0.15;

function flash(palette,flashPalette)
{
	var i;
	var nyt = false;
	for(i=0;i<flashit.length;i++)
	{
		if(timePos>=flashit[i] && timePos<=flashit[i]+flashTole)
			nyt = true;
	}
	if(nyt)
		return flashPalette;
	else
		return palette;
}

var kuva;

kuvahead = bmp8(w,h);

var orangePalette = "";
var orangeFlashPalette = "";
var bluePalette = "";
var blueFlashPalette = "";
var greenPalette = "";
var greenFlashPalette = "";
var whitePalette = "";

for(var j=0;j<256;j++)
{
	var i=j>>2;
	
	orangePalette      += dec2hex[ Math.max(0,Math.min(255,i*8-256)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8-128)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8)) ] +"%00";
	orangeFlashPalette += dec2hex[ Math.max(0,Math.min(255,i*8-128)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8+128)) ] +"%00";
	
	bluePalette        += dec2hex[ Math.max(0,Math.min(255,i*8-64)) ] + dec2hex[ Math.max(0,Math.min(255,i*8-192)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8-256)) ] +"%00";
	blueFlashPalette   += dec2hex[ Math.max(0,Math.min(255,i*8+64)) ] + dec2hex[ Math.max(0,Math.min(255,i*8-64)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8-192)) ] +"%00";
	
	greenPalette       += dec2hex[ Math.max(0,Math.min(255,i*8-128)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8-128)) ] +"%00";
	greenFlashPalette  += dec2hex[ Math.max(0,Math.min(255,i*8)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8+128)) ]+ dec2hex[ Math.max(0,Math.min(255,i*8)) ] +"%00";
	
	whitePalette	+= "%FF%FF%FF%FF";
}

var renderKierros = 0;
var norender = true;
var fsdg = true;

function render()
{
	if(timePos<alkuTime) { // alku
		
		if(initStep<2)
		{
			hideStage();
			alku_init3D();
			initStep = 2;
		}
		
		alkuteksti();
		
	} else if(timePos<polyTime) // poly
	{
		if(timePos<alkuTime+fadeDuration) fadeIn();
		
		//if(zcenter>15) zcenter-=0.5;
		
		if(initStep<4)
		{
			norender = false;
			alku_vittuun();
			document.getElementById('name').style.visibility = "visible";
			document.getElementById('asm').style.visibility = "visible";
			document.getElementById('by').style.visibility = "visible";
			showStage();
			resizeStage(236,236);
			setFade(1);
			zcenter = 15;
			init_poly(false);
			initStep = 4;
		}
		
		kuva = kuvahead + flash(bluePalette,blueFlashPalette) + render_poly();
		
		if(timePos>polyTime-fadeDuration) fadeOut();
		
	} else if(timePos<tunnelTime) { // tunneli
		
		if(timePos<polyTime+fadeDuration) fadeIn();
		
		if(initStep<5)
		{
			resizeStage(420,236);
			init_tunnel();
			initStep = 5;
		}
		
		kuva = kuvahead + flash(greenPalette,greenFlashPalette) + render_tunnel();
		
		if(timePos>tunnelTime-fadeDuration) fadeOut();
		
	} else if(timePos<scrollerTime) { // scrolleri
		
		if(timePos<tunnelTime+fadeDuration) fadeIn();
		
		if(initStep<10)
		{
			showStage();
			init_scroller();
			initStep = 10;
		}
		
		kuva = render_scroller();
		
		if(timePos>scrollerTime-fadeDuration) fadeOut();
		
	} else if(timePos<tunnel2Time) // tunnel2
	{
		if(timePos<scrollerTime+fadeDuration) fadeIn();
		
		if(initStep<12)
		{
			resizeStage(420,236);
			init_tunnel2();
			initStep = 12;
		}
		
		// strobo lol
		if(renderKierros % 2 == 0)
			kuva = kuvahead + bluePalette + render_tunnel2();
		else
			kuva = kuvahead + blueFlashPalette + render_tunnel2();
		
		if(timePos>tunnel2Time-fadeDuration) fadeOut();
		
	} else if(timePos<poly2Time) { // poly2
		
		if(timePos<tunnel2Time+fadeDuration) fadeIn();
		
		if(initStep<15)
		{
			resizeStage(236,236);
			init_poly(true);
			initStep = 15;
		}
		
		kuva = kuvahead + flash(orangePalette,orangeFlashPalette) + render_poly();
		
		if(timePos>poly2Time-fadeDuration-2) zcenter++;
		if(timePos>poly2Time-fadeDuration) fadeOut();
		
	} else if (timePos>poly2Time) {
		
		running = false;
		document.getElementById('name').style.visibility = "none";
		document.getElementById('asm').style.visibility = "none";
		document.getElementById('by').style.visibility = "none";
		
	}
	
	renderKierros++;
}


var frameCount = 0;
var timeCheckInterval = 2;

var elemPic1 = document.getElementById('pic1');
var elemPic2 = document.getElementById('pic2');

var elemFnc  = document.getElementById('fnc');


var beginTime = new Date().getTime();
var timePos,thisTime;

	
elemPic2.style.opacity = 0;
elemPic1.style.opacity = 0;

setImage();

function setImage()
{
	frameCount++;
	
	if(frameCount % timeCheckInterval == 0)
	{
		thisTime = new Date().getTime();
		timePos = ( thisTime - beginTime ) / 1000;
	}
	
	render();
	
	if(!norender)
	{
		elemPic2.src = kuva;
		elemPic2.style.visibility = "visible";
		elemPic1.style.visibility = "hidden";
	}	
	if(running) setTimeout('setImage2()',6);
}

function setImage2()
{
	frameCount++;
	
	if(frameCount % timeCheckInterval == 0)
	{
		thisTime = new Date().getTime();
		timePos = ( thisTime - beginTime ) / 1000;
	}
	
	render();
	
	if(!norender)
	{
		elemPic2.src = kuva;
		elemPic2.style.visibility = "visible";
		elemPic1.style.visibility = "hidden";
	}
	if(running) setTimeout('setImage()',6);
}

