string XFile = "misc\\teapot.x";
int BCLR = 0xff202060;

float2 dir = {0.0, 0.0};
float alpha[8];

// textures
texture tex;

sampler samp = sampler_state
{
	Texture = (tex);
	MipFilter = NONE;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

struct VS_OUTPUT
{
	float4 pos  : POSITION;
	float2 tex  : TEXCOORD1;
};

VS_OUTPUT vertex(float4 ipos : POSITION)
{
	VS_OUTPUT Out;

	Out.pos = ipos;
	Out.tex = float2(Out.pos.x * 0.5 + 0.5f + (0.5f / 256), -Out.pos.y * 0.5 + 0.5f + (0.5f / 256));	
//	Out.tex.x = sin(Out.pos.x * 20) * 1.5f;
	return Out;
}

float4 pixel(VS_OUTPUT In) : COLOR
{
	return tex2D(samp, In.tex);
}

technique blur_ps_vs_2_0
{
	pass P0
	{
		VertexShader = compile vs_2_0 vertex();
		PixelShader  = compile ps_2_0 pixel();
	}
}
