/*
 * misc.c
 * (c) 2006, Francois Revol <revol@free.fr>
 * misceleanous functions
 */

#include <lib.h>
#include "invit.h"

void spin(char d)
{
  int i;
  while (d--)
    for (i = 30; i; i--);
}

void delay(int sec)
{
  while (sec--)
    spin(255);
}

/*
char myrandc(void)
{
  char c;
  c = myrand() & 63;
  c += 33;
  return c;
}
*/

char myranddigit(void)
{
  char c;
  c = myrand() & 0x7; // XXX: misses 8 & 9
  c += '0';
  return c;
}

void clearscreen(void)
{
  memset((char *)TEXTVRAM, ' ', NCOL*28);
}

void stripattributes(void)
{
  char *p = (char *)TEXTVRAM;
  int l = NCOL * 28;
  while(l--) {
    if ((*p < 32) || (*p > 128))
      *p = ' ';
    p++;
  }
}

/*
void putat(char x, char y, char c)
{
  poke((TEXTVRAM+y*NCOL+x), c);
}

char charat(char x, char y)
{
  return peek((TEXTVRAM+y*NCOL+x));
}
*/

void text_out(char x, char y, char *t)
{
  char *p;
  p = (char *)TEXTVRAM + x + y * NCOL;
  while (*t) {
    *p++ = *t++;
  }
}

void status_out(char color, char *t)
{
  char *p;
  p = (char *)TEXTVRAM + NCOL - strlen(t);
  *p++ = color;
  while (*t) {
    *p++ = *t++;
  }
}

void dbl_text_out(char x, char y, char color, char *t)
{
  char *p, *q;
  p = (char *)TEXTVRAM + x + y * NCOL;
  q = (char *)TEXTVRAM + x + (y+1) * NCOL;
  *p++ = color;
  *q++ = color;
  *p++ = A_STD2H;
  *q++ = A_STD2H;
  while (*t) {
    *p++ = *t;
    *q++ = *t++;
  }
  /* only reset attributes if not at end of line */
  if (p > (char *)TEXTVRAM + NCOL-1 + y * NCOL)
    return;
  *p = A_STD;
  *q = A_STD;
}

void dblblk_text_out(char x, char y, char color, char *t)
{
  char *p, *q;
  p = (char *)TEXTVRAM + x + y * NCOL;
  q = (char *)TEXTVRAM + x + (y+1) * NCOL;
  *p++ = color;
  *q++ = color;
  *p++ = A_STD2HFL;
  *q++ = A_STD2HFL;
  while (*t) {
    *p++ = *t;
    *q++ = *t++;
  }
  /* only reset attributes if not at end of line */
  if (p > (char *)TEXTVRAM + NCOL-1 + y * NCOL)
    return;
  *p = A_STD;
  *q = A_STD;
}

