/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public abstract class AbstractLevel {
    int startPosX;
    int startPosY;
    long gameArea = 48400L;
    int timeLeft = 60;
    Sprite[] spriteDangers;
    Sprite[] spriteWalls;
    NeutralSprite[] spriteNeutrals;
    Sprite spriteKey;
    int blinks = 3;
    int bonus;
    public static final int UP_VALUE = 1;
    public static final int DOWN_VALUE = 2;
    public static final int LEFT_VALUE = 3;
    public static final int RIGHT_VALUE = 4;

    public AbstractLevel() {
        this.generateWalls();
        this.generateDangers();
        this.generateKey();
        this.generateNeutrals();
    }

    protected abstract void generateWalls();

    protected abstract void generateDangers();

    protected abstract void generateKey();

    protected abstract void generateNeutrals();

    public int getBonus() {
        return this.bonus;
    }

    public void paint(Graphics g) {
        this.spriteKey.paint(g);
        int i = 0;
        while (i < this.spriteWalls.length) {
            this.spriteWalls[i].paint(g);
            ++i;
        }
        i = 0;
        while (i < this.spriteDangers.length) {
            this.spriteDangers[i].paint(g);
            ++i;
        }
        if (this.spriteNeutrals != null) {
            i = 0;
            while (i < this.spriteNeutrals.length) {
                if (this.spriteNeutrals[i].isPowerup()) {
                    if (this.spriteNeutrals[i].getSurviveTime() > 0) {
                        this.spriteNeutrals[i].paint(g);
                    }
                } else {
                    this.spriteNeutrals[i].paint(g);
                }
                ++i;
            }
        }
    }

    public int getStartPosX() {
        return this.startPosX;
    }

    public int getStartPosY() {
        return this.startPosY;
    }

    public void checkCollisions(ScubaZed spritePlayer, int direction) {
        int i = 0;
        while (i < this.spriteWalls.length) {
            if (spritePlayer.collidesWith(this.spriteWalls[i], true)) {
                if (direction == 1) {
                    spritePlayer.setPosition(spritePlayer.getX(), this.spriteWalls[i].getY() + 20);
                } else if (direction == 2) {
                    spritePlayer.setPosition(spritePlayer.getX(), this.spriteWalls[i].getY() - 20);
                } else if (direction == 3) {
                    spritePlayer.setPosition(this.spriteWalls[i].getX() + 20, spritePlayer.getY());
                } else if (direction == 4) {
                    spritePlayer.setPosition(this.spriteWalls[i].getX() - 10, spritePlayer.getY());
                }
            }
            ++i;
        }
    }

    public boolean checkCollissionsDanger(ScubaZed spritePlayer) {
        int i = 0;
        while (i < this.spriteDangers.length) {
            if (spritePlayer.collidesWith(this.spriteDangers[i], true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void checkCollisionsNeutral(ScubaZed player) {
        if (this.spriteNeutrals != null) {
            int i = 0;
            while (i < this.spriteNeutrals.length) {
                if (player.collidesWith(this.spriteNeutrals[i], true)) {
                    if (this.spriteNeutrals[i].isPowerup()) {
                        if (this.spriteNeutrals[i].getSurviveTime() > 0) {
                            if (((Object)((Object)this.spriteNeutrals[i])).equals("blink")) {
                                ++this.blinks;
                            } else if (((Object)((Object)this.spriteNeutrals[i])).equals("life")) {
                                player.addLives();
                            } else if (((Object)((Object)this.spriteNeutrals[i])).equals("points")) {
                                this.bonus += 150;
                            }
                        }
                    } else {
                        switch (this.spriteNeutrals[i].getDirection()) {
                            case 1: {
                                player.move(0, -this.spriteNeutrals[i].getSpeed());
                                break;
                            }
                            case 2: {
                                player.move(0, this.spriteNeutrals[i].getSpeed());
                                break;
                            }
                            case 3: {
                                player.move(-this.spriteNeutrals[i].getSpeed(), 0);
                                break;
                            }
                            case 4: {
                                player.move(this.spriteNeutrals[i].getSpeed(), 0);
                                break;
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public boolean checkCollisionsKey(ScubaZed spritePlayer) {
        return spritePlayer.collidesWith(this.spriteKey, true);
    }

    public boolean removeTime() {
        --this.timeLeft;
        return this.timeLeft <= 0;
    }

    public int getTime() {
        return this.timeLeft;
    }

    public void updateFrames() {
        int i = 0;
        while (i < this.spriteDangers.length) {
            this.spriteDangers[i].nextFrame();
            ++i;
        }
        this.spriteKey.nextFrame();
        if (this.spriteNeutrals != null) {
            i = 0;
            while (i < this.spriteNeutrals.length) {
                this.spriteNeutrals[i].nextFrame();
                ++i;
            }
        }
    }

    public void resetTime() {
        this.timeLeft = 60;
    }

    public int getBlinks() {
        return this.blinks;
    }

    public void removeBlinks() {
        --this.blinks;
    }

    public abstract void resetBlinks();

    public void moveObjects() {
    }
}

