#!/usr/bin/env python
# -*- coding: iso-8859-2 -*-
#
# mini python presentation for Symphony 2005
# version: 2005-07-21 22:27:37
#
# Zeeball/Apathy
# Zbigniew Trzcionkowski
# zeeball@interia.pl
# http://mlodapolska.nsf.pl/python/
#------------------------------------------------------------------------------

from visual import *
from string import *
import os
import thread

#------------------------------------------------------------------------------
# text based on label objects...
#------------------------------------------------------------------------------

def introdukcja(napisy):
  mylab=label(text="", height=70, box=0)
  for napis in napisy:
    mylab.color=[0,0,0]
    mylab.text=napis
    for i in range(1,11):
      rate(10)
      mylab.color=[0.1*i,0.1*i,0.1*i]
    rate(1)
    for i in range(11,0,-1):
      rate(10)
      mylab.color=[0.1*i,0.1*i,0.1*i]
  mylab.visible=0
  return

def zoomer(napis):
  mylab=label(text="", height=40, box=0)
  mylab.color=color.black
  mylab.text=napis
  for i in range(0,60,2):
    mylab.height=i
    mylab.pos[0]=mylab.pos[0]-2
    rate(10)
    mylab.color=color.white
  for i in range(60,0,-2):
    mylab.height=i
    mylab.pos[0]=mylab.pos[0]+2
    rate(10)
  mylab.visible=0
  return

#------------------------------------------------------------------------------
# creates over-cube and performs decubisation
#------------------------------------------------------------------------------
def boxy():
  frejm=frame()
  kloc=[]
  bok=5
  for i in range(0,bok+1):
    for j in range(0,bok+1):
      for k in range(0,bok+1):
        kloc.append(box(pos=[i-bok/2,j-bok/2,k-bok/2], length=1, width=1, height=1, frame=frejm, color=color.black))
  frejm.rotate(axis=(0,1,0), angle=-10*0.02, origin=[0,0,-100])
  for obj in frejm.objects:
    obj.color=color.white
  for j in range(0,10):
    rate(20)
    frejm.rotate(axis=(0,1,0), angle=0.02, origin=[0,0,-100])
  for j in range(0,100):
    rate(20)
    frejm.rotate(axis=(1,0,1), angle=0.02)
    frejm.rotate(axis=(0,1,1), angle=0.03)
  for j in range(0,50):
    rate(20)
    i=0
    for obj in frejm.objects:
      i=i+1
      i=i%7
      obj.rotate(axis=(0,1,1), angle=0.03*i, origin=[0,0,0])
      obj.width=obj.width*0.8
      obj.length=obj.length*0.8
      obj.height=obj.height*0.8
    frejm.rotate(axis=(1,0,1), angle=0.01)
    frejm.rotate(axis=(0,1,1), angle=0.02)
  for obj in frejm.objects:
    obj.visible=0
  return

#------------------------------------------------------------------------------
# creates over-cube from decubised mini cubes ;)
#------------------------------------------------------------------------------
def boxy2():
  frejm=frame()
  kloc=[]
  bok=5
  for i in range(0,bok+1):
    for j in range(0,bok+1):
      for k in range(0,bok+1):
        kloc.append(box(pos=[i-bok/2,j-bok/2,k-bok/2], length=1, width=1, height=1, frame=frejm, color=color.black))
  i=0
  for obj in frejm.objects:
    i=i+1
    i=i%7
    obj.rotate(axis=(0,1,1), angle=0.03*i*50, origin=[0,0,0])
    obj.width =0.00000766
    obj.length=0.00000766
    obj.height=0.00000766
  frejm.rotate(axis=(1,0,1), angle=0.01*50)
  frejm.rotate(axis=(0,1,1), angle=0.02*50)
  for obj in frejm.objects:
    obj.color=color.white
  for j in range(0,50):
    rate(20)
    i=0
    for obj in frejm.objects:
      i=i+1
      i=i%7
      obj.rotate(axis=(0,1,1), angle=-0.03*i, origin=[0,0,0])
      obj.width=obj.width*1.266
      obj.length=obj.length*1.266
      obj.height=obj.height*1.266
    frejm.rotate(axis=(1,0,1), angle=-0.01)
    frejm.rotate(axis=(0,1,1), angle=-0.02)
  for j in range(0,100):
    rate(20)
    frejm.rotate(axis=(1,0,1), angle=-0.02)
    frejm.rotate(axis=(0,1,1), angle=-0.03)
  for j in range(0,10):
    rate(20)
    frejm.rotate(axis=(0,1,0), angle=-0.02, origin=[0,0,-100])
  for obj in frejm.objects:
    obj.visible=0
  return

#------------------------------------------------------------------------------
# loader for .ppm (portable pixelmap)
# OUT: obrazek[]
# [0] obrazekR
# [1] obrazekG
# [2] obrazekB
# [3] x_size
# [4] y_size
#------------------------------------------------------------------------------
def load_ppm(name):
  plik=open(name,"rb")
  temp=plik.readline()
  temp=plik.readline()
  temp=plik.readline()
  temp=string.strip(temp)
  tab=string.split(temp," ")
  x_size=string.atoi(tab[0])
  y_size=string.atoi(tab[1])
  temp=plik.readline()
  obrazR=[]
  obrazG=[]
  obrazB=[]
  for i in range(0,x_size):
    for j in range(0,y_size):
      pixR=ord(plik.read(1))
      pixG=ord(plik.read(1))
      pixB=ord(plik.read(1))
      obrazR.append(pixR)
      obrazG.append(pixG)
      obrazB.append(pixB)
  obrazek=[obrazR,obrazG,obrazB,x_size,y_size]
  return obrazek

#------------------------------------------------------------------------------
# makes frame object from date in obrazek structure...
# optionally:
# transparent - black untransparent when !=0
# y - start row
# y2 - amount of rows to process
# defaults to 0 and y_size
#------------------------------------------------------------------------------
def make_frame(obrazek,pos=[0,0,0],transparent=0,y=0,y2=0):
  zet=pos[2]
  igr=pos[1]
  iks=pos[0]
  obrazR=obrazek[0]
  obrazG=obrazek[1]
  obrazB=obrazek[2]
  x_size=obrazek[3]
  y_size=obrazek[4]
  f = frame()
  modele=[]
  if y2==0:
    y2=y_size
  else:
    y2=y2+y
  for i in range(0,x_size):
    modele.append(faces(pos=[], frame = f))
    for j in range(y,y2):
      pixR=obrazR[(y+y2-j-1)*x_size+i]
      pixG=obrazG[(y+y2-j-1)*x_size+i]
      pixB=obrazB[(y+y2-j-1)*x_size+i]
      if (transparent==0 and pixR==0 and pixG==0 and pixB==0):
        continue
      kolor=[0.02*pixR,0.02*pixG,0.02*pixB]
      v1=[iks-x_size/2+i,igr-(y2-y)/2+j-y,zet]
      v2=[iks-x_size/2+i,igr-(y2-y)/2+j-y+1,zet]
      v3=[iks-x_size/2+i+1,igr-(y2-y)/2+j-y+1,zet]
      v4=[iks-x_size/2+i+1,igr-(y2-y)/2+j-y,zet]
      modele[i].append(pos=v3, color=kolor)
      modele[i].append(pos=v2)
      modele[i].append(pos=v1)
      modele[i].append(pos=v4, color=kolor)
      modele[i].append(pos=v3)
      modele[i].append(pos=v1)
  return f

#------------------------------------------------------------------------------
# makes frame made of box objects from data in obrazek structure...
# transparent <>0 color[0,0,0] and white untransparent
# (default transparent)
#------------------------------------------------------------------------------
def make_frame2(obrazek,pos=[0,0,0],transparent=0):
  zet=pos[2]
  igr=pos[1]
  iks=pos[0]
  obrazR=obrazek[0]
  obrazG=obrazek[1]
  obrazB=obrazek[2]
  x_size=obrazek[3]
  y_size=obrazek[4]
  f = frame()
  for i in range(0,x_size):
    for j in range(0,y_size):
      pixR=obrazR[(y_size-j-1)*y_size+i]
      pixG=obrazG[(y_size-j-1)*y_size+i]
      pixB=obrazB[(y_size-j-1)*y_size+i]
      if (transparent==0 and pixR>0.8 and pixG>0.8 and pixB>0.8):
        continue
      if (transparent==0 and pixR==0 and pixG==0 and pixB==0):
        continue
      kolor=[0.004*pixR,0.004*pixG,0.004*pixB]
      v1=[iks+-x_size/2+i,igr-y_size/2+j,zet]
      box(pos=v1, color=kolor,width=5, height=1, length=1, frame=f)
  return f

#------------------------------------------------------------------------------
# deletes frame object...
#------------------------------------------------------------------------------
def delete_frame(frame):
  for obj in frejm.objects:
    obj.visible = 0
  return

#------------------------------------------------------------------------------
# python rotating routine :)
#------------------------------------------------------------------------------
def pytonium():
  obrazek=load_ppm("python2.ppm")
  frejm=make_frame2(obrazek,pos=[0,0,-30])
  rate(1)
  rate(1)
  for i in range(0,140):
    rate(20)
    frejm.rotate(axis=(1,1,0), angle=-0.04)
  for i in range(0,100):
    rate(20)
    frejm.rotate(axis=(0,1,1), angle=0.04)
    frejm.rotate(axis=(1,1,0), angle=0.02)
  for i in range(0,150):
    rate(20)
    frejm.rotate(axis=(1,0,1), angle=0.04)
    frejm.rotate(axis=(0,1,1), angle=0.03)
  for i in range(0,80):
    rate(20)
    frejm.rotate(axis=(1,1,1), angle=0.04)
    frejm.rotate(axis=(1,0,1), angle=0.04, origin=[0,0,30])
  for obj in frejm.objects:
    obj.visible = 0
  return

#------------------------------------------------------------------------------
# displays any text
#------------------------------------------------------------------------------
def scroll(napis):
  def show_letter(litera):
    frejm=0
    for i in range(0,len(fonttab)):
      if fonttab[i]==litera:
        frejm=make_frame(zibifont,y=9*i,y2=9,pos=[60,0,0])
        break
    if frejm==0:
      litera=" "
      for i in range(0,len(fonttab)):
        if fonttab[i]==litera:
          frejm=make_frame(zibifont,y=9*i,y2=9)
          break
    return frejm

  zibifont=load_ppm("zibifont.ppm")
  fonttab="aAbcCdeEfghijklLmnNoOpqrsStuvwxyzXZ0123456789!@ "
  frames=[]
  for i in range(0,15+1):
    frames.append(show_letter(" "))
  for letter in napis:
    try:
      for obj in frames[15].objects:
        obj.visible = 0
    except:
      pass
    frames[15]=frames[14]
    frames[14]=frames[13]
    frames[13]=frames[12]
    frames[12]=frames[11]
    frames[11]=frames[10]
    frames[10]=frames[9]
    frames[9]=frames[8]
    frames[8]=frames[7]
    frames[7]=frames[6]
    frames[6]=frames[5]
    frames[5]=frames[4]
    frames[4]=frames[3]
    frames[3]=frames[2]
    frames[2]=frames[1]
    frames[1]=frames[0]
    frames[0]=show_letter(letter)
    for j in range(0,10):
      rate(20)
      for i in range(0,15+1):
        try:
          frames[i].rotate(axis=(0,1,0), angle=-0.01, origin=[0,0,-90])
          frames[i].rotate(axis=(1,0,1), angle=-0.01*sin(0.2*i))
          frames[i].rotate(axis=(0,1,1), angle=0.01*cos(0.2*i))
          for obj in frames[i].objects:
            obj.color=[i,i,i]
        except:
          pass
  for i in range(0,15+1):
    try:
      for obj in frames[i].objects:
        obj.visible = 0
    except:
      pass
  return

#------------------------------------------------------------------------------
# displays tunnel...
# IN: timeout - amount of rings to end after
#------------------------------------------------------------------------------
def tunnel(timeout):
  licznik=0
  while 1:
    try:
      nowy10.visible=0
    except:
      pass
    try:
      nowy10=nowy9
      posx10=posx9
      posy10=posy9
      kolor10=kolor9
    except:
      pass
    try:
      nowy9=nowy8
      posx9=posx8
      posy9=posy8
      kolor9=kolor8
    except:
      pass
    try:
      nowy8=nowy7
      posx8=posx7
      posy8=posy7
      kolor8=kolor7
    except:
      pass
    try:
      nowy7=nowy6
      posx7=posx6
      posy7=posy6
      kolor7=kolor6
    except:
      pass
    try:
      nowy6=nowy5
      posx6=posx5
      posy6=posy5
      kolor6=kolor5
    except:
      pass
    try:
      nowy5=nowy4
      posx5=posx4
      posy5=posy4
      kolor5=kolor4
    except:
      pass
    try:
      nowy4=nowy3
      posx4=posx3
      posy4=posy3
      kolor4=kolor3
    except:
      pass
    try:
      nowy3=nowy2
      posx3=posx2
      posy3=posy2
      kolor3=kolor2
    except:
      pass
    try:
      nowy2=nowy
      posx2=posx
      posy2=posy
      kolor2=kolor
    except:
      pass
    licznik=licznik+1
    posx=9*cos(0.4*licznik)
    posy=9*sin(0.4*licznik)
    kolor=[0.2*sin(0.3*licznik+4),0.2*cos(0.3*licznik),0.2*sin(0.3*licznik)]
    wsp=3
    stepy=10
    if licznik<timeout:
      nowy=ring(pos=(posx,posy,0), axis=(0,0,1), radius=25, thickness=1.5+sin(0.2*licznik), color=kolor)
    if licznik>timeout+10:
      break
    for i in range(0,stepy):
      rate(50)
      nowy.pos=[posx,posy,stepy*0*wsp+i*wsp]
      try:
        nowy2.pos=[posx2,posx2,stepy*1*wsp+i*wsp]
        nowy2.color=[kolor2[0]*2,kolor2[1]*2,kolor2[2]*2]
      except:
        pass
      try:
        nowy3.pos=[posx3,posx3,stepy*2*wsp+i*wsp]
        nowy3.color=[kolor3[0]*3,kolor3[1]*3,kolor3[2]*3]
      except:
        pass
      try:
        nowy4.pos=[posx4,posx4,stepy*3*wsp+i*wsp]
        nowy4.color=[kolor4[0]*4,kolor4[1]*4,kolor4[2]*4]
      except:
        pass
      try:
        nowy5.pos=[posx5,posx5,stepy*4*wsp+i*wsp]
        nowy5.color=[kolor5[0]*5,kolor5[1]*5,kolor5[2]*5]
      except:
        pass
      try:
        nowy6.pos=[posx6,posx6,stepy*5*wsp+i*wsp]
        nowy6.color=[kolor6[0]*6,kolor6[1]*6,kolor6[2]*6]
      except:
        pass
      try:
        nowy7.pos=[posx7,posx7,stepy*6*wsp+i*wsp]
        nowy7.color=[kolor7[0]*7,kolor7[1]*7,kolor7[2]*7]
      except:
        pass
      try:
        nowy8.pos=[posx8,posx8,stepy*7*wsp+i*wsp]
        nowy8.color=[kolor8[0]*8,kolor8[1]*8,kolor8[2]*8]
      except:
        pass
      try:
        nowy9.pos=[posx9,posx9,stepy*8*wsp+i*wsp]
        nowy9.color=[kolor9[0]*9,kolor9[1]*9,kolor9[2]*9]
      except:
        pass
      try:
        nowy10.pos=[posx10,posx10,stepy*9*wsp+i*wsp]
        nowy10.color=[kolor10[0]*10,kolor10[1]*10,kolor10[2]*10]
      except:
        pass
  return

#------------------------------------------------------------------------------
# endpart
#------------------------------------------------------------------------------
def endpart():
  #--------------------------
  # scroll image data...
  #--------------------------
  def scroll_obraz():
    for i in range(0,20):
      temp=obraz[i*32]
      for k in range(0,31):
        obraz[i*32+k]=obraz[i*32+k+1]
      obraz[i*32+31]=0
    return
  #--------------------------
  # put letter on image...
  #--------------------------
  def wklej_literke(litera):
    for i in range(5,17):
      for k in range(21,31):
        obraz[i*32+k]=litera[(i-4)*10+(k-31)]
    return

  global skrin,theend
  napis = "  apathy we dont care  "
  f=frame()
  abouttxt =" "+chr(10)
  abouttxt+=" credits"+chr(10)
  abouttxt+=" code by zeeball"+chr(10)
  abouttxt+=" music by maze"+chr(10)
  aboutlab=label(text=abouttxt,frame=f,opacity=0.10, border=10, height=34)

  # letters 10x12
  litera = {
      ' ':
      [0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0
       ],
      'a':
      [0,0,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0
       ],
      'b':
      [0,1,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,1,1,1,1,1,0,0,
       0,1,1,0,0,0,0,1,0,0,
       0,1,1,0,0,0,1,1,1,0,
       0,1,1,0,0,0,1,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,1,1,1,1,1,0,0
       ],
      'c':
      [0,0,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0
       ],
      'd':
      [1,1,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,1,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       1,1,1,1,1,1,1,1,0,0
       ],
      'e':
      [1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,1,1,1,1,0,0,0,0,
       1,1,1,1,1,1,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1
       ],
      'E':
      [1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,0,0,
       1,1,1,1,1,1,0,0,0,0,
       1,1,1,1,1,1,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       0,0,0,0,0,0,0,1,1,0,
       0,0,0,0,0,0,1,1,0,0
       ],
      'f':
      [1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,1,1,1,1,0,0,0,0,
       1,1,1,1,1,1,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0
       ],
      'g':
      [0,0,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,1,1,1,1,1,1,
       1,1,0,0,1,1,1,1,1,1,
       1,1,0,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0
       ],
      'h':
      [0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0
       ],
      'i':
      [0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,
       0,0,0,1,1,1,1,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,1,1,1,1,0,0,0
       ],
      'j':
      [0,1,1,1,1,1,1,1,1,1,
       0,1,1,1,1,1,1,1,1,1,
       0,0,0,0,0,0,0,0,1,1,
       0,0,0,0,0,0,0,0,1,1,
       0,0,0,0,0,0,0,0,1,1,
       0,0,0,0,0,0,0,0,1,1,
       0,0,0,0,0,0,0,0,1,1,
       0,0,0,0,0,0,0,0,1,1,
       0,1,1,1,0,0,0,0,1,1,
       0,1,1,1,0,0,0,1,1,1,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0
       ],
      'k':
      [0,1,1,0,0,0,0,0,1,1,
       0,1,1,0,0,0,0,0,1,1,
       0,1,1,0,0,0,0,1,1,1,
       0,1,1,0,0,1,1,1,1,0,
       0,1,1,1,1,1,1,0,0,0,
       0,1,1,1,1,0,0,0,0,0,
       0,1,1,1,1,1,0,0,0,0,
       0,1,1,1,1,1,1,1,0,0,
       0,1,1,0,0,0,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,1,
       0,1,1,0,0,0,0,1,1,1
       ],
      'l':
      [1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1
       ],
      'L':
      [1,1,1,0,0,0,0,0,0,0,
       1,1,1,0,0,0,0,0,0,0,
       1,1,1,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,1,0,0,0,0,0,0,
       1,1,1,1,0,0,0,0,0,0,
       1,1,1,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1
       ],
      'm':
      [1,1,1,0,0,0,0,1,1,1,
       1,1,1,1,0,0,1,1,1,1,
       1,1,0,1,1,1,1,1,1,1,
       1,1,0,0,1,1,1,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1
       ],
      'n':
      [1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,1,0,0,0,0,0,1,1,
       1,1,1,1,0,0,0,0,1,1,
       1,1,0,1,1,0,0,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,0,0,1,1,0,1,1,
       1,1,0,0,0,0,1,1,1,1,
       1,1,0,0,0,0,1,1,1,1,
       1,1,0,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,1,1
       ],
      'o':
      [0,0,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,1,0,0,0,0,1,1,1,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0
       ],
      'O':
      [0,0,0,0,0,1,1,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,1,0,0,0,0,1,1,1,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0
       ],
      'p':
      [1,1,1,1,1,1,1,1,0,0,
       1,1,1,1,1,1,1,1,1,0,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,1,1,1,1,1,1,1,0,
       1,1,1,1,1,1,1,1,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0,
       1,1,0,0,0,0,0,0,0,0
       ],
      'r':
      [1,1,1,1,1,1,1,1,0,0,
       1,1,1,1,1,1,1,1,1,0,
       1,1,1,0,0,0,0,1,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,1,1,1,1,1,1,1,0,
       1,1,1,1,1,1,1,1,0,0,
       1,1,0,0,0,1,1,0,0,0,
       1,1,0,0,0,0,1,1,0,0,
       1,1,0,0,0,0,1,1,0,0,
       1,1,0,0,0,0,1,1,1,0,
       1,1,0,0,0,0,1,1,1,0
       ],
      's':
      [0,0,1,1,1,1,1,1,1,0,
       0,1,1,1,1,1,1,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,0,0,0,
       1,1,1,0,0,0,0,0,0,0,
       0,1,1,1,0,0,0,0,0,0,
       0,1,1,1,1,1,1,1,0,0,
       0,1,1,1,1,1,1,1,1,0,
       0,0,0,0,0,0,1,1,1,1,
       1,1,0,0,0,0,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       0,1,1,1,1,1,1,1,0,0
       ],
      't':
      [1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,0,0,1,1,0,0,1,1,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,1,1,1,1,0,0,0,
       0,0,0,1,1,1,1,0,0,0
       ],
      'u':
      [1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0
       ],
      'v':
      [1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       1,1,1,0,0,0,0,1,1,1,
       0,1,1,1,0,0,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0,
       0,0,0,1,1,1,1,0,0,0,
       0,0,0,0,1,1,0,0,0,0
       ],
      'w':
      [1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,0,0,0,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,1,1,1,1,1,1,1,
       1,1,1,1,0,0,1,1,1,1,
       1,1,1,0,0,0,0,1,1,1
       ],
      'y':
      [0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,1,0,0,1,1,1,0,
       0,1,1,1,1,1,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0,
       0,0,0,1,1,1,1,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0
       ],
      'z':
      [1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,0,0,0,1,1,1,1,0,
       0,0,0,0,0,1,1,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       0,0,0,1,1,1,0,0,0,0,
       0,0,1,1,1,0,0,0,0,0,
       0,0,1,1,0,0,0,0,0,0,
       0,0,1,1,0,0,0,0,0,0,
       0,1,1,1,0,0,0,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1
       ],
      'Z':
      [0,0,0,0,1,1,0,0,0,0,
       0,0,0,0,1,1,0,0,0,0,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       0,0,0,0,1,1,1,1,0,0,
       0,0,0,1,1,1,0,0,0,0,
       0,0,1,1,1,0,0,0,0,0,
       0,0,1,1,0,0,0,0,0,0,
       0,0,1,1,0,0,0,0,0,0,
       0,1,1,1,0,0,0,1,1,1,
       1,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1
       ]
      }

  try:
    obrazek2=load_ppm("pic1.ppm")
    f2=make_frame(obrazek2, pos=[0,0,-12])
  except:
    pass
    
  # make table with box-o-pixels

  bsize=0.1
  boxy=[]
  for i in range(0,20):
    for j in range(0,20):
      boxy.append(box(pos=(-2+(i-10)*0.1,-1.2+(j-10)*0.1,0), length=bsize, width=bsize, height=bsize, frame=f))
      boxy[i*20+j].rotate(axis=(1,0,0), angle=-0.5, origin=(0,0,0))
      boxy[i*20+j].rotate(axis=(0,1,0), angle=0.2, origin=(0,0,0))
      boxy[i*20+j].rotate(axis=(0,0,1), angle=0.1, origin=(0,0,0))

  # image memory is 32x20
  # (letters are put on invisible part)

  obraz=[]
  for i in range(0,32*20):
    obraz.append(0)

  licznik=0
  endof=0
  while 1:
    if endof==1:
      break
    for char in napis:
      if endof==1:
        break
      if litera.has_key(char):
        wklej_literke(litera[char])
      for i in range(0,11):
        rate(25)
        licznik=licznik+1
        aboutlab.opacity=0.4+0.2*sin(0.4*licznik)
        if theend==1:
          endof=1
          break
        try:
          f2.rotate(axis=(0,0,1), angle=0.02, origin=[0,0,0])
        except:
          pass
        scroll_obraz()
        for i in range(0,20):
          for k in range(0,20):
            j=j+1
            sklad=0.5/abs(sin(j*3.14/21))
            if obraz[(32*20)-(k*32+(31-i))]==0:
              boxy[i*20+k].color=(sklad/3,sklad/3,sklad/3)
              wsp=0
            else:
              boxy[i*20+k].color=(sklad*0.5,sklad,0.5*sklad)
              wsp=1.5
            boxy[i*20+k].width=0.5+wsp+0.5*sin(j*3.14/208)
  try:
    for obj in f2.objects:
      rate(100)
      obj.visible=0
  except:
    pass
  for j in range(0,20):
    rate(50)
    skrin.range=skrin.range*0.9
    for obj in f.objects:
      obj.pos[0]=j*0.3
  for obj in f.objects:
    obj.visible=0
  return

#------------------------------------------------------------------------------
# new record effect made in 3 minutes :)
#------------------------------------------------------------------------------
def greets():
  f=frame()
  lab=label(text=" -[ greets for our friends ]-",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(0,0,0)
  lab=label(text="Ephidrena",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(1000,1000,1000)
  lab=label(text="Spaceballs",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(1000,1000,-1000)
  lab=label(text="Tbl",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(1000,-1000,1000)
  lab=label(text="Mawi",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(1000,-1000,-1000)
  lab=label(text="Loonies",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-1000,1000,1000)
  lab=label(text="Scarab",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-1000,1000,-1000)
  lab=label(text="Iris",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-1000,-1000,1000)
  lab=label(text="Rno",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-1000,-1000,-1000)
  lab=label(text="Universe",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(2000,2000,2000)
  lab=label(text="Fit",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(2000,2000,-2000)
  lab=label(text="Tulou",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(2000,-2000,2000)
  lab=label(text="Scoopex",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(2000,-2000,-2000)
  lab=label(text="Zenon",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-2000,2000,2000)
  lab=label(text="Moods Plateau",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-2000,2000,-2000)
  lab=label(text="Mankind",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-2000,-2000,2000)
  lab=label(text="Gods",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-2000,-2000,-2000)
  lab=label(text="Mankind",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(3000,3000,3000)
  lab=label(text="Software Failure",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(3000,3000,-3000)
  lab=label(text="Nature",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(3000,-3000,3000)
  lab=label(text="Up Rough",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(3000,-3000,-3000)
  lab=label(text="Creative Minds",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-3000,3000,3000)
  lab=label(text="Encore",frame=f,opacity=0.10, border=10, height=34)
  lab.pos=(-3000,3000,-3000)
  f.pos=(-60000,0,-50000)
  for i in range(1,30):
    f.pos=(-60000+i*2000,0,-50000)
    f.rotate(axis=(1,1,1), angle=-0.03)
    f.rotate(axis=(1,0,1), angle=-0.02)
    rate(50)
  for i in range(1,200):
    f.pos=(0,0,-50000+i*200)
    f.rotate(axis=(1,1,1), angle=-0.03)
    f.rotate(axis=(1,0,1), angle=-0.02)
    rate(50)
  for i in range(1,360):
    f.rotate(axis=(1,1,1), angle=-0.03)
    f.rotate(axis=(1,0,1), angle=-0.02)
    f.rotate(axis=(0,1,1), angle=0.01)
    rate(50)
  for i in range(200,300):
    f.pos=(i*1,i*1,-50000+i*200)
    f.rotate(axis=(1,1,1), angle=-0.03)
    f.rotate(axis=(1,0,1), angle=-0.02)
    rate(50)
  try:
    for obj in f.objects:
      obj.visible=0
  except:
    pass
  return

#------------------------------------------------------------------------------
# play music this part is system specific
# and might be not portable ;)))))))))))))))
#------------------------------------------------------------------------------
def aplayer( name, card= 0 ):
  global theend
  try:
    import ctypes
    kernel32 = ctypes.windll.kernel32
    thread = kernel32.GetCurrentThread()
    kernel32.SetThreadPriority(thread, 35)
  except ImportError:
    pass
  import pymedia.audio.acodec as acodec
  import pymedia.audio.sound as sound
  import time
  dec= acodec.Decoder( str.split( name, '.' )[ -1 ].lower() )
  snds= sound.getODevices()
  if card not in range( len( snds ) ):
    raise 'Cannot play sound to non existent device %d out of %d' % ( card+ 1, len( snds ) )
  f= open( name, 'rb' )
  snd= None
  s= f.read( 4096 )
  while len( s ):
    r= dec.decode( s )
    if snd== None:
      snd= sound.Output( r.sample_rate, r.channels, sound.AFMT_S16_LE, card )
    if r:
      snd.play( r.data )
    s= f.read( 1024 )
  while snd.isPlaying():
    time.sleep( .05 )
  theend=1

#------------------------------------------------------------------------------
# demo :)
#------------------------------------------------------------------------------

global theend
theend=0
thread.start_new_thread(aplayer, ( "music.mp3" , 0))

skrin=display(width=800, height=600)
skrin.fullscreen = 1

rate(1.2)

skrin.title="--[ Apathy we don't care :) ]--"
introdukcja([" ","Apathy","presents","multiplatform","demo","made in"])

rate(10)

skrin.range=180
zoomer(" Python :>")

rate(2)

skrin.range=8
boxy()

skrin.range=8
boxy2()

skrin.range=180
tunnel(90);

skrin.range=45
obrazek=load_ppm("narcyz.ppm")
frejm=make_frame(obrazek,pos=[0,0,-200])
rate(1)
rate(1)

skrin.range=45
napis = "  note that this demo is open source          "
scroll(napis)

for i in range(0,25):
  rate(20)
  frejm.rotate(axis=[1,1,1], angle=0.1, origin=[0,0,-160])
delete_frame(frejm)

skrin.range=40
pytonium()

skrin.range=900
greets()

skrin.range=180
zoomer("THE END")

skrin.range=4.
endpart()

skrin.visible=0
sys.exit()

