float QuadTexOffset = 0.5;
float2 QuadScreenSize : VIEWPORTPIXELSIZE;

float halfPixel=1.0/(2*512);

texture mytex : Texture;
sampler2D mySamp = sampler_state
{
	Texture = <mytex>;
	MinFilter = Linear;
	MagFilter = Linear;
	AddressU = Mirror;
	AddressV = Mirror;
};

float timer : TIME;

float4
AnaglyphicPS(float2 uv : TEXCOORD0) : COLOR
{
	return float4(uv,uv);
}


float2 p[10];/* = { 
   float2(0.3,0.3),
   float2(0.8,0.2),
   float2(0.5,0.7),
   float2(1.0,0.5),
   float2(0.6,0.1),
   float2(0.5,0.5),
   float2(0.4,0.6),
   float2(0.0,0.4),
   float2(0.2,0.7),
   float2(0.0,0.0),
   
   float2(0.3,0.3),
   float2(0.8,0.2),
   float2(0.5,0.7),
   float2(1.0,0.5),
   float2(0.6,0.1),
   float2(0.5,0.5),
   float2(0.4,0.6),
   float2(0.0,0.4),
   float2(0.2,0.7),
   float2(0.0,0.0),

   float2(0.3,0.3),
   float2(0.8,0.2),
   float2(0.5,0.7),
   float2(1.0,0.5),
   float2(0.6,0.1),
   float2(0.5,0.5),
   float2(0.4,0.6),
   float2(0.0,0.4),
   float2(0.2,0.7),
   float2(0.0,0.0),   
   };*/
   
float2
ManDist22(float2 a,float2 b)
{
   //return dot(a-0.5,b-0.5);
   //a-=0.5;
   //b-=0.5;
   float dx=(a.x-b.x);
   float dy=(a.y-b.y);
   //return dx*dy;
   //return dx-dy;
   return sqrt(dx*dx+dy*dy);
}

float2
ManDist1(float2 a,float2 b)
{
	float dx=(a.x-b.x);
	float dy=(a.y-b.y);
	return (dx*dx+dy*dy);
}

inline
float2
ManDist2(float2 a,float2 b)
{
	//return dot(a-0.5,b-0.5);
	//a-=0.5;
	//b-=0.5;
	float dx=(a.x-b.x);
	float dy=(a.y-b.y);
	//return dx*dy;
	//return dx-dy;
	return sqrt(dx*dx+dy*dy);
}
float2
ManDist3(float2 a,float2 b)
{
	float dx=abs(a.x-b.x);
	float dy=abs(a.y-b.y);
	return (dx+dy);
}
float2
ManDist4(float2 a,float2 b)
{
	float dx=(a.x-b.x);
	float dy=(a.y-b.y);
	dx=(dx*dx);
	dy=(dy*dy);
	return (dx*dy);
	//return sqrt(dx*dx+dy*dy)*10;
}

// chessboard/Chebychev distance
float2
ManDist5(float2 a,float2 b)
{
	float dx=abs(a.x-b.x);
	float dy=abs(a.y-b.y);
	return max(dx,dy);
}

// manhatten distance
float2
ManDist6(float2 a,float2 b)
{
	float dx=abs(a.x-b.x);
	float dy=abs(a.y-b.y);
	return dx+dy;
}

// squared distance
float2
ManDist7(float2 a,float2 b)
{
	float dx=(a.x-b.x);
	float dy=(a.y-b.y);
	return dx*dx+dy*dy;
}


float
fun1(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=1;
	for (int i=0; i<4; i++)
	{
		//accum+=max(accum*2,12*ManDist1(p[i],uv));
		accum*=3*(ManDist2(p[i],uv));
	}
	//clip(accum-3.0);
	return 1-accum;
}
float
fun2(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=1;
	for (int i=0; i<26; i++)
	{
		accum+=uv.x;//(p[i],uv);
	}
	for (int i=0; i<2; i++)
	{
		//accum+=min(accum*4,4*ManDist2(p[i],uv));
		accum*=2*ManDist2(p[i],uv);
	}
	//return accum;
	return smoothstep(accum*4,0.4,0.6)-smoothstep(accum*4,0.6,0.7)+smoothstep(accum*4,0.8,1.0);
	return step(accum*2,1.5)-step(accum*2,1.0)*step(accum*2,2.0);
}
float
fun3(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=1;
	int num=9;
	int idx=0;
	for (int i=0; i<num; i++)
	{
		float d=ManDist1(p[i],uv);
		if (accum>d)
		{
			idx=i;
			accum=d;
		}
		//accum=min(accum,d);
		//accum+=distance(p[i],uv);
	}
	//return accum*4;
	return 0.2+((float)idx/(num+3));
	//return smoothstep(accum*4,0.4,0.6)-smoothstep(accum*4,0.6,0.7)+smoothstep(accum*4,0.8,1.0);
	//return step(accum*2,1.5)-step(accum*2,1.0)*step(accum*2,2.0);
}
float
fun4(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=2;
	int num=3;
	int idx=0;
	float mindist=100;
	float maxdist=0;
	float min1=1,min2=1;
	for (int i=0; i<num; i++)
	{
		//float d=(distance(p[i]-0.5,uv-0.5));
		float d=ManDist4(p[i],uv);
		mindist=min(mindist,d);
		maxdist=max(maxdist,d);
		if (min1>d)
		{
			min2=min1;
			min1=d;
		}
		else
		if (min2>d)
		{
			min2=d;
		}
	}
	//return (min2-min1)*40;
	float d0=(min1)/(maxdist-mindist);
	float d1=(min2)/(maxdist-mindist);
	//return d0;
	return d1-d0;
}
float
fun44(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=2;
	int num=6;
	int idx=0;
	float mindist=100;
	float maxdist=0;
	float min1=1,min2=1;
	for (int i=0; i<num; i++)
	{
		//float d=(distance(p[i]-0.5,uv-0.5));
		float d=ManDist1(p[i],uv);
		mindist=min(mindist,d);
		maxdist=max(maxdist,d);
		if (min1>d)
		{
			min2=min1;
			min1=d;
		}
		else
		if (min2>d)
		{
			min2=d;
		}
	}
	return (min2+min1)*12;
	float d0=(min1)/(maxdist-mindist);
	float d1=(min2)/(maxdist-mindist);
	//return d0;
	return d1-d0;
}
float
fun5(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=2;
	int num=3;
	int idx=0;
	float mindist=1000;
	float maxdist=0;
	float min1=1,min2=1;
	for (int i=0; i<3; i++)
	{
		float d=(distance(p[i]-0.5,uv-0.5));
		mindist=min(mindist,d);
		maxdist=max(maxdist,d);
		if (min1>d)
		{
			min2=min1;
			min1=d;
			idx=i;
		}
		else
		if (min2>d)
		{
			min2=d;
		}
		//accum=min(accum,d);
		//accum+=distance(p[i],uv);
	}
	//return (float)idx/num;
	float d0=(min1)/(maxdist-mindist);
	float d1=(min2)/(maxdist-mindist);
	//return smoothstep(d0,0.0,0.2);//-smoothstep(d0*4,0.6,0.7);//+smoothstep(d0*4,0.8,1.0);
	return maxdist-mindist;
}
float
fun22(float2 uv)
{
   //p[0]=mousePos.xy;
   float accum=1;
   for (int i=0; i<5; i++)
   {
    //  accum+=min(p[i],uv);
   }
   for (int i=0; i<4; i++)
   {
      //accum+=min(accum,ManDist2(p[i],uv));
      accum*=2*ManDist2(p[i],uv);
   }
   //return accum/3;
   float a=smoothstep(accum*4,0.4,0.6)-smoothstep(accum*4,0.6,0.7)+smoothstep(accum*4,0.8,1.0);
   float b=step(accum*2,1.5)-step(accum*2,1.0)*step(accum*2,2.0);
   return a;
}


float
mirrorAbs(float a,float b)
{
	float x=fmod(a,b);
	float y=fmod(a,b*2)/(b*2);
	if (y>=b/2)
	{
		x=b-x;
	}
	return x;
}

float circular(float2 uv,float2 pos,float scale)
{
	float c=distance(uv,float2(pos.x,pos.y))*scale;
	//c+=fmod(timer,2);
	float l;
	l=fmod(c,1);
	l=step(l,0.5);
	//l=smoothstep(0.3,0.5,l);
	//l=mirrorAbs(c,1);
	//l=smoothstep(0.1,0.2,l);
	return l;
}
float
circular2(float2 uv,float2 pos,float scale)
{
	float x=uv.x-pos.x;
	float y=uv.y-pos.y;
	float c=sqrt(x*x+y*y)*scale;
	c+=timer*0.01;
	return mirrorAbs(c,1);
}
float
circular3(float2 uv,float2 pos,float scale)
{
	float x=uv.x-pos.x;
	float y=uv.y-pos.y;
	float c=(x*x+y*y)*scale;
	//c*=timer;
	c+=timer*0.01;
	return mirrorAbs(c,1);
}


float4 fun6(float2 uv) : COLOR
{   
	float a=circular2(uv-0.0,p[0],32);
	float b=circular2(uv-0.0,p[1],32);
	float c=circular2(uv-0.0,p[2],32);
	float d=circular2(uv-0.0,p[3],12);
	return a*b*c;
	
	return 1;
}

float
fun7(float2 uv)
{
	//p[0]=mousePos.xy;
	float accum=2;
	int num=6;
	int idx=0;
	float mindist=100;
	float maxdist=0;
	float min1=1,min2=1;
	for (int i=0; i<num; i++)
	{
		//float d=(distance(p[i]-0.5,uv-0.5));
		float d=ManDist1(p[i],uv);
		mindist=min(mindist,d);
		maxdist=max(maxdist,d);
		if (min1>d)
		{
			min2=min1;
			min1=d;
		}
		else
		if (min2>d)
		{
			min2=d;
		}
	}
	return (min2-min1)*12;
	float d0=(min1)/(maxdist-mindist);
	float d1=(min2)/(maxdist-mindist);
	//return d0;
	return d1-d0;
}

float4
fun8(float2 uv)
{
	//float b=mirrorAbs(clamp(timer*0.002,0,4),1.0);
	float b=clamp(timer*0.0002,0,2);
	b=mirrorAbs(b,1);
	b=smoothstep(0,0.1,b);
	b*=512;
	uv-=0.5;
	float2 uvx=round(uv*b)/b;
	uvx+=0.5;
	
	return tex2D(mySamp,uvx);
}

float2
polar(float2 v)
{
	float2 polar;
	polar.x=length(v);
	polar.y=atan2(v.y,v.x);
	return polar;
}

float2
unpolar(float2 polar)
{
	float2 pos;
	pos.x=cos(polar.y)*polar.x;
	pos.y=sin(polar.y)*polar.x;
	return pos;
}

float4
fun9(float2 uv)
{
	float b=clamp(timer*0.02,0,20);
	b=mirrorAbs(b,1);

	uv-=0.5;
/*	float2 p=polar(uv);
	uv=unpolar(p);
	uv+=0.5;
	uv=clamp(uv,float2(0,0),float2(1,1));
	return tex2D(mySamp,uv);
	*/
	float dist=length(uv);
	dist*=10.5;
	//uv=normalize(uv);
	float f=dist+timer*0.1;
	float amp=0.1;
	float2 ofs;
	ofs.x=sin(f)*amp;
	ofs.y=cos(f)*amp;
	return tex2D(mySamp,uv+ofs+0.5);
}
float4
fun10(float2 uv)
{
	float scale=100.0;

	uv-=0.5;
	uv*=scale;
	float2 p=polar(uv);

	p.x-=timer*0.1;//((p.x*1.0f)+timer*0.01)*1.1f;
	
	uv=unpolar(p);
	
	uv/=scale;
	uv+=0.5;
	return tex2D(mySamp,uv);
}

float4 main(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun44(texCoord);
}
float4 main2(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun4(texCoord);
}
float4 main3(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun3(texCoord);
}
float4 main4(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun1(texCoord);
}
float4 main5(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun22(texCoord);
}
float4 main6(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun7(texCoord);
}
float4 main7(float2 texCoord: TEXCOORD0) : COLOR 
{
   return fun6(texCoord);
}
float4 main8(float2 texCoord: TEXCOORD0) : COLOR 
{
	return fun8(texCoord);
	float a=mirrorAbs(clamp(timer*0.2,0,2),1.0);
	return float4(1,1,1,a);
}

void
ScreenQuadVS(
		in float2 Position : POSITION, 
		out float4 outPos : POSITION,
		out float2 outUV : TEXCOORD0)
{
	float2 pos=sign(Position.xy);
	
    outPos=float4(pos,0,1);
    outUV=clamp(pos,0,1);
    
    QuadScreenSize.x=800.0f;
    QuadScreenSize.y=600.0f;
	float2 offset = float2( QuadTexOffset/(QuadScreenSize.x) , QuadTexOffset/(QuadScreenSize.y) );
	outPos.y*=-1;
    //outUV.x=0.5*(1+pos.x) + offset.x;
    //outUV=TexCoord.xy+offset;   
	//outUV=0.5*(1+pos) + halfPixel;
}

technique TestFX
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main();
		CullMode = NONE;
	}
};
technique TestFX2
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main2();
		CullMode = NONE;
	}
};
technique TestFX3
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main3();
		CullMode = NONE;
	}
};
technique TestFX4
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main4();
		CullMode = NONE;
	}
};
technique TestFX5
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main5();
		CullMode = NONE;
	}
};
technique TestFX6
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main6();
		CullMode = NONE;
	}
};
technique TestFX7
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main7();
		CullMode = NONE;
		ZEnable			=	False;
		ZWriteEnable	=	False;		
		AlphaBlendEnable=FALSE;
		SrcBlend=ONE;
		DestBlend=ONE;
	}
};
technique TestFX8
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main8();
		CullMode = NONE;
		ZEnable			=	False;
		ZWriteEnable	=	False;
		AlphaBlendEnable=False;
		SrcBlend=SrcAlpha;
		DestBlend=InvSrcAlpha;
	}
};
technique TestFX5b
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main5();
		CullMode = NONE;
		ZEnable			=	False;
		ZWriteEnable	=	False;		
		AlphaBlendEnable=True;
		SrcBlend=One;
		DestBlend=One;
	}
};