
float4x4 WorldViewProj : WorldViewProj;
float4x4 WorldView : WorldView;
float timer : TIME;

texture Tex1;

sampler Sampler1 = sampler_state
{
	Texture   = <Tex1>;
	MinFilter = Linear;
	MagFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
};

//spherical env map
//takes viewspace normal
float2 texgenSpherical(float3 normal)
{
	float2 o;
	o.x = (normal.x*0.5)+0.5;
	o.y = (normal.y*0.5)+0.5;
	return o;
}

void
vsmain(in float4 vertexPos : POSITION,
       in float3 vertexNrm : NORMAL,
       in float4 vertexCol : COLOR0,
	   out float4 outPos : POSITION,
	   out float3 outUV : TEXCOORD0)
{
	outPos = mul(vertexPos, WorldViewProj);
	outUV = mul(vertexNrm, (float3x3)WorldView);	
}

float4
psmain(float3 uv : TEXCOORD0) : COLOR0
{
    float2 tmpuv = texgenSpherical(uv);
    return tex2D(Sampler1, tmpuv.xy);
}

technique SinTube
{
	pass p0
	{
		VertexShader = compile vs_2_0 vsmain();
		PixelShader = compile ps_2_0 psmain();
		CullMode = NONE;
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
		AlphaBlendEnable = True;
        SrcBlend    = One;
        DestBlend   = One;		
	}
};