float QuadTexOffset = 0.5;
float2 QuadScreenSize : VIEWPORTPIXELSIZE;

float halfPixel=1.0/(2*512);

texture mytex : Texture;
sampler2D mySamp = sampler_state
{
	Texture = <mytex>;
	MinFilter = Linear;
	MagFilter = Linear;
	AddressU = Mirror;
	AddressV = Mirror;
};

float timer : TIME;


void
ScreenQuadVS(
		in float2 Position : POSITION, 
		out float4 outPos : POSITION,
		out float2 outUV : TEXCOORD0)
{
	float2 pos=(Position.xy);
	
    outPos=float4(pos,0,1);
    outUV=clamp(sign(pos),0,1);
    
    QuadScreenSize.x=800.0f;
    QuadScreenSize.y=600.0f;
	float2 offset = float2( QuadTexOffset/(QuadScreenSize.x) , QuadTexOffset/(QuadScreenSize.y) );
	outPos.y*=-1;
    //outUV.x=0.5*(1+pos.x) + offset.x;
    //outUV=TexCoord.xy+offset;   
	//outUV=0.5*(1+pos) + halfPixel;
}

float4 color=float4(1,1,1,1);

float4
main(in float2 uv : TEXCOORD0) : COLOR0
{
	return color;
}

technique TestFX
{
	pass p0
	{
		VertexShader = compile vs_2_0 ScreenQuadVS();
		PixelShader = compile ps_2_0 main();
		CullMode = NONE;
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}
};