
struct VS_INPUT
{
    float4  Pos             :	POSITION;
    float3  Normal          :	NORMAL;
    float4  Diffuse			:	COLOR;
};

struct VS_OUTPUT
{
    float4  Pos			:	POSITION;
    float4  Diffuse		:	COLOR;
    float2  Tex0		:	TEXCOORD0;
    float2  Tex1		:	TEXCOORD1;
};

float4x4 WorldView		: WORLDVIEW;
float4x4 Projection		: PROJECTION;
float4x4 WorldViewProj	: WORLDVIEWPROJ;


texture SrcTex;
sampler SrcSamp = sampler_state
{
	Texture = <SrcTex>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;

	AddressU = Clamp;
	AddressV = Clamp;
};


// schlicks approximation for fresnel term
FLOAT Fresnel(FLOAT n)
{
    FLOAT Rs = 0.5f;// refractive index
    return Rs+(1-Rs)*(1-pow(n,5));
}

// shading based on camera space normal
float shadeZNormal(float3 N)
{
	N=normalize(N);
	float col=0.5;
	//col=abs(N.x)*abs(N.y)*abs(N.z);
	//col=abs(cos(N.z));
	//col=(cos(N.z)*cos(N.z));
	//col=abs(N.x)+abs(N.y);		//cheap hack, looks bad
	//col=1-Fresnel(cos(1-N.z));

	float na=abs(cos(N.z*3.14/2));
	col=smoothstep(0.5,1.0,na);
	//col=1-abs(smoothstep(0.0,0.9,abs(N.z)));


	return col;
}

// shade based on angle between forward eye vector and surface normal
// the normal MUST be transformed by the full 4x4 viewmatrix
float shadeFakeTranslucency(float3 pos,float3 N)
{
	float3 eyespaceNormal=normalize(N);
	float3 eyespaceEyeVec=normalize( -mul(pos,WorldView) );
	float nv=abs( dot(eyespaceNormal,eyespaceEyeVec) );
	return 0.5f-nv;
}

// usually this is o.pos.z
float shadeZCloseToScreen(float z)
{
	return 1.0-(z*0.02);
}

float3 colorNormal(float3 n)
{
	return abs(n);
}


//spherical env map
//takes viewspace normal
float2 texgenSpherical(float3 normal)
{
	float2 o;
	o.x = (normal.x*0.5)+0.5;
	o.y = (normal.y*0.5)+0.5;
	return o;
}
float4 brightnessContrast(float4 color,float b,float c)
{
	float4 o;
	o-=b;
	o*=c;
	return o;
}

VS_OUTPUT VShade(VS_INPUT i)
{
    VS_OUTPUT   o;

	o.Pos  = mul(i.Pos, WorldViewProj);

	//spherical env map
    float3 N = mul(i.Normal, (float3x3)WorldView);    // position (view space)
    float3 NN = mul(float4(i.Normal,1), (float4x4)WorldView);
	o.Tex0=texgenSpherical(N);
	o.Tex1=i.Pos.xy;

	o.Diffuse=float4(1,1,1,1);
	o.Diffuse.xyz=shadeFakeTranslucency(i.Pos,NN);
	//o.Diffuse.xyzw*=shadeZNormal(N);
	//o.Diffuse.xyz+=0.5;
	
	float4 ambient=0.0;
	
	o.Diffuse+=ambient;
	
	//o.Diffuse.xyz*=shadeZCloseToScreen(o.Pos.z);
    //o.Diffuse.w=shadeZCloseToScreen(o.Pos.z);

	//o.Diffuse.xyz=colorNormal(N);
	//o.Diffuse.xyz=i.Diffuse.xyz;
	//o.Diffuse=brightnessContrast(o.Pos,0.0,1.0);

	//o.Diffuse=1-(o.Pos.z*0.01);

    return o;
}

float4 PShade(VS_OUTPUT i) : COLOR
{
	float4 col=0;
	float4 col2=0;
	col=tex2D( SrcSamp, i.Tex0 );
	//col2=tex2D( SrcSamp, i.Tex1 );
	return col;
	col=col*(i.Diffuse)+i.Diffuse;
	//float4 emissive=0.0;
	//col+=emissive;
	//col+=col2;
	//col=i.Diffuse;
	//col=(1-i.Diffuse);
	//col=float4(1,1,1,1);
	return col;
};

technique test
{
    pass p0
    {
		VertexShader = compile vs_1_1 VShade();
		PixelShader = compile ps_1_1 PShade();

        // Set up reasonable material defaults
        //MaterialAmbient   = {1.0, 1.0, 1.0, 1.0}; 
        //MaterialDiffuse   = {1.0, 1.0, 1.0, 1.0}; 
        //MaterialSpecular  = {1.0, 1.0, 1.0, 1.0}; 
        //MaterialPower     = 40.0;

		CullMode		=	CW;
        FillMode		=	Solid;
		ZEnable			=	True;
		ZWriteEnable	=	True;

		AlphaBlendEnable	=	False;
		SrcBlend			=	SRCALPHA;
		DestBlend			=	INVSRCALPHA;
		SrcBlend			=	SRCCOLOR;
		DestBlend			=	INVSRCCOLOR;
          
        // Turn lighting on and use light 0
        Lighting = False;
        SpecularEnable = False;
        //LightEnable[0] = True;
        
        // Set up one directional light
        //LightType[0]      = DIRECTIONAL;
        //LightAmbient[0]   = {0.2, 0.2, 0.2, 1.0};
        //LightDiffuse[0]   = {0.0, 0.0, 0.8, 1.0};
        //LightSpecular[0]  = {1.0, 1.0, 1.0, 1.0}; 
        //LightDirection[0] = {0.7, -0.7, 0.0 };
        //LightRange[0]     = 100000.0f;

        // Set up textures and texture stage states
        //ColorOp[0] = SelectArg2;
        //ColorArg1[0] = Texture;
        //ColorArg2[0] = Diffuse;
        //AlphaOp[0] = SelectArg2;
        //AlphaArg1[0] = Texture;
        //AlphaArg2[0] = Diffuse;
        ColorOp[1] = Disable;
        AlphaOp[1] = Disable;
    }
}

float4 PShade2(VS_OUTPUT i) : COLOR
{
	float4 col=0;
	float4 col2=0;
	col=tex2D( SrcSamp, i.Tex0 );
	return col;
	col=col*(i.Diffuse)+i.Diffuse;
	return col;
};

technique test2
{
    pass p0
    {
		VertexShader = compile vs_1_1 VShade();
		PixelShader = compile ps_1_1 PShade2();

		CullMode		=	CW;
        FillMode		=	Solid;
		ZEnable			=	True;
		ZWriteEnable	=	True;

		AlphaBlendEnable	=	False;
		SrcBlend			=	SRCALPHA;
		DestBlend			=	INVSRCALPHA;
		SrcBlend			=	SRCCOLOR;
		DestBlend			=	INVSRCCOLOR;
    }
}


//////////////////////////////

float4 DebugColor = { 1.0,1.0,1.0,1.0 };

struct VS_FALLBACK_INPUT
{
    float4  Pos             :	POSITION;
};

struct VS_FALLBACK_OUTPUT
{
    float4  Pos			:	POSITION;
};

VS_FALLBACK_OUTPUT VShade_Fallback(VS_FALLBACK_INPUT i)
{
    VS_FALLBACK_OUTPUT   o;
	o.Pos  = mul(i.Pos, WorldViewProj);
    return o;
}

float4 PShade_Fallback(VS_FALLBACK_OUTPUT i) : COLOR
{
	return DebugColor;
};

technique fallback
{
	pass p0
	{
		VertexShader = compile vs_1_1 VShade_Fallback();
		PixelShader = compile ps_1_1 PShade_Fallback();
		FillMode = Wireframe;
		AlphaBlendEnable	=	False;
		Lighting = False;
		FogEnable = False;
	}
}