
struct VS_INPUT
{
    float4  Pos             :	POSITION;
    float3  Normal          :	NORMAL;
    float4  Diffuse			:	COLOR;
};

struct VS_OUTPUT
{
    float4  Pos			:	POSITION;
    float4  Diffuse		:	COLOR;
    float2  Tex0		:	TEXCOORD0;
    float3  norm        :   TEXCOORD1;
};

float4x4 WorldView		: WORLDVIEW;
float4x4 Projection		: PROJECTION;
float4x4 WorldViewProj	: WORLDVIEWPROJ;

texture SrcTex;
sampler SrcSamp = sampler_state
{
	Texture = <SrcTex>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;

	AddressU = Clamp;
	AddressV = Clamp;
};


// schlicks approximation for fresnel term
FLOAT Fresnel(FLOAT n)
{
    FLOAT Rs = 0.5f;// ?????
    return Rs+(1-Rs)*(1-pow(n,5));
}

// shading based on camera space normal
float shadeZNormal(float3 N)
{
	N=normalize(N);
	float col=0.5;
	//col=abs(N.x)*abs(N.y)*abs(N.z);
	//col=abs(cos(N.z));
	//col=(cos(N.z)*cos(N.z));
	//col=abs(N.x)+abs(N.y);		//cheap hack, looks bad
	//col=Fresnel(cos(1-N.z));

	float na=abs(cos(N.z*3.14/2));
	col=smoothstep(0.0,1.0,na);

	return col;
}

// shade based on angle between forward eye vector and surface normal
// the normal MUST be transformed by the full 4x4 viewmatrix
float shadeFakeTranslucency(float3 pos,float3 N)
{
	float3 eyespaceNormal=normalize(N);
	float3 eyespaceEyeVec=normalize( -mul(pos,WorldView) );
	float nv=abs( dot(eyespaceNormal,eyespaceEyeVec) );
	return 1.0-nv;
}

// usually this is o.pos.z
float shadeZCloseToScreen(float z)
{
	return 1.0-(z*0.02);
}


//spherical env map
//takes viewspace normal
float2 texgenSpherical(float3 normal)
{
	float2 o;
	o.x = (normal.x*0.5)+0.5;
	o.y = (normal.y*0.5)+0.5;
	return o;
}

VS_OUTPUT VShade(VS_INPUT i)
{
    VS_OUTPUT   o;

	o.Pos  = mul(i.Pos, WorldViewProj);

	//spherical env map
    float3 N = mul(float4(i.Normal,1), (float3x3)WorldView);    // position (view space)
	o.Tex0=texgenSpherical(N);

	o.Diffuse=float4(1,1,1,1);
	o.Diffuse.xyz=shadeFakeTranslucency(i.Pos,N);
	o.Diffuse.xyz*=shadeZNormal(N);
	o.norm=N;
	//o.Diffuse.xyz*=shadeZCloseToScreen(o.Pos.z);
    //o.Diffuse.w=shadeZCloseToScreen(o.Pos.z);
    return o;
}

float4 PShade(VS_OUTPUT i) : COLOR
{
	//return float4(i.norm,1);
	float4 col=0;
	col=tex2D( SrcSamp, i.Tex0 );
	//col=col*(i.Diffuse);
	//col=i.Diffuse;
	return col;
};

technique test
{
    pass p0
    {
		VertexShader = compile vs_1_1 VShade();
		PixelShader = compile ps_1_1 PShade();
		CullMode		= None;
        FillMode		= Solid;
		ZEnable			=	False;
		ZWriteEnable	=	False;

		AlphaBlendEnable	=	True;
		SrcBlend			=	SRCCOLOR;
		DestBlend			=	INVSRCCOLOR;
    }
}