#include "quad.fx"

texture TexCopyTexture : Texture;

sampler SamplerCopyTexture = sampler_state
{
	Texture   = <TexCopyTexture>;
	//MinFilter = LINEAR;
	//MagFilter = LINEAR;
	//MipFilter = NONE;
	//AddressU = Wrap;
	//AddressV = Wrap;
};

texture TexBase;
texture TexBlend;

sampler SamplerBase = sampler_state
{
	Texture   = <TexBase>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;
};
sampler SamplerBlend = sampler_state
{
	Texture   = <TexBlend>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;
};


float  weight[8];


float4
ps_debug_copytexture(const in float2 uv : TEXCOORD0) : COLOR
{
	return tex2D(SamplerBase,uv);
}

float4
ps_debug_flatcolour() : COLOR
{
	float4 col=1;
	return col;
}

technique Copy
{
	pass P0
	{
        vertexshader = compile vs_1_1 ScreenQuadVS();
        pixelshader  = compile ps_2_0 ps_debug_copytexture();

        ZEnable			=	False;
        ZWriteEnable	=	True;
        AlphaBlendEnable = False;
        Lighting     = False;
        CullMode     = None;	
	}
}

#include "blendmodes.fx"


float colcol=1.0;

float4
ps_blend(float2 uv: TEXCOORD0) : COLOR
{
	//return tex2D(SamplerBase,uv);
	//return tex2D(SamplerBlend,uv);
	//return float4(1,0,colcol,0);
	return differenceColors( tex2D(SamplerBase,uv),tex2D(SamplerBlend,uv) );
}

technique Blend
{
	pass P0
	{
        vertexshader = compile vs_1_1 ScreenQuadVS();
        pixelshader  = compile ps_2_0 ps_blend();

        ZEnable			=	False;
        ZWriteEnable	=	False;
        AlphaBlendEnable = False;
        Lighting     = False;
        CullMode     = None;
 	}
}


float4
ps_darken(float2 uv: TEXCOORD0) : COLOR
{
	float4 color=tex2D(SamplerBase,uv);
	float col=(color.x+color.y+color.z)/3;
	col=max(col-0.5,0)*2;
	return col;
}

technique Darken
{
	pass P0
	{
        vertexshader = compile vs_1_1 ScreenQuadVS();
        pixelshader  = compile ps_2_0 ps_darken();

        ZEnable			=	False;
        ZWriteEnable	=	False;
        AlphaBlendEnable = False;
        Lighting     = False;
        CullMode     = None;
 	}
}