#include "quad.fx"

texture inputTexture;

sampler SamplerOriginalScene = sampler_state
{
	Texture   = <inputTexture>;
	MinFilter = Point;
	MagFilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
};

// shader inputs
float4x4 colorMatrix;

float4x4 DEBUGMatrix = 
{ 
	1.0, 0.0, 0.0, 0.0,
	0.0, 1.0, 0.0, 0.0,
	0.0, 0.0, 1.0, 0.0,
	0.0, 0.0, 0.0, 1.0,
}; 

float4
ps_colorMatrix(const float2 texCoord : TEXCOORD0) : COLOR
{
	// NOTE: alpha must be 1 for color-translation to work as we are
	//       only using a 4x4 matrix.  to support alpha a 5x5 matrix would be needed
	float4 col=float4( tex2D(SamplerOriginalScene,texCoord).xyz,1 );
	float4 col2=mul(colorMatrix,col);
	return float4(col2.xyz,1);
}
/*
float4
levels(float4 col,float inBlack, float inWhite,float inGamma,float outBlack,float outWhite)
{
	float4 p=pow( (inPixel*255.0 - inBlack) / (inWhite-inBlack) , inGamma)
	p=p*(outWhite-outBlack) + outBlack;
	p/=255.0;
	return p;	
}*/

technique PostProcess_ColorMatrix
{
	pass P0
	{
        vertexshader = compile vs_1_1 ScreenQuadVS();
        // NOTE: this needs to be ps_2_0 to support higher number range for scaling and translation
        pixelshader  = compile ps_2_0 ps_colorMatrix();

        ZEnable			=	False;
        ZWriteEnable	=	True;
        
        AlphaBlendEnable = False;
        SrcBlend    = One;
        DestBlend   = One;        
 
        Lighting     = False;
        CullMode     = None;
 	}
}