-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- NonConForm (c)kRadD  
-- -------------------
--    kradd@tscc.de
-- -------------------
-- lua library file
-- -------------------
-- Description: lua functions concerning screens and painting of objects
-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++


-- ********************************************************
--- non_prePaint
-- - stops the vbl(that set the video adress)<br>
-- - switch the screenadress
-- - paint the actual paintlist

function non_prePaint()
	nonsys:suspendVBL();

	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		counter=0

		if table.getn(nonInternals.nonSprites_bg1)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg1) do
				sprite:drawBackground();
				counter=counter+1;
			end

			for delete=1,counter do
				table.remove(nonInternals.nonSprites_bg1,1);
			end
		end
	else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		counter=0;

		if table.getn(nonInternals.nonSprites_bg2)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg2) do
				sprite:drawBackground();
				counter=counter+1;
			end
		end

		for delete=1,counter do
			table.remove(nonInternals.nonSprites_bg2,1);
		end
	end

	non_paintSingleScreen();
end

-- ********************************************************
--- non_postPaint
-- - draw sprites
-- - restart the vbl(to set a new screenadress)<br>
-- - wait for a vbl

function non_postPaint()
	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				sprite:fetchBackground();
			end
		end
		for sprite in itervalues(nonInternals.nonSprites) do
			if bitand(sprite:getFlag(),1)==0 then
				sprite:draw();
				table.insert(nonInternals.nonSprites_bg1,sprite);
			end
		end
	else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					sprite:fetchBackground();
				end
			end
			
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					if bitand(sprite:getFlag(),1)==0 then
						sprite:draw();
						table.insert(nonInternals.nonSprites_bg2,sprite);
					end
				end
			end
		end
	end

	nonsys:revokeVBL();
	nonsys:waitForVBL();
	nonsys:switchScreens();
end

-- ********************************************************
--- non_paintSingleScreen
-- switch the screen, then paint the objects in the actual paintlist,
-- and then waits for the next VBL

function non_paintSingleScreen()
	local object;

	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		counter=0
		for object in itervalues(nonInternals.nonPaintList1) do
			if type(object)=="function" then
				for functionobject in itervalues(object()) do
					functionobject:draw();
				end
			else
				object:draw();
			end
			counter=counter+1;
		end
		for delete=1,counter do
			table.remove(nonInternals.nonPaintList1,1);
		end
	else
		counter=0
		for object in itervalues(nonInternals.nonPaintList2) do
			if type(object)=="function" then
				for functionobject in itervalues(object()) do
					functionobject:draw();
				end
			else
				object:draw();
			end
			counter=counter+1;
		end
		for delete=1,counter do
			table.remove(nonInternals.nonPaintList2,1);
		end
	end
end

-- ********************************************************
--- non_paintScreens
-- paint the objects in both paintlists

function non_paintScreens()
	non_prePaint()
	non_postPaint();

	non_prePaint()
	non_postPaint();
end

-- ********************************************************
--- non_waitSwitchScreen
-- Switch the screens, for double buffering. Then waits for 
-- the next VBL

function non_waitSwitchScreen()
	nonsys:suspendVBL();
	nonsys:switchScreens();
	nonsys:revokeVBL();
	nonsys:waitForVBL();
end

-- ********************************************************
--- non_addtoPaintList
-- add a object to the paintlists, so that this object will be painted
-- during the next VBL
-- @object: the object to add to the paintlist
-- @@: value the object

function non_addToPaintList(object)
	table.insert(nonInternals.nonPaintList1,object);
	table.insert(nonInternals.nonPaintList2,object);

	return object;
end

-- ********************************************************
--- non_paintView
-- step through a table and paint all objects

function non_paintView(table)
	for key,value in pairs(table) do
		if type(value)=="string" then
			non_paintViewGroups(table.viewgroups[value]);
		elseif type(value)~="table" then
			non_addToPaintList(value);
		end
	end
end

-- ********************************************************
--- non_paintViewGroups
-- step through a table and paint all viewgroups

function non_paintViewGroups(table)
	for key,value in pairs(table) do
		if type(value)=="table" then
			non_paintViewGroups(value);
		else
			non_addToPaintList(value);
		end
	end
end

-- ********************************************************
--- non_paintStoryView
-- step through a table and paint all objects

function non_paintStoryView(arg_table,arg_pagecounter)
	for key,value in pairs(arg_table) do
		if type(value)=="string" then
			non_paintStoryViewGroups(arg_table.viewgroups[value],key,arg_pagecounter);
		elseif type(value)~="table" and type(value)~="function" then
			non_addToPaintList(value);
		end
	end
end

-- ********************************************************
--- non_paintStoryViewGroups
-- step through a table and paint the active page

function non_paintStoryViewGroups(arg_table,arg_parent,arg_pagecounter)
	for key,value in pairs(arg_table) do
		if type(value)=="table" then
			if arg_parent~="page" then
				non_paintStoryViewGroups(value,key,arg_pagecounter);
			else
				if key==arg_pagecounter then
					non_paintStoryViewGroups(value,key,arg_pagecounter);
				end
			end
		else
			non_addToPaintList(value);
		end
	end
end

