-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- NonConForm (c)kRadD  
-- -------------------
--    kradd@tscc.de
-- -------------------
-- lua library file
-- -------------------
-- Description: lua MVC controller functions
-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++

-- *************************************************************
--- non_controStory
-- paints the view and wait for a pressed key or button
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllStory(view,model)
	-- +++ local variables +++++++++++++++++++++++++++++++++++++++
	non_pagecounter=1;
	
	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintStoryView(view,non_pagecounter);
		
	-- +++ wait for a pressed key or pressed jagpad button +++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();
	
		non_refreshControlls();

		if bitand(nonInternals.nonMasterPad,NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT then
			if non_pagecounter > 1 then
				non_pagecounter=non_pagecounter-1;
				non_paintStoryView(view,non_pagecounter);
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT then
			if non_pagecounter < table.getn(view.viewgroups.pages.page) then
				non_pagecounter=non_pagecounter+1;
				non_paintStoryView(view,non_pagecounter);
			end
		end
		
		non_controllsEvents(model);

		non_postPaint();

		collectgarbage();
	end
		
 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllScrollWaitForInput
-- paints the view and wait for a pressed key or button
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllScrollWaitForInput(view,model)
	nonInternals.nonSprites[1]=NonCSprite.new(0,100,16,16,nonShapes.scrollchars[1],0,1);
	nonInternals.nonSprites[2]=NonSprite.new(16,100,16,16,nonShapes.scrollchars[1],0,2);
	nonInternals.nonSprites[3]=NonSprite.new(32,100,16,16,nonShapes.scrollchars[1],0,3);
	nonInternals.nonSprites[4]=NonSprite.new(48,100,16,16,nonShapes.scrollchars[1],0,4);
	nonInternals.nonSprites[5]=NonSprite.new(64,100,16,16,nonShapes.scrollchars[1],0,5);
	nonInternals.nonSprites[6]=NonSprite.new(80,100,16,16,nonShapes.scrollchars[1],0,6);
	nonInternals.nonSprites[7]=NonSprite.new(96,100,16,16,nonShapes.scrollchars[1],0,7);
	nonInternals.nonSprites[8]=NonSprite.new(112,100,16,16,nonShapes.scrollchars[1],0,8);
	nonInternals.nonSprites[9]=NonSprite.new(128,100,16,16,nonShapes.scrollchars[1],0,9);
	nonInternals.nonSprites[10]=NonSprite.new(144,100,16,16,nonShapes.scrollchars[1],0,10);
	nonInternals.nonSprites[11]=NonSprite.new(160,100,16,16,nonShapes.scrollchars[1],0,11);
	nonInternals.nonSprites[12]=NonSprite.new(176,100,16,16,nonShapes.scrollchars[1],0,12);
	nonInternals.nonSprites[13]=NonSprite.new(192,100,16,16,nonShapes.scrollchars[1],0,13);
	nonInternals.nonSprites[14]=NonSprite.new(208,100,16,16,nonShapes.scrollchars[1],0,14);
	nonInternals.nonSprites[15]=NonSprite.new(224,100,16,16,nonShapes.scrollchars[1],0,15);
	nonInternals.nonSprites[16]=NonSprite.new(240,100,16,16,nonShapes.scrollchars[1],0,16);
	nonInternals.nonSprites[17]=NonSprite.new(256,100,16,16,nonShapes.scrollchars[1],0,17);
	nonInternals.nonSprites[18]=NonSprite.new(272,100,16,16,nonShapes.scrollchars[1],0,18);
	nonInternals.nonSprites[19]=NonSprite.new(288,100,16,16,nonShapes.scrollchars[1],0,19);
	nonInternals.nonSprites[20]=NonSprite.new(304,100,16,16,nonShapes.scrollchars[1],0,20);
	nonInternals.nonSprites[21]=NonCSprite.new(320,100,16,16,nonShapes.scrollchars[1],0,21);

	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);

	local hscroll=8;
	
	-- +++ wait for a pressed key or pressed jagpad button +++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();
	
		non_refreshControlls();
		non_controllsEvents(model);

		for i=1,21 do 
			local oldx=nonInternals.nonSprites[i]:getX();

			if hscroll > 0 then
				oldx=oldx-2;
			else
				oldx=oldx+14;
			end
			nonInternals.nonSprites[i]:setX(oldx);
		end
		
		if hscroll > 0 then
			hscroll=hscroll-1;
		else
			hscroll=7;
		end	

		non_postPaint();

	--	collectgarbage();
	end
	collectgarbage();

	non_clearSprites();
		
 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- ********************************************************
--- non_controllScrollerWaitForInput
-- Controller that display a scroller and wait for a pressed button or pressed space
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllScrollerWaitForInput(view,model)
	local y_sin={0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1};
	local x_move={0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15};

	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);
	
	-- +++ paint view ++++++++++++++++++++++++++++++++++++++++++++
	non_paintScreens()

	--local scroller=NonScroller.new(24,0,0,186,320,26,"GRTX@TO:@LINEOUT,TWH,ESCAPE,GGN@@@@@@@@@@@@@@@@@GRTX@TO:@LINEOUT,TWH,ES",nonFonts.font1616g,16,0);
	
--@@ICONS@BY@FLASH/TNB@@@GRTX@TO:@STOT@TEAM-CHRISTOS,STOT@PARTICIPANTS,PICROSSST@TEAM,RESERVOIR@GODS,RGC,MUGUK,GAZTEE,LINKOVITCH,BEETLE,TWH,LINEOUT,GGN,TUXIE,MCFALCON,GEMINI8,CXT,ESCAPE,NEOSCIENTISTS,STRIDER
--ALL@PLAYERS@AT@THE@AC,JAGFEST@UK@AND@E-JAGFEST@@@@@@@@@@@@@@@@@@
	local scrtext="@@ICONS@BY@FLASH/TNB@@@GRTX@TO:@STOT@TEAM-CHRISTOS,STOT@PARTICIPANTS,PICROSSST@TEAM,RESERVOIR@GODS,PARADIZE,RGC,MUGUK,GAZTEE,LINKOVITCH,BEETLE,TWH,DIVISION,LINEOUT,GGN,TUXIE,MCFALCON,GEMINI8,CXT,ESCAPE,NEOSCIENTISTS,STRIDER,";
	scrtext=scrtext.."ALL@PLAYERS@AT@THE@AC,JAGFEST-UK@AND@E-JAGFEST@@@@@@@@@@@@@@@@@@ICONS@BY@FLASH/TNB@@@GR";
	local scroller=NonScroller.new(24,0,0,186,320,26,scrtext,nonFonts.font1616g,16,0);

	-- +++ wait for a pressed key or pressed jagpad button +++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		for scrollx=0,31 do
			non_prePaint();

			scroller:draw(x_move[scrollx+1],y_sin[scrollx+1]);
			
			non_refreshControlls();			
			non_controllsEvents(model);

			if  nonInternals.nonExitEvent~=NON_NOTHING then
				break;
			end
			
			non_postPaint();
		end
	
		if scroller:getCharCounter()<285 then
			scroller:increaseCharCounter();
		else
			scroller:setCharCounter(0);
		end

		collectgarbage();
	end

	-- +++ return ++++++++++++++++++++++++++++++++++++++++++++++++++++
 	return model.stagename,non_StageSelection("next",model.nextstages);
end
	
-- ********************************************************
--- non_controllBeeHeadSelection
-- Controller of a beeHead player selection
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllBeeHeadSelection(view,model)
	local counter=0;
	local handle;
	local filename;
	local playernumberx=0;
	local playerpicturex=0;
	local playernamex=0;
	local centerarea=0;
	local playerarea=0;

	-- *** Load available pictures ***********************
	for counter=1,model.numberofbeeheads do
		filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\"..(counter+model.topplayerid-1)..".f16";
		handle=io.open(filename,"r")
		if handle==nil then
			filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\none.f16";
		end				

		model.allplayerpics[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()]=NonImage.new(filename,20,20);
		model.allplayershapes[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()]=NonShape.new(0,0,20,20,model.allplayerpics[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()])
	end

	-- ************************ View *********************
	for controllercounter=1,model.numberofbeeheads do
		view.viewgroups.beeheadselect.optionpictures[controllercounter]:setShape(model.allplayershapes[controllercounter]);
		view.viewgroups.beeheadselect.options[controllercounter]:setText(nonInternals.nonBeeHeadPlayers[controllercounter+model.topplayerid-1]:getName8(),0);
	end

	playernumberx=view.viewgroups.playersselect.numbers[1]:getX();
	playerpicturex=view.viewgroups.playersselect.optionpictures[1]:getX();
	playernamex=view.viewgroups.playersselect.options[1]:getX();
	playerarea=view.viewgroups.playersselect.numbers[2]:getX()-view.viewgroups.playersselect.numbers[1]:getX();
	centerarea=playerarea+view.viewgroups.playersselect.numbers[8]:getX()-view.viewgroups.playersselect.numbers[1]:getX();

	-- +++ delete players that do not participate ++++++++++++++++
	if model.maximumplayerstochoose>nonGlobals.nonNumberOfPlayers then
		for playercounter=model.maximumplayerstochoose,nonGlobals.nonNumberOfPlayers+1,-1 do
			table.remove(view.viewgroups.playersselect.optionpictures,playercounter);
			table.remove(view.viewgroups.playersselect.options,playercounter);
			table.remove(view.viewgroups.playersselect.numbers,playercounter);
		end
	end
	
	-- +++ set player pictures and texts +++++++++++++++++++++++++
	for playercounter=1,nonGlobals.nonNumberOfPlayers do
		view.viewgroups.playersselect.optionpictures[playercounter]:setShape(nonInternals.nonPlayerShapes[playercounter]);
		view.viewgroups.playersselect.options[playercounter]:setText(nonInternals.nonPlayers[playercounter]:getName3(),0);
		
		if model.center==true then
			view.viewgroups.playersselect.numbers[playercounter]:setX(((playercounter-1)*playerarea)+playernumberx+((centerarea-(nonGlobals.nonNumberOfPlayers*playerarea))/2));
			view.viewgroups.playersselect.options[playercounter]:setX(((playercounter-1)*playerarea)+playernamex+((centerarea-(nonGlobals.nonNumberOfPlayers*playerarea))/2));
			view.viewgroups.playersselect.optionpictures[playercounter]:setX(((playercounter-1)*playerarea)+playerpicturex+((centerarea-(nonGlobals.nonNumberOfPlayers*playerarea))/2));
		end
	end

	-- +++ set topplayerid to default +++++++++++++++++++++++++++++++++++++ 
	nonGlobals[model.globalvalues["topbeeheadplayerid"]]=model.topplayerid;

	-- +++ go to last selection +++ 
	if nonGlobals[model.globalvalues["menupoint"]]~=nil then 
		model.menupoint=nonGlobals[model.globalvalues["menupoint"]];
	end

	-- reload topplayerid ++++++++++++++++++++++++++++++++++++++++
	model.topplayerid=nonGlobals[model.globalvalues["topbeeheadplayerid"]]
	
	-- +++ wait that all buttons are not pressed
	non_refreshControlls()
	nonInternals.nonControllers:waitAllButtonsNotPressed();

	-- +++ set font of actual menupoint to active font +++++++++++
	for counter=1,model.choices do
		model.viewelements.options[counter]:setCharset(model.fonts.inactive);
	end
	model.viewelements.options[model.menupoint]:setCharset(model.fonts.active);
	
	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);		
	
	-- +++ wait for a pressed key or pressed jagpad button +++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();

		non_refreshControlls();

		if nonGlobals.nonNumberOfPlayers>0 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_1)==NON_JAGPADKEY_1 then
			non_chooseBeeHeadPlayer(view,model,1);
		elseif nonGlobals.nonNumberOfPlayers>1 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_2)==NON_JAGPADKEY_2 then
			non_chooseBeeHeadPlayer(view,model,2);
		elseif nonGlobals.nonNumberOfPlayers>2 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_3)==NON_JAGPADKEY_3 then
			non_chooseBeeHeadPlayer(view,model,3);
		elseif nonGlobals.nonNumberOfPlayers>3 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_4)==NON_JAGPADKEY_4 then
			non_chooseBeeHeadPlayer(view,model,4);
		elseif nonGlobals.nonNumberOfPlayers>4 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_5)==NON_JAGPADKEY_5 then
			non_chooseBeeHeadPlayer(view,model,5);
		elseif nonGlobals.nonNumberOfPlayers>5 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_6)==NON_JAGPADKEY_6 then
			non_chooseBeeHeadPlayer(view,model,6);
		elseif nonGlobals.nonNumberOfPlayers>6 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_7)==NON_JAGPADKEY_7 then
			non_chooseBeeHeadPlayer(view,model,7);
		elseif nonGlobals.nonNumberOfPlayers>7 and bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_8)==NON_JAGPADKEY_8 then
			non_chooseBeeHeadPlayer(view,model,8);
		end

		if bitand(nonInternals.nonMasterPad,NON_CONTROLLERUP)==NON_CONTROLLERUP then
			if model.menupoint > model.ybeeheads then
				model.viewelements.options[model.menupoint]:setCharset(model.fonts.inactive);
				model.viewelements.options[model.menupoint-model.ybeeheads]:setCharset(model.fonts.active);

				non_addToPaintList(model.viewelements.options[model.menupoint]);
				non_addToPaintList(model.viewelements.options[model.menupoint-model.ybeeheads]);

				model.menupoint=model.menupoint-model.ybeeheads;
			else
				if model.topplayerid-model.numberofbeeheads>1 then
					model.topplayerid=model.topplayerid-model.numberofbeeheads;
				else
					model.topplayerid=1;
				end		
	
				non_paintPlayers(model.topplayerid,view.viewgroups.beeheadselect.options,model.allplayerpics,model.numberofbeeheads);

				non_paintView(view);		
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN then
			if model.menupoint <= model.choices-model.ybeeheads then
				model.viewelements.options[model.menupoint]:setCharset(model.fonts.inactive);
				model.viewelements.options[model.menupoint+model.ybeeheads]:setCharset(model.fonts.active);

				non_addToPaintList(model.viewelements.options[model.menupoint+model.ybeeheads]);
				non_addToPaintList(model.viewelements.options[model.menupoint]);

				model.menupoint=model.menupoint+model.ybeeheads;
			else
				if model.topplayerid+model.numberofbeeheads>nonInternals.nonAvailablePlayers-model.numberofbeeheads then
					model.topplayerid=1+nonInternals.nonAvailablePlayers-model.numberofbeeheads;
				else
					model.topplayerid=model.topplayerid+model.numberofbeeheads;
				end
	
				non_paintPlayers(model.topplayerid,view.viewgroups.beeheadselect.options,model.allplayerpics,model.numberofbeeheads);

				non_paintView(view);		
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT then
			if model.menupoint>1 then
				model.viewelements.options[model.menupoint]:setCharset(model.fonts.inactive);
				model.viewelements.options[model.menupoint-1]:setCharset(model.fonts.active);

				non_addToPaintList(model.viewelements.options[model.menupoint-1]);
				non_addToPaintList(model.viewelements.options[model.menupoint]);
		
				model.menupoint=model.menupoint-1;
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT then
			if model.menupoint<model.choices then
				model.viewelements.options[model.menupoint]:setCharset(model.fonts.inactive);
				model.viewelements.options[model.menupoint+1]:setCharset(model.fonts.active);

				non_addToPaintList(model.viewelements.options[model.menupoint+1]);
				non_addToPaintList(model.viewelements.options[model.menupoint]);
				
				model.menupoint=model.menupoint+1;
			end
		end
		
		non_controllsEvents(model);
		
		non_postPaint();

		collectgarbage();
	end

	-- +++ set globalvalues ++++++++++++++++++++++++++++++++++++++++++
	nonGlobals[model.globalvalues["topbeeheadplayerid"]]=model.topplayerid;

	-- +++ return ++++++++++++++++++++++++++++++++++++++++++++++++++++
 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- ********************************************************
--- non_controllBeeheadMenuWithSubStages
-- Controller of a menu screen with substages. Beehead player
-- data is loaded.
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllBeeHeadMenuWithSubStages(view,model)
	local handle;
	local filename;

	-- *** Load available pictures ***********************
	for counter=1,model.numberofbeeheads do
		filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\"..(counter+model.topplayerid-1)..".f16";
		handle=io.open(filename,"r")
		if handle==nil then
			filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\none.f16";
		end				

		model.allplayerpics[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()]=NonImage.new(filename,20,20);
		model.allplayershapes[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()]=NonShape.new(0,0,20,20,model.allplayerpics[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()])
	end

	-- ************************ View *********************
	for controllercounter=1,model.numberofbeeheads do
		view.viewgroups.beeheadselect.optionpictures[controllercounter]:setShape(model.allplayershapes[controllercounter]);
		view.viewgroups.beeheadselect.options[controllercounter]:setText(nonInternals.nonBeeHeadPlayers[controllercounter+model.topplayerid-1]:getName6(),0);
	end

	for playercounter=1,NON_MAXIMUMPLAYERS do
		view.viewgroups.playersselect.optionpictures[playercounter]:setShape(nonInternals.nonPlayerShapes[playercounter]);
		view.viewgroups.playersselect.options[playercounter]:setText(nonInternals.nonPlayers[playercounter]:getName3(),0);
	end

	-- +++ set topplayerid to default +++++++++++++++++++++++++++++++++++++ 
	nonGlobals[model.globalvalues["topbeeheadplayerid"]]=model.topplayerid;

	while true do
		nonInternals.nonDevNull,nonInternals.nonNextStage,nonInternals.nonNextStageType=non_controllMenu(view,model);

		if nonInternals.nonNextStageType==NON_SUBSTAGE then
			model.lastsubstage,nonInternals.nonNextStage,nonInternals.nonNextStageType=nonInternals.nonNextStage(view,model);
		else
			return model.stagename,non_StageSelection(nonInternals.nonNextStage,model.nextstages);
		end

		collectgarbage();
	end
end

function non_chooseBeeHeadPlayer(view,model,choise)
	local filename;
	local handle;
	
	filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\" .. (model.menupoint+model.topplayerid-1) .. ".f16";
	handle=io.open(filename,"r")
	if handle==nil then
		filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\default\\" .. (model.menupoint) .. ".f16";
	end				

	nonInternals.nonPlayerPics[choise]:loadImage(filename,20,20);			
	nonInternals.nonPlayerShapes[choise]=NonShape.new(0,0,20,20,nonInternals.nonPlayerPics[choise]);
	nonInternals.nonPlayers[choise]=nonInternals.nonBeeHeadPlayers[model.menupoint+model.topplayerid-1];
	
	for playercounter=1,nonGlobals.nonNumberOfPlayers do
		view.viewgroups.playersselect.optionpictures[playercounter]:setShape(nonInternals.nonPlayerShapes[playercounter]);
		view.viewgroups.playersselect.options[playercounter]:setText(nonInternals.nonPlayers[playercounter]:getName3(),0);
	end

	non_paintView(view);		
	
	collectgarbage();
end

-- ********************************************************
--- non_controllMenuWithSubStages
-- Controller of a menu screen with substages
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllMenuWithSubStages(view,model)
	while true do
		nonInternals.nonDevNull,nonInternals.nonNextStage,nonInternals.nonNextStageType=non_controllMenu(view,model);

		if nonInternals.nonNextStageType==NON_SUBSTAGE then
			model.lastsubstage,nonInternals.nonNextStage,nonInternals.nonNextStageType=nonInternals.nonNextStage(view,nil);
		else
			return model.stagename,non_StageSelection(nonNextStage,model.nextstages);
		end

		collectgarbage();
	end
end

-- ********************************************************
--- non_controllMenu
-- Controller of a menu screen
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllMenu(view,model)
	model.choice=0;
	--model.menupoint=1;

	-- +++ react on controller movement +++++++++++++++++++++
  non_MenuFunctionality(view,model);

	if nonInternals.nonExitEvent==NON_NEXTEVENT then
	 	return model.stagename,non_StageSelection(model.choice,model.nextstages);
	else
		return model.stagenamen,nil,nil;
	end
end

-- ********************************************************
-- non_MenuFunctionality
-- ********************************************************

function non_MenuFunctionality(view,model)
	local counter=0;

	-- +++ set font of actual menupoint to active font +++++++++++
	for counter=1,model.choices do
		model.viewelements.options[counter]:setCharset(model.fonts.inactive);
	end
	model.viewelements.options[model.menupoint]:setCharset(model.fonts.active);

	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);		
	
	-- +++ Controller ++++++++++++++++++++++++++++++++++++++++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();

		non_refreshControlls();

		if bitand(nonInternals.nonMasterPad,NON_CONTROLLERUP)==NON_CONTROLLERUP then
			if model.menupoint>1 then
				model.viewelements.options[model.menupoint]:setCharset(model.fonts.inactive);
				model.viewelements.options[model.menupoint-1]:setCharset(model.fonts.active);

				non_addToPaintList(model.viewelements.options[model.menupoint]);
				non_addToPaintList(model.viewelements.options[model.menupoint-1]);

				model.menupoint=model.menupoint-1;
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN then
			if model.menupoint<model.choices then
				model.viewelements.options[model.menupoint]:setCharset(model.fonts.inactive);
				model.viewelements.options[model.menupoint+1]:setCharset(model.fonts.active);

				non_addToPaintList(model.viewelements.options[model.menupoint]);
				non_addToPaintList(model.viewelements.options[model.menupoint+1]);

				model.menupoint=model.menupoint+1;
			end
		end
		
		if bitand(nonInternals.nonMasterPad,NON_JAGPADFIRE_B)==NON_JAGPADFIRE_B then
			model.choice=model.menupoint;
			if model.choice~=0 then
				nonInternals.nonExitEvent=NON_NEXTEVENT;
			end
		else
			non_controllsEvents(model);
			non_postPaint();
		end

		collectgarbage();
	end
end

-- ********************************************************
--- non_controllOption
-- Controller of a option screen
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllOption(view,model)
	local counter=0;

	model.choice=0;
	model.menupoint=1;

		-- +++ set Texts and pictures ++++++++++++++++++++++++++++++++
	for counter=1,model.choices do
		view.viewgroups.options[counter]:setText(model.texts[counter]);
		if type(nonGlobals[model.globalvalues[counter]])=="boolean" then
			view.viewgroups.valuecomponents[counter]:setShape(model.checkpictures[convertBoolToInt(nonGlobals[model.globalvalues[counter]])+1]);
		else
			view.viewgroups.valuecomponents[counter]:setText(nonGlobals[model.globalvalues[counter]]);
		end
		if view.viewgroups.picturecomponents then
			view.viewgroups.picturecomponents[counter]:setShape(model.pictures[counter]);
		end
	end

	-- +++ set font of actual menupoint to active font +++++++++++
	for counter=1,model.choices do
		view.viewgroups.options[counter]:setCharset(model.fonts.inactive);
	end
	view.viewgroups.options[model.menupoint]:setCharset(model.fonts.active);

	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);		
	
	-- +++ Controller ++++++++++++++++++++++++++++++++++++++++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();
						
		non_refreshControlls();

		if bitand(nonInternals.nonMasterPad,NON_CONTROLLERUP)==NON_CONTROLLERUP then
			if model.menupoint>1 then
				view.viewgroups.options[model.menupoint]:setCharset(model.fonts.inactive);
				view.viewgroups.options[model.menupoint-1]:setCharset(model.fonts.active);

				non_addToPaintList(view.viewgroups.options[model.menupoint]);
				non_addToPaintList(view.viewgroups.options[model.menupoint-1]);

				model.menupoint=model.menupoint-1;
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN then
			if model.menupoint<model.choices then
				view.viewgroups.options[model.menupoint]:setCharset(model.fonts.inactive);
				view.viewgroups.options[model.menupoint+1]:setCharset(model.fonts.active);

				non_addToPaintList(view.viewgroups.options[model.menupoint]);
				non_addToPaintList(view.viewgroups.options[model.menupoint+1]);

				model.menupoint=model.menupoint+1;
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT then
			if type(nonGlobals[model.globalvalues[model.menupoint]])=="boolean" then
				if nonGlobals[model.globalvalues[model.menupoint]]==true then
					nonGlobals[model.globalvalues[model.menupoint]]=false
				else
					nonGlobals[model.globalvalues[model.menupoint]]=true
				end
				view.viewgroups.valuecomponents[model.menupoint]:setShape(model.checkpictures[convertBoolToInt(nonGlobals[model.globalvalues[model.menupoint]])+1]);
			else			
				if nonGlobals[model.globalvalues[model.menupoint]]>model.min[model.menupoint] then
					nonGlobals[model.globalvalues[model.menupoint]]=nonGlobals[model.globalvalues[model.menupoint]]-1;
					view.viewgroups.valuecomponents[model.menupoint]:setText(tostring(nonGlobals[model.globalvalues[model.menupoint]]));
				end
			end

			for object in itervalues(view.viewgroups.background) do
				non_addToPaintList(object);
			end
			for object in itervalues(view.viewgroups.options) do
				non_addToPaintList(object);
			end
			for object in itervalues(view.viewgroups.valuecomponents) do
				non_addToPaintList(object);
			end
			if view.viewgroups.picturecomponents then
				for object in itervalues(view.viewgroups.picturecomponents) do
					non_addToPaintList(object);
				end
			end
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT then
			if type(nonGlobals[model.globalvalues[model.menupoint]])=="boolean" then
				if nonGlobals[model.globalvalues[model.menupoint]]==true then
					nonGlobals[model.globalvalues[model.menupoint]]=false
				else
					nonGlobals[model.globalvalues[model.menupoint]]=true
				end
				view.viewgroups.valuecomponents[model.menupoint]:setShape(model.checkpictures[convertBoolToInt(nonGlobals[model.globalvalues[model.menupoint]])+1]);
			else			
				if nonGlobals[model.globalvalues[model.menupoint]]<model.max[model.menupoint] then
					nonGlobals[model.globalvalues[model.menupoint]]=nonGlobals[model.globalvalues[model.menupoint]]+1;
					view.viewgroups.valuecomponents[model.menupoint]:setText(tostring(nonGlobals[model.globalvalues[model.menupoint]]));
				end
			end

			for object in itervalues(view.viewgroups.background) do
				non_addToPaintList(object);
			end
			for object in itervalues(view.viewgroups.options) do
				non_addToPaintList(object);
			end
			for object in itervalues(view.viewgroups.valuecomponents) do
				non_addToPaintList(object);
			end
			if view.viewgroups.picturecomponents then
				for object in itervalues(view.viewgroups.picturecomponents) do
					non_addToPaintList(object);
				end
			end
		end

		non_controllsEvents(model);
		non_postPaint();

		collectgarbage();
	end

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllWaitForInput
-- paints the view and wait for a pressed key or button
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllWaitForInput(view,model)
	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);
	
	-- +++ wait for a pressed key or pressed jagpad button +++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();
	
		non_refreshControlls();
		non_controllsEvents(model);

		non_postPaint();

		collectgarbage();
	end
		
 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllShowTournamentScores
-- paints the view, display the scores in a table and wait for a pressed key or button
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllShowTournamentScores(view,model)
	local playercounter;
	local place;
	local placecounter;

 	local	amountpadspressed=0;
	local pads={};
	local playerpressedbutton={false,false,false,false,false,false,false,false};
	local confirmspritesY={};

	-- +++ delete players that do not participate ++++++++++++++++
	if NON_MAXIMUMPLAYERS>nonGlobals.nonNumberOfPlayers then
		if model.showMaximumCompetitionResults==false then 
			for playercounter=1,NON_MAXIMUMPLAYERS do
				for placecounter=nonGlobals.nonNumberOfPlayers+1,NON_MAXIMUMPLAYERS do
					table.remove(view.viewgroups.players[playercounter].playerdependent,placecounter);
				end
			end
		end		

		if model.showMaximumOfPlayers==false then
			for playercounter=NON_MAXIMUMPLAYERS,nonGlobals.nonNumberOfPlayers+1,-1 do
				table.remove(view.viewgroups.players,playercounter);
			end
		end
	end
	
	-- +++ delete missinginactions of participating players +++++
	if nonGlobals.nonNumberOfPlayers>1 then
		if model.showMissingInActions==true then 
			for playercounter=1,nonGlobals.nonNumberOfPlayers-1 do
				table.remove(view.viewgroups.mia[playercounter],2);
				table.remove(view.viewgroups.mia[playercounter],1);
			end
		end
	end
		
	-- +++ set data +++++++++++++++++++++++++++++++++++++++++++++++++++++++
	for playercounter=1,nonGlobals.nonNumberOfPlayers do
		confirmspritesY[playercounter]=view.sprites[playercounter]:getY();
	end
		
	for playercounter=1,nonGlobals.nonNumberOfPlayers do
		place=nonGlobals[model.globalvalues.scores][playercounter].actuallplace;
		view.viewgroups.players[place].playerindependent.place:setText(tostring(place));

		if nonGlobals[model.globalvalues.scores][playercounter].lastplace==place or nonInternals.nonRoundCounter==1 then
			view.viewgroups.players[place].playerindependent.change:setShape(model.shapes.same);
		elseif nonGlobals[model.globalvalues.scores][playercounter].lastplace<place then
			view.viewgroups.players[place].playerindependent.change:setShape(model.shapes.increase);
		elseif nonGlobals[model.globalvalues.scores][playercounter].lastplace>place then
			view.viewgroups.players[place].playerindependent.change:setShape(model.shapes.decrease);
		end

		view.viewgroups.players[place].playerindependent.picture:setShape(nonInternals.nonPlayerShapes[playercounter]);
		view.viewgroups.players[place].playerindependent.name:setText(nonInternals.nonPlayers[playercounter]:getName8());

 		for placecounter=1,nonGlobals.nonNumberOfPlayers do
			if nonGlobals[model.globalvalues.scores][playercounter].roundresult==placecounter then
	    	view.viewgroups.players[place].playerdependent[placecounter].amount:setCharset(model.fonts.roundresult);
			else
				view.viewgroups.players[place].playerdependent[placecounter].amount:setCharset(model.fonts.notroundresult);
			end
			view.viewgroups.players[place].playerdependent[placecounter].amount:setText(tostring(nonGlobals[model.globalvalues.scores][playercounter].tournamentresults[placecounter]));
		end

		view.viewgroups.players[place].playerindependent.points:setText(tostring(nonGlobals[model.globalvalues.scores][playercounter].points));
		view.viewgroups.players[place].playerindependent.last:setText(tostring(nonGlobals[model.globalvalues.scores][playercounter].roundpoints));

		-- +++ set sprites +++++++++++++++++++++++++++++++++++++++++
		nonInternals.nonSprites[playercounter]=view.sprites[playercounter];
		nonInternals.nonSprites[playercounter]:setY(confirmspritesY[place]);
	end	

	-- +++put rounds into model +++++++++++++++++++++++++++++++++++++++
	view.viewgroups.round.actualround:setText(nonInternals.nonRoundCounter);
  view.viewgroups.round.totalrounds:setText(nonGlobals.nonNumberOfRounds);
	
	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);		


	-- +++ wait that all players pressed their buttons +++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();
		
		player=1;

		non_refreshControlls();

		for portcounter=1,2 do
			for controllercounter=1,4 do
				if player<=nonGlobals.nonNumberOfPlayers and playerpressedbutton[player]==false then
					if nonInternals.nonControllers:isButtonPressed(portcounter,controllercounter)==true then
						nonInternals.nonControllers:waitButtonNotPressed(portcounter,controllercounter);		
						nonInternals.nonSprites[player]:setShape(model.buttonpressed);
						playerpressedbutton[player]=true;
						amountpadspressed=amountpadspressed+1;
						
						if amountpadspressed==nonGlobals.nonNumberOfPlayers then
							nonInternals.nonExitEvent=NON_NEXTEVENT;
						end 
					end
				end
				player=player+1;
			end
		end

		non_controllsEvents(model);
		
		non_postPaint();

		collectgarbage();
	end

	-- +++ clear sprites +++++++++++++++++++++++++++++++++++++++++
	non_clearSprites();

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllShowSingleScores
-- paints the view, display the scores in a table and wait for a pressed key or button
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllShowSingleScores(view,model)
	local playerpics={nil,nil,nil,nil,nil,nil,nil,nil,nil,nil};
	local playershapes={nil,nil,nil,nil,nil,nil,nil,nil,nil,nil};
	local filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\none.f16";
	local counter;

	for counter=1,model.numberofdisplayedscores do
		playerpics[counter]=NonImage.new(filename,20,20);
		playershapes[counter]=NonShape.new(0,0,20,20,playerpics[counter]);
	end

	non_scorespaint(model,view,playerpics,playershapes);
	
	-- +++ Controller ++++++++++++++++++++++++++++++++++++++++++++
	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();

		non_refreshControlls();

		if bitand(nonInternals.nonMasterPad,NON_CONTROLLERUP)==NON_CONTROLLERUP then
			if model.placecounter-model.numberofdisplayedscores > 0 then
				model.placecounter=model.placecounter-model.numberofdisplayedscores;
			else
				model.placecounter=1;
			end
			non_scorespaint(model,view,playerpics,playershapes);
		elseif bitand(nonInternals.nonMasterPad,NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN then
			if model.placecounter+model.numberofdisplayedscores <= model.numberofscores-model.numberofdisplayedscores+1 then
				model.placecounter=model.placecounter+model.numberofdisplayedscores;
			else
				model.placecounter=model.numberofscores-model.numberofdisplayedscores+1;
			end
			non_scorespaint(model,view,playerpics,playershapes);
		end
		
		non_controllsEvents(model);

		non_postPaint();

		collectgarbage();
	end

	for counter=1,model.numberofscores do
		nonGlobals[model.globalvalues.scores][counter].newscore=false;
	end

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

function non_scorespaint(model,view,playerpics,playershapes)
	local counter;

	local handle;
	local filename;
	
	-- +++ set data +++++++++++++++++++++++++++++++++++++++++++++++++++++++
	for counter=1,model.numberofdisplayedscores do
		-- +++ set charset ++++++++++++++++++++++++++++++++++++
		if nonGlobals[model.globalvalues.scores][counter-1+model.placecounter].newscore==false then
			view.viewgroups.scores[counter].name:setCharset(model.fonts.old);	
			view.viewgroups.scores[counter].points:setCharset(model.fonts.old);
			view.viewgroups.scores[counter].place:setCharset(model.fonts.old);
		else
			view.viewgroups.scores[counter].name:setCharset(model.fonts.new);	
			view.viewgroups.scores[counter].points:setCharset(model.fonts.new);
			view.viewgroups.scores[counter].place:setCharset(model.fonts.new);
		end

		-- +++ place ++++++++++++++++++++++++++++++++++++++++++
		view.viewgroups.scores[counter].place:setText(tostring(counter-1+model.placecounter));

		-- +++ Load scoreplayer picture +++++++++++++++++++++++
		filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\"..nonGlobals[model.globalvalues.scores][counter-1+model.placecounter].id..".f16";
		handle=io.open(filename,"r")
		if handle==nil then
			filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\none.f16";
		end				
		playerpics[counter]=NonImage.new(filename,20,20);
		playershapes[counter]=NonShape.new(0,0,20,20,playerpics[counter]);
		
		-- +++ picture ++++++++++++++++++++++++++++++++++++++++
		view.viewgroups.scores[counter].picture:setShape(playershapes[counter]);

		-- +++ name +++++++++++++++++++++++++++++++++++++++++++
		view.viewgroups.scores[counter].name:setText(nonInternals.nonBeeHeadPlayers[nonGlobals[model.globalvalues.scores][counter-1+model.placecounter].id]:getName6());

		-- +++ points +++++++++++++++++++++++++++++++++++++++++
		view.viewgroups.scores[counter].points:setText(nonGlobals[model.globalvalues.scores][counter-1+model.placecounter].score);
	end
	-- +++ fill paintlist ++++++++++++++++++++++++++++++++++++++++
	non_paintView(view);		
end

-- *************************************************************
--- non_controllTournamenScoring
-- calculate the tournament scores. For each beaten opponement
-- a player get another point (everybody starts with one point)
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllTournamenScoring(view,model)
	local tempscore=0;
	local playercounter;
	local testcounter;

	-- +++ put round result into model ++++++++++++++++++++++++++++++++
	for i=1,NON_MAXIMUMPLAYERS do
		nonGlobals[model.globalvalues.scores][i].roundresult=nonGlobals[model.globalvalues.results][i].result;
		nonGlobals[model.globalvalues.scores][i].roundpoints=nonGlobals[model.globalvalues.results][i].points;
	end

	-- +++ set points,lastplace and resultsarrays(8-1) ++++++++++++++++
	for playercounter=0,nonGlobals.nonNumberOfPlayers-1 do
		-- points
		nonGlobals[model.globalvalues.scores][playercounter+1].points=nonGlobals[model.globalvalues.scores][playercounter+1].points+nonGlobals[model.globalvalues.results][playercounter+1].points;
		-- tournamentresults
		if nonGlobals[model.globalvalues.scores][playercounter+1].roundresult~=0 then
			tempscore=nonGlobals[model.globalvalues.scores][playercounter+1].tournamentresults[nonGlobals[model.globalvalues.scores][playercounter+1].roundresult];
			tempscore=tempscore+1;
			nonGlobals[model.globalvalues.scores][playercounter+1].tournamentresults[nonGlobals[model.globalvalues.scores][playercounter+1].roundresult]=tempscore;
		end
		--lastplace
		nonGlobals[model.globalvalues.scores][playercounter+1].lastplace=nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace;
		nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace=1;
	end

	-- +++ set actual place +++++++++++++++++++++++++++++++++++++++++++
	for playercounter=0,nonGlobals.nonNumberOfPlayers-2 do
		for testcounter=playercounter+1,nonGlobals.nonNumberOfPlayers-1 do
			--actuallplayer
			points=nonGlobals[model.globalvalues.scores][playercounter+1].points
			testpoints=nonGlobals[model.globalvalues.scores][testcounter+1].points
			-- test points
			if points<testpoints then	
				nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace=nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace+1;
			elseif points>testpoints then
				nonGlobals[model.globalvalues.scores][testcounter+1].actuallplace=nonGlobals[model.globalvalues.scores][testcounter+1].actuallplace+1;
			else
				-- test 1st places
				local found=false;
				for testtournamentresults=1,8 do
					points=nonGlobals[model.globalvalues.scores][playercounter+1].tournamentresults[testtournamentresults]
					testpoints=nonGlobals[model.globalvalues.scores][testcounter+1].tournamentresults[testtournamentresults]
					
					if points<testpoints then	
						nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace=nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace+1;
						found=true;
						break;
					elseif points>testpoints then
						nonGlobals[model.globalvalues.scores][testcounter+1].actuallplace=nonGlobals[model.globalvalues.scores][testcounter+1].actuallplace+1;
						found=true;
						break;
					end
				end
				-- test roundresult
				if found==false then
					points=nonGlobals[model.globalvalues.scores][playercounter+1].roundresult;
					testpoints=nonGlobals[model.globalvalues.scores][testcounter+1].roundresult;
		
					if points<testpoints then	
						nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace=nonGlobals[model.globalvalues.scores][playercounter+1].actuallplace+1;
					elseif points>testpoints then
						nonGlobals[model.globalvalues.scores][testcounter+1].actuallplace=nonGlobals[model.globalvalues.scores][testcounter+1].actuallplace+1;
					end
				end				
			end
		end
	end	

	collectgarbage();

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllSingleScoring
-- sort the highscores and insert the new score
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllSingleScoring(view,model)
	local sorter;
	local temp;
	local filename;
	local handle;
	local counter;
	local	highscorekey="";
	local writenewfile=false;

	-- +++ calculate highscorefilename ++++++++++++++++++++++++++++++++
	for counter=1,table.getn(nonGlobals.nonHighscoreFileNameParts) do
		highscorekey=highscorekey.."|"..tostring(nonGlobals[nonGlobals.nonHighscoreFileNameParts[counter]]);
	end

	handle=io.open("..\\highscore\\highdict.lua","r")
	if handle~=nil then
		handle:close();
		dofile("..\\highscore\\highdict.lua");
	end		

	if nonGlobals.nonHighscoredictionaryentries[highscorekey]==nil then
		nonGlobals.nonHighscoredictionaryentries[highscorekey]=nonGlobals.nonNumberOfHighscoredictionaryentries+1;
		writenewfile=true;
	end
	
	-- +++ read in score file +++++++++++++++++++++++++++++++++++++++++	
	filename="..\\highscore\\"..nonGlobals.nonHighscoredictionaryentries[highscorekey]..".nhf";
	handle=io.open(filename,"r")
	if handle==nil then
		filename="..\\highscore\\default.nhf";
	else
		handle:close();
	end				

	while table.getn(nonGlobals[model.globalvalues.scores]) > 0 do
		table.remove(nonGlobals[model.globalvalues.scores],1);
	end

	dofile(filename);

	-- +++ newscore of false setzen +++++++++++++++++++++++++++++++++++
	for counter=1,model.numberofscores do
			nonGlobals[model.globalvalues.scores][counter].newscore=false;
	end

	-- +++ insert score +++++++++++++++++++++++++++++++++++++++++++++++
	nonGlobals[model.globalvalues.scores][model.numberofscores+1]={id=nonInternals.nonPlayers[1]:getPlayerID(),score=nonGlobals[model.globalvalues.results][1].points,newscore=true};
	
	for sorter=model.numberofscores,1,-1 do
		if nonGlobals[model.globalvalues.scores][sorter].score < nonGlobals[model.globalvalues.scores][sorter+1].score then
			temp=nonGlobals[model.globalvalues.scores][sorter];
			nonGlobals[model.globalvalues.scores][sorter]=nonGlobals[model.globalvalues.scores][sorter+1];
			nonGlobals[model.globalvalues.scores][sorter+1]=temp;
		end		
	end

	filename="..\\highscore\\"..nonGlobals.nonHighscoredictionaryentries[highscorekey]..".nhf";
	handle=io.open(filename,"w");

	for counter=1,model.numberofscores do
		handle:write("non_ScoreEntry{\n");
		handle:write("\tid = "..nonGlobals[model.globalvalues.scores][counter].id..",\n");
		handle:write("\tscore = "..nonGlobals[model.globalvalues.scores][counter].score..",\n");
		handle:write("\tnewscore = "..tostring(nonGlobals[model.globalvalues.scores][counter].newscore)..",\n");
		handle:write("}\n\n");
	end
	handle:close();

	-- +++ write dictionary file ++++++++++++++++++++++++++++++++++++
	if writenewfile==true then
		handle=io.open("..\\highscore\\highdict.lua","w");

		for key,value in pairs(nonGlobals.nonHighscoredictionaryentries) do
			handle:write("non_highscoredictionaryentry{\n");
			handle:write("\tkey = \""..key.."\",\n");
			handle:write("\tfilenumber = "..value..",\n");
			handle:write("}\n\n");
		end

		handle:close();
	end
	
	collectgarbage();

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllInit
-- NonConFormInitialise
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllInit(view,model)
	local counter;
	local value;
	local testhandle;
	
	-- +++ initialise random +++++++++++++++++++++++++++++++++++++
	math.randomseed(os.time());
	
	-- +++ BeeHead +++++++++++++++++++++++++++++++++++++++++++++++
	if model.beehead.useBeeHead==true then
		-- +++ find the path to the beehead folder +++++++++++++++++
		for folder in itervalues(model.beehead.searchinfolders) do
			testhandle=io.open(folder.."\\beehead\\players.lua","r");
			if testhandle~=nil then
				nonInternals.nonBeeHeadPath=folder.."\\beehead";
				assert(testhandle:close(),"can't close beehead folder");
				break;
			end
		end

		assert(nonInternals.nonBeeHeadPath,"BeeHead folder not found");

		-- +++ load playerdata +++++++++++++++++++++++++++++++++++++
		dofile(nonInternals.nonBeeHeadPath.."\\players.lua");
	
		-- +++ Default player shapes +++++++++++++++++++++++++++++++
		for counter=1,NON_MAXIMUMPLAYERS do
			nonInternals.nonPlayerPics[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()]=NonImage.new(nonInternals.nonBeeHeadPath.."\\pictures\\"..model.beehead.defaultplayershapewidth.."x"..model.beehead.defaultplayershapeheight.."\\f16\\default\\"..counter..".f16",model.beehead.defaultplayershapewidth,model.beehead.defaultplayershapeheight);
			nonInternals.nonPlayerShapes[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()]=NonShape.new(0,0,model.beehead.defaultplayershapewidth,model.beehead.defaultplayershapeheight,nonInternals.nonPlayerPics[nonInternals.nonBeeHeadPlayers[counter]:getPlayerID()])
			nonInternals.nonPlayers[counter]=nonInternals.nonBeeHeadPlayers[counter];
		end
	end
	
	-- +++ initialise variables ++++++++++++++++++++++++++++++++++
	nonInternals.nonPostInitStage=model.nextstages._default_.next;
					
	-- +++ initialise NonConForm +++++++++++++++++++++++++++++++++
	nonsys=nonsys.new("..\\misc\\dspmod.bsw");

	-- +++ initialisze the screen and resolution (dummy) +++++++++
	nonsys:initScreen(model.screenwidth,model.screenheight);

	-- +++ initialise Keyboard +++++++++++++++++++++++++++++++++++
	if model.useKeyBoard==true then
		nonInternals.nonKeyboard=keyboard.new();
	end
	
	-- +++ initialise TeamTaps +++++++++++++++++++++++++++++++++++
	if model.useTeamTaps==true then
		nonInternals.nonTeamTaps=teamtaps.new();
		nonInternals.nonTeamTaps:enable();
		nonInternals.nonJagPads=nil;
		nonInternals.nonControllers=nonInternals.nonTeamTaps;
	end
	
	-- +++ initialise JagPads ++++++++++++++++++++++++++++++++++++
	if model.useJagPads==true then
		nonInternals.nonJagPads=jagpads.new();
		nonInternals.nonTeamTaps=nil;
		nonInternals.nonControllers=nonInternals.nonJagPads;
	end

	-- +++ highscorefilenameparts ++++++++++++++++++++++++++++++++ 
	if model.highscorefilenameparts~=nil then
		for counter,value in ipairs(model.highscorefilenameparts) do
			nonGlobals.nonHighscoreFileNameParts[counter]=value
		end
	end
	
	collectgarbage();

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllNothing
-- does nothing
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllNothing(view,model)
	collectgarbage();

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- ****************************************************
-- paintPlayers
-- ****************************************************
function non_paintPlayers(topplayerid,options,allplayerpics,numberofbeeheads)
	local filename;
	local handle;

	for counter=0,numberofbeeheads-1 do
		options[counter+1]:setText(nonInternals.nonBeeHeadPlayers[topplayerid+counter]:getName8());
		non_addToPaintList(options[counter+1]);

		filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\" .. (counter)+topplayerid .. ".f16";

		handle=io.open(filename,"r")
		if handle==nil then
			filename=nonInternals.nonBeeHeadPath.."\\pictures\\20x20\\f16\\none.f16";
		end				
		allplayerpics[counter+1]:loadImage(filename,20,20);
	end
end

-- *************************************************************
--- non_controllGameInit
-- Actions at the beginning (and restart) of a game
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllGameInit(view,model)
	-- +++ Clear Tournament scores ++++++++++++++++++++++++++++++
	nonGlobals.nonTournamentScores={
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=1,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=2,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=3,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=4,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=5,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=6,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=7,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=8,beeHeadPlayer=-1}
	};
	-- +++ Set roundcounter to 0 ++++++++++++++++++++++++++++++++
	nonInternals.nonRoundCounter=0;
		
	collectgarbage();

 	return model.stagename,non_StageSelection("next",model.nextstages);
end

-- *************************************************************
--- non_controllGameRound
-- Actions at the beginning of a gameround
-- @view: the view table 
-- @model: the model table 
-- @@: the model table, the next Stage and the type of the next Stage

function non_controllGameRound(view,model)
	nonInternals.nonRoundCounter=nonInternals.nonRoundCounter+1;
	
	nonGlobals.nonGameResults={
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
	};
	
	collectgarbage();

	if nonInternals.nonRoundCounter > nonGlobals.nonNumberOfRounds then
 		return model.stagename,non_StageSelection("finish",model.nextstages);
	else
	 	return model.stagename,non_StageSelection("next",model.nextstages);
	end
end