float4x4	World	: WORLD;
float4x4	View	: VIEW;
float4x4	Proj	: PROJECTION;

float4x4	WorldView;
float4x4	WVP;
float4x4	InvWVP;
float4x4	InvWorld;
float4x4	InvView;

float3		eyeVec;
float4		lightVec;
texture		ShadesTexture;
texture		BorderTexture;
float		fTime;


// light direction (view space)
float3 LightDir < string UIDirectional = "Light Direction"; > = normalize(float3(-1.0f, -1.0f, 1.0f));


// light intensity
float4 I_a = { 0.3f, 0.3f, 0.3f, 1.0f };    // ambient
float4 I_d = { 1.0f, 1.0f, 1.0f, 1.0f };    // diffuse
float4 I_s = { 1.0f, 1.0f, 1.0f, 1.0f };    // specular


// material reflectivity
float4 k_a : MATERIALAMBIENT = { 0.1f, 0.0f, 0.0f, 1.0f };	// ambient
float4 k_d : MATERIALDIFFUSE = { 1.0f, 1.0f, 1.0f, 1.0f };	// diffuse
float4 k_s : MATERIALSPECULAR= { 0.0f, 0.0f, 0.0f, 1.0f };	// specular
int    n   : MATERIALPOWER = 64;				// power



sampler SamplerBase = sampler_state
{
    Texture   = (ShadesTexture);
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU  = CLAMP;
    AddressV  = WRAP;
};

sampler SamplerBorder = sampler_state
{
    Texture   = (BorderTexture);
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU  = CLAMP;
    AddressV  = WRAP;
};


//-----------------------------------------------------------------------------
// Vertex Definitions
//-----------------------------------------------------------------------------

struct APP_OUTPUT
{
	float3 position	: POSITION;
	float3 normal	: NORMAL;
	float2 texture0 : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float4 diffuse	 : COLOR0;
	float4 specular	 : COLOR1;
	float2 texture0  : TEXCOORD0;
	float2 texture1  : TEXCOORD1;
};

struct PS_OUTPUT
{
	float4 color : COLOR;
};

VS_OUTPUT myvs( APP_OUTPUT IN )
{
	VS_OUTPUT OUT = (VS_OUTPUT) 0;

	// temp position holder
	float4 tempPos = float4(IN.position, 1.0);

	// Do bulge effect (displace vectors)
	float3 dispDir = float3( IN.normal.x, IN.normal.y, IN.normal.z );
	float dispValue = 6 * sin( tempPos.y + fTime * 1.6);

	// Displace vertex by some value
	tempPos.xyz += dispDir.xyz * dispValue;

	// Transform vertex 
	OUT.hposition = mul( tempPos, WVP );


	// Compute in object space
	float3 P = IN.position;
	float3 N = IN.normal;
	float3 L = mul( lightVec.xyz, (float3x3)InvWorld );
	float3 E = mul( eyeVec, (float4x3)InvWorld );
	float3 E2 = normalize(P-E);

	OUT.diffuse = float4( 1.0, 1.0, 1.0, 1.0 );
	OUT.specular = float4( 0.0, 0.0, 0.0, 0.0 );

	float LtexU = dot(L, -N);
	float EtexU = dot(E2, -N);

	OUT.texture0.x = max( 0, LtexU );
	OUT.texture0.y = 0.5f;

	//OUT.texture1.x = max( 0, EtexU );
	//OUT.texture1.y = 0.5f;
	OUT.texture1 = IN.texture0;


	return OUT;
}

PS_OUTPUT myps( VS_OUTPUT IN )
{
	PS_OUTPUT OUT = (PS_OUTPUT) 0;

	OUT.color = tex2D( SamplerBorder, IN.texture1 ) * tex1D( SamplerBase, IN.texture0 ) * IN.diffuse + IN.specular;

	return OUT;
}


PS_OUTPUT PSTexture( VS_OUTPUT IN )
{
	PS_OUTPUT OUT = (PS_OUTPUT) 0;

	IN.diffuse.xyz = 0.0f;
	IN.diffuse.w = IN.texture1.x;

	// 1d texture0 * diffuse * 1d texture1
	OUT.color = IN.diffuse;

	return OUT;
}


technique TechniqueCelShading0
{
    pass Pass0
    {
	ZEnable			= TRUE;
	ZWriteEnable		= TRUE;
	Lighting		= TRUE;

	// enable alpha blending
	AlphaBlendEnable	= TRUE;
	SrcBlend		= SRCALPHA;
	DestBlend		= INVSRCALPHA;

        // set up texture stage states to use the diffuse color
        ColorOp[0]		= MODULATE;
        ColorArg1[0]		= TEXTURE;
        AlphaOp[0]		= MODULATE;
        AlphaArg1[0]		= TEXTURE;

        ColorOp[1]		= DISABLE;
        AlphaOp[1]		= DISABLE;


	Sampler[0]	= (SamplerBase); // Needed by pixel shader


	VertexShader = compile vs_1_1 myvs();
	PixelShader  = compile ps_1_3 myps();
    }
}



technique TechniqueCelShading1
{
    pass Pass0
    {
	ZEnable			= TRUE;
	ZWriteEnable		= TRUE;
	Lighting		= TRUE;
	CullMode		= NONE;

	// enable alpha blending
	AlphaBlendEnable	= FALSE;
	SrcBlend		= SRCALPHA;
	DestBlend		= ONE;

	AlphaTestEnable		= FALSE;

        // set up texture stage states to use the diffuse color
        ColorOp[0]		= SelectArg1;//MODULATE;
        ColorArg1[0]		= TEXTURE;
        ColorArg2[0]		= DIFFUSE;

        //ColorOp[1]		= DISABLE;


	Sampler[0]		= (SamplerBase);	// Needed by pixel shader
	Sampler[1]		= (SamplerBorder);	// Needed by pixel shader


	VertexShader		= compile vs_1_1 myvs();
	PixelShader		= compile ps_1_3 myps();
    }
}