struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Time : TIME;
float V_Alpha : ALPHA;
float V_Var1 : VAR1; // Intens

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color;
  float2 pos;
  float  x = In.Tex0.x;
  float  y = In.Tex0.y;
  pos.x = x + (cos(V_Time * 1.67 + y * 1.45 + 2.10) * 1.81 + cos(V_Time * 1.74 + y * 1.39 + 1.87) * 1.67) * V_Var1;
  pos.y = y + (cos(V_Time * 1.25 + x * 1.31 + 0.65) * 1.64 + cos(V_Time * 1.45 + x * 1.62 + 1.25) * 1.92) * V_Var1;
  color     = tex2D(Sampler, pos);
  color.a   = V_Alpha * color.a;
  return color;
}

technique Sin
{
  pass PassSin
  {
    PixelShader = compile ps_2_0 PS();
  }
}
