/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "pfire.h"
#include "random.h"
#include "quad.h"
#include "../ds/mtexture.h"

using namespace std;

namespace Tools
{
	PFire::PFire(int nParts)
	{
		m_nParticles = nParts;
		m_pParticles = new Particle[nParts];
		
		for(int i = 0; i < m_nParticles; i++)
		{
			Particle* p = &m_pParticles[i];
			p->life = 4;
			p->fade = Random()/10 + 0.03;
			p->active = true;
			//p->sx = p->x = 0;
			//p->sy = p->y = 0;
			p->xd = URandom();
			p->yd = URandom();
			p->zd = URandom();
			p->r = 1;
			p->g = Random();
			p->b = Random();
			p->yg = -0.02;
		}

	}
	
	PFire::~PFire()
	{
		delete m_pParticles;
	}
	
	void PFire::Draw(float move, float intensity)
	{
		static GLuint texture = DS::MTexture::GetPointer()->GetTexture("fuzzy");
		
		for(int i = 0; i < m_nParticles; i++)
		{
			float life = m_pParticles[i].life;
			glColor3f(m_pParticles[i].r*life*intensity, m_pParticles[i].g*life*intensity, m_pParticles[i].b*life*intensity);
			glPushMatrix();
				glTranslatef(m_pParticles[i].x, m_pParticles[i].y, m_pParticles[i].z);
				glBindTexture(GL_TEXTURE_2D, texture);
				DrawQuad(0.1, 0.1);
			glPopMatrix();		
		}	
				
		Update(1, 1, 0, move, 0.01, 4);
	}
}
