/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
  
#ifndef TEXTURE_H
#define TEXTURE_H
 
#include <iostream>
#include <vector>
#include "SDL/SDL_opengl.h"
#include <png.h>
 
namespace DS
{
	class Texture {
	public:
		Texture();
		~Texture();
		int Load(const char* pFile, bool makegl, bool mipmap);
		GLuint MakeGLTexture();
	
		png_uint_32 width, height;
		int	depth, alpha;
		png_bytep pData;
	private:		
		GLenum m_colorflag;
		GLint m_components;
		bool m_mipmap;
	};

}
 
#endif
