/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MTEXTURE_H
#define MTEXTURE_H

#include "common.h"
#include "texture.h"

namespace DS
{
	class MTexture {
	public:
		~MTexture();
		static void Instance(const char* pBaseDirectory);
		static MTexture* GetPointer();
		int Load(float &state, bool &active);
		int MakeGLTextures();
		GLuint GetTexture(const char* pIdentity);
		std::vector<std::string> GetList();
		std::vector<std::string> GetList(const char* pHead);
	protected:
		MTexture(const char* pBaseDirectory);
	private:
		int LoadSingle(const char* pIdentity);
		std::map <std::string, GLuint> m_textures;
		std::map <std::string, Texture*> m_textureData;
		std::vector<std::string> m_textureNames;
		static MTexture* m_pInstance;
		std::string m_BaseDirectory;
	};	
}

#endif
