#!/usr/bin/perl
#-----------------------------------------------------------
# script-converter for mad-demo-engine 
#
#
#-----------------------------------------------------------
# some hints:
# - helps with handling timing-blocks demo-script-files
# 
# usage:
# - read remix.do example
#
# history:
#---  v008 / 2005-01-24 --------------------------
# + block-timing check
# + usage of alpha-images check
#
#---  v007 / 2005-01-24 --------------------------
# + animDistance()
# + animMaxScale()
# + convert TimeCode 00:00:00;03 into seconds
# + calculate length of block if lenght 0 or $_auto_
#
#---  v006 / 2005-01-19 ---------------------------
# + setLookAtPoint()
# + increase $_now_ with length of last block
# + addition block-type parameter to turn blocks ON/OFF
#		$test_block=OFF						# ignore blocks of type "test_block"
#		block1 [0,10,test_block] {			# define 10 sec block starting a 0 of type test_block
#			displayScene($scene_someScene)
#		}
#
#---  v005 / 2005-01-18 ---------------------------------------------
# + ADD_SCENE - macro
# + ADD_IMAGE - macro
#
#---  v004 / 2004-12-30 by thomas@pixtur.de -----------------
# + convert pairs like 200x200 into coordinates
# + added some new valid-functions
#
use warnings;
use strict;

use Image::Size;

#use Image::Info qw(image_info dim);

### some global vars ###
my $script_name="remix";


my $num_errors=0;


### define valid functions for syntax-check!
# [a|s]
#
#
my %valid_functions=(
	"ISetCurTechnique"=> "sII",
	"ISetImageNr"		=>"sII",
	"setStartTime"		=>"sIFF",
	"loadImages"		=>"sIS",
	"loadScene"			=>"sIS",
	"animateFogColor"	=>"aFFFFFF",
	"animateFogNearFar"	=>"aFFFF",
	"animateFov"		=>"aFF",
	"animateGlow"		=>"aFF",
	"animateSphereFadeIn"=>"aFF",
	"disableFogForScene"=>"aI",
	"disableMatrixElement"=> 1,
	"displayScene"		=>"aI",
	"enableEffect"		=>"aI",
	"enableFog"			=>"a",
	"enableGlow"		=>"a",
	"IAnimatePosition"=> "aIFFFF",
	"IAnimateSize"=> "aIFFFF",
	"IAnimateTransparency"=> "aIFF",
	"ISetEnabled"=> "aI",
	"ISetInFront"=> "aI",
	"setAddMatrix"=> "aII",
	"setCamera"=> "aI",
	"setDisplayMatrix"=> "aI",
	"setEffectCamera"=> "aI",
	"setEffectObjectTransform"=> "a",
	"setMatrixFromScene"=> "aIIS",
	"setMatrixFromSceneCamera"=> "aIIS",
	"setMatrixIdentity"=> "aII",
	"setMatrixZero"=> "sII",
	"setNearFar"=> "aFF",
	#"setTimeScale"=> "a",
	"updateScene"=> "aI",
	"setEffectTime"=> "sIF",
	"animateLightIntensity"=>"aISFF",
	"setMode2"=> "sI",
	"overBlend"=>"aF",
	"enableObjectBlender"=>"aF",
	"setLookAtPoint"=>"aF",
	"animateMaxDistance"=>"aFF",
	"animateScale"=>"aFF",
	"drawText"=>"aS",
	"animateZoomRot"=>"aFF",
	"animateBias"=>"aFF",
	"clearOldScreen"=>"s",
	"setWaterColor"=>"aFFFFFF",
	"animateScreenMultiply"=>"aFFFFFF",
	"animateCameraFov"=>"aIFF",
	"animateOverBlend"=>"aFF",
	"deutsch"=>"aSS",
   	"end"=>"s",
	"reloadTexture"=>"sISS"
);



foreach my $lang qw(eng ger)
{
	print "\n$lang ...\n";

	my $del_lang="ger";
	if($lang eq "ger") {
		$del_lang="eng";
	}

	my %vars=();
		$vars{'unknown_block'}="ON";
		$vars{'_now_'}=0;			### current block time (updated after end of block)

	$vars{'SCREEN_WIDTH'}=800;
	$vars{'SCREEN_HEIGHT'}=600;
	$vars{'ERRORS_TIMING'}=1;

	my @lines_completed=();

	my $cur_blink_id=0;
	my $cur_time=0.0;
	my $cur_len=0.0;

	my $block_time= 0.0;
	my $block_len= 0.0;
	my $block_title="unknown";
	my $block_type=0;
	my $num_scenes=0;	# updated by ADD_SCENE-macro
	my $num_images=0;	# updated by ADD_IMAGE-macro

	### compute all files ###
	open FH_IN, "<$script_name.do" or die "could not open $script_name.do";
	open FH_OUT, ">${script_name}.$lang" or die "could not create ${script_name}_$lang.txt";

	### read lines from file ###
	my @lines=(<FH_IN>);
	close FH_IN;


	foreach my $line(@lines) {
		### strip of all comments ###
		$line =~s/\s*#.*//;

		### remove line-intention ###
		$line =~s/^\s*//;

		### remove language-specific lines ###
		if($line =~/_$del_lang/) {
			$line="";
		}
	}

	#----------------------------------------------------------
	# preparse (comments, time-conversions)
	#----------------------------------------------------------
	my $line_num=0;
	foreach my $line (@lines) {
		$line_num++;






		### convert  color-codes to 1,1,1
		# #80ff03 -> 0.4, 0.5, 0,7
		while($line =~ /(\%([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})(\*([.\d]+))?\b)/igx) {
			my $org=$1;
			my $f= $6 || 1.0;	# faktor
			$f= 1.0 * $f;

			my $r=1*hex("0x$2") * 1/255*$f;
			my $g=1*hex("0x$3") * 1/255*$f;
			my $b=1*hex("0x$4") * 1/255*$f;

			my $new="$r,$g,$b";
			#print "found $org->$new\n";
			#print "found time: f$1 -> $time \n";
			$line =~ s/\Q$org/$new/;
		}



		### convert frames into seconds ###
		# f2343 -> 234.3s
		while($line =~ /\bf(\d*)\b/gx) {
			my $time = (1*$1)/25;
			#print "found time: f$1 -> $time \n";
			$line =~ s/\bf(\d*)\b/$time/;
		}

		### convert time-codes into seconds ###
		# 02:32;00 -> 153s
		while ($line =~
				/\b
				(			# $1
				  (\d+)	# $2
				  :
				  (\d\d)	# $3
				  (			# $4
					;
					(\d\d)	# $5
				  )?
				)
				\b
				/gx) {
			my $org=$1;
			my $mins=$2;
			my $secs=$3;
			my $frames=$5||0;

			my $time = $mins*60+ 1*$secs + (1*$frames)/25;
			#print "found time: f$1 -> $time \n";
			$line =~ s/$org/$time/;
		}
	}




	$line_num=0;
	foreach my $line (@lines) {
		$line_num++;

		### wait til end of block ###
		# this must be done before variable-replacement
		# because _now_ has to be updated
		if($block_type) {
			if($line=~ /\}/) {
				$line="";
				if($vars{$block_type} && $vars{$block_type} eq "ON") {
					$vars{"_now_"}+= $block_len;	#update block-time
				}
				$block_time= 0.0;
				$block_len= 0.0;
				$block_type=0;
				$vars{"_len_"}=0;
			}
			elsif($vars{$block_type} && $vars{$block_type} eq "OFF") {
				$line="";
			}
		}




		### ADD_SCENE-macro ####
		if($line=~ /^ADD_SCENE\(([\w_]+),\s*([\w+_]+)\)/) {
			my $id=$1;
			my $file=$2;
			#print "loadScene($id,$file)\n";
			$vars{"scene_$id"}=$num_scenes;
			$line="loadScene(\$scene_$id, &$file, $num_scenes)\n";
			#print " $line\n";
			$num_scenes++;
		}

		### ADD_IMAGE-macro ####
		if($line=~ /^ADD_IMAGE\(([\w+_]+)\s*,\s*([\w+_]+)\)/) {
			my $str_isize="";
			my $var_id=$1;
			my $file=$2;

			### check of correct use of alpha-textures ###
			if($file =~ /_alpha$/) {
				if($file !~ /\+/) {
					print "NOTE: '$file' is NOT used as alpha-channel\n";
				}
			}

			### check if file exists ###
			if($file=~/(.*)\+(.*)/) {
				my $path1="..\\textures\\$1.jpg";
				my $path2="..\\textures\\$2.jpg";

				if(!-f $path1) {
					print "LINE $line_num: '$1.jpg' does not exists\n";
					$num_errors++;
				}
				elsif (!-f $path2) {
					print "LINE $line_num: '$2.jpg' does not exists\n";
					$num_errors++;
				}
				else {
					### default imagesize ###

					my($w, $h) = imgsize($path2);

					$str_isize="0 0 IAnimateSize (\$$var_id, $w x $h ,$w x $h)\n";
				}
			}
			else {
				my $path="..\\textures\\$file.jpg";
				if(!-f $path ) {
					print "LINE $line_num: '$path' does not exists\n";
					$num_errors++;
				}
				else {
					### default imagesize ###
		 			#my $info = image_info($path);
		 			#my($w, $h) = dim($info);
					my($w, $h) = imgsize($path);

					$str_isize="0 1 IAnimateSize (\$$var_id, $w x $h ,$w x $h)\n";
				}
			}

			$vars{"$var_id"}=$num_images;
			$line="loadImages(\$$var_id, &$file)\n$str_isize";
			$num_images++;
		}






		### variable-setting? ###
		if($line =~ /\$([A-Za-z0-9_]*)\s*=\s*([^\s]*)/i) {
			my $var_name= $1;
			my $var_value=$2;
			#print "var '$1' = '$2'\n";
			$vars{$var_name}=$var_value;
			$line="";		# skip line in further processing
		}

		### replace variables ###
		while($line =~ /(\$([A-Za-z0-9_]+))[^A-Za-z0-9_]/) {
			#print " found $2\n";
			#print $vars{$2}."\n";
			if(!defined($vars{$2})) {
				print "LINE $line_num : '$1' is undefined\n";
				$num_errors++;
				last;
			}
			else {
				my $value=$vars{$2};
				$line =~ s/\$$2/$value/;
				#print "--> $line";
			}
		}

		#foreach my $var (keys(%vars)) {
		#	my $value=$vars{$var};
		#	while ($line =~ s/\$$var/$value/g) {
		#		print " replaced $var -> $value\n";
		#		#print "$line\n";
		#
		#	}
		#}

		#while($line =~ /\$([\w]+)/g) {
		#	print "LINE $line_num : '\$$1' is undefined\n";
		#	$num_errors++;
		#}


		### keep last time and duration for usage of ~ ###
		if($line =~ /^([\d\.]+)\s+([\d\.]+)/) {
			$cur_time= $1;
			$cur_len= $2;
			$cur_time= 1.0*$cur_time || 0.0;
			$cur_len= 1.0*$cur_time || 0.0;
			#print "time,len= '$cur_time $cur_len'\n";
		}
		### replace ~ ~ with last time & duration ###
		elsif($line =~ /^~\s+~\s+/) {
			$line =~ s/^~\s+~/$cur_time $cur_len/;
		}
		### replace ~ with last time ###
		elsif($line =~ /^~\s+/) {
			$line =~ s/^~/$cur_time/;
		}

		### function-calls? ###
		if($line =~ /@(\w*)@/g) {
			print "func '$1'\n";
			my $func=$1;
			my $result="";
			if($func eq "BLINK") {
				my @blink_list= split(/,\s*/,$vars{'BLINK_LIST'});
				if(++$cur_blink_id >= 1*@blink_list) {
					$cur_blink_id=0;
				}
				my $blink_item=$blink_list[$cur_blink_id];
				$result=" ambientLight $vars{BLINK_COLOR_START}    rotes_mesh_$blink_item\n".
						"$cur_time	ambientLight $vars{BLINK_COLOR_END} time $vars{BLINK_TIME}	rotes_mesh_$blink_item";
			}
			elsif($func eq "NEXT_BLINK_ID") {
				my @blink_list= split(/,\s*/,$vars{'BLINK_LIST'});
				if(++$cur_blink_id >= 1*@blink_list) {
					$cur_blink_id=0;
				}
				my $blink_item=$blink_list[$cur_blink_id];
				$result= $blink_item;
			}

			else {
				die "unknown func '$func' called\n";
			}
			$line =~ s/\@$func@/$result/;
		}



		### addition? ####
		while ($line =~
		/
		([\d.]+)	#time required
		\+
		([\d.]+)	#time required
		/xg)
		{
			my $added=1*$1 + 1*$2;
			#print "addition($1,$2)\n";
			$line =~ s/$1\+$2/$added/gx;
		}

		### addition? ####
		while ($line =~
		/
		([\d.]+)	#time required
		\+
		([\d.]+)	#time required
		/xg)
		{
			my $added=1*$1 + 1*$2;
			#print "addition($1,$2)\n";
			$line =~ s/$1\+$2/$added/gx;
		}
		### convert coordinate-pairs ###
		while($line=~
		/[\s\(,](

			(\-?\d*)
			\s*
			x
			\s*
			(\-?\d*)
			)\b/gx) {
			my $src= $1;
			my $xp= $2;
			my $yp= $3;
			#if($xp<0) {
			#	$xp=$vars{'SCREEN_WIDTH'}+$xp;
			#}
			#if($yp<0) {
			#	$yp=$vars{'SCREEN_HEIGHT'}+$yp;
			#}




			my $xf= $xp/$vars{'SCREEN_WIDTH'};
			my $yf= $yp/$vars{'SCREEN_HEIGHT'};
			my $dst= "$xf,$yf";

			$line =~ s/$src/$dst/	;
		}


		### substraction? ####
		while ($line =~
		/
		([\d.]+)	#time required
		\-
		([\d.]+)	#time required
		/xg)
		{
			my $added=1*$1 - 1*$2;
			#print "addition($1,$2)\n";
			$line =~ s/$1\-$2/$added/gx;
		}


		### beginning of block ###
		if($line =~
		/
		([^\[]*)	#$1 -> block-title
		\[
		([\d.]+)	#$2 -> start time required
		\s*
		,
		\s*
		([\d.]+)	#$3 -> duration required
		\s*
		(			#$4 -> type??
		,
		\s*
		([\w_]+)	#$5 -> type
		)?
		\]
		\s*
		\{
		/x) {
	#		print "*** $1 ***\n";
			$block_title=$1;
			$block_time=$2;
			$block_len=$3;

			$cur_time=$2;
			$cur_len=$3;
			$block_type=$5 || "unknown_block";
			$line="";

			### enable automatic lenght ###
			if(1*$cur_len == 0) {

				### look ahead for next defined block ###
				my $lines_ahead=0;
				my $l="";
				while($line_num+$lines_ahead < 1*@lines)
				{
					my $l= $lines[$line_num+$lines_ahead];
					#print " $l\n";
					if($l =~ /
						([^\[]*)	#$1 -> block-title
						\[
						([^\s,]+)	#$2 -> start time required
						\s*
						,
						\s*
						([^\s,]+)	#$3 -> duration required
						\s*
						(			#$4 -> type??
						,
						\s*
						([^\s,]+)	#$5 -> type
						)?
						\]
						\s*
						\{
						/x
					) {
						my $tmp_block_title=$1;
						my $tmp_block_time=$2;
						my $tmp_block_len=$3;
						my $tmp_block_type=$5 || "unknown_block";

						if($vars{$tmp_block_type} eq "ON") {
							$block_len=$tmp_block_time - $block_time;
							#print "  >> found block '$tmp_block_title' $block_len sec ahead\n";
							last;

	#						print "> block $block_title ($block_time ... ".($block_time+$block_len)." ,$block_type)\n";
		 				}
					}
					$lines_ahead++;
				}
			}
			$vars{"_len_"}=$block_len;
			$vars{"_end_"}=$block_len+ $block_time;
			$vars{"_start_"}=$block_time;


			### warning, if not defined ###
			if(!$vars{$block_type}) {
				print "LINE $line_num : WARNING: ignoring undefined block!  $line\n";
				$num_errors++;
			}
			elsif($vars{$block_type} eq "ON") {
				print "> block $block_title ($block_time ... ".($block_time+$block_len)." ,$block_type)\n";
		 	}
		}



		### beginning of block ###
		if($line =~
		/
		([^\[]*)	#$1 -> block-title
		\[
		([\d.]+)	#$2 -> start time required
		\s*
		,
		\s*
		([\d.]+)	#$3 -> duration required
		\s*
		(			#$4 -> type??
		,
		\s*
		([\w_]+)	#$5 -> type
		)?
		\]
		\s*
		\{
		/x) {
	#		print "*** $1 ***\n";
			$block_title=$1;
			$block_time=$2;
			$block_len=$3;

			$cur_time=$2;
			$cur_len=$3;
			$block_type=$5 || "unknown_block";
			$line="";

			### enable automatic lenght ###
			if(1*$cur_len == 0) {

			}


			### warning, if not defined ###
			if(!$vars{$block_type}) {
				print "LINE $line_num : WARNING: ignoring undefined block!  $line\n";
				$num_errors++;
			}
			elsif($vars{$block_type} eq "ON") {
				print "> block $block_title ($block_time ... ".($block_time+$block_len)." ,$block_type)\n";
		 	}
		}


		### use block-time and duration if not time given for functions ###
		if($line=~/^[A-Za-z]{3,}/ ) {
			$line= "$block_time $block_len $line";
		}

		### add block-time if relative times are given ###
		if($line =~/^\+([\d.]+)\s*(.*)/) {
			my $added=$block_time + $1;
			$line= $added." ". $2."\n";
		}
		if($line =~/^\-([\d.]+)\s*(.*)/) {
			my $added=$block_time +$block_len - $1;
			$line= $added." ". $2."\n";
		}

		### convert stop-time into duration if "start .. stop" ###
 		if(my($strt,$stp,$rest)=$line =~/^([\d.]+)\s*\.\.\s*([\d.]+)\s*(.*)/) {
			my $dur=$stp -$strt;
			#print "converting duration: $strt, $stp, $dur\n";
			$line= "$strt $dur $rest\n";
		}

		### look ahead for stoptime if "start .. " ###
 		if(my($strt,$rest)=$line =~/^([\d.]+)\s*\.\.\s*([\wW]{3,}.*)/) {


			### look ahead for next defined block ###
			my $lines_ahead=0;
			my $time2=0;
			my $l="";
			while($line_num+$lines_ahead < 1*@lines)
			{
				my $l= $lines[$line_num+$lines_ahead];
				if(($time2)= $l =~ /^([\d.]+)\s*/) {
	 				last;
				}
				$lines_ahead++;
			}
			my $dur=$time2 -$strt;

			#print "looking ahead for duration: $strt $dur\n";

			$line= "$strt $dur $rest\n";
		}

		### check syntax ####
		if($line !~ /^\s*$/ ) {
			if(
				$line =~
				/^
				([\d.]+)	# $1 time required
				\s+
				([\d.]+)	#$2 duration required
				\s*
				([\w]+)	# $3-> function name required
				\s*
				\(
				([^\)]*) # $4-> parameters
				\)
				/x
			) {
				my $time=1.0*$1;
				my $dur=1.0*$2;
				my $fname=$3;
				my $params=$4;
				#print ("line is ok $1, $2, $3\n");
				### function defined? ###
				if(!$valid_functions{$fname}) {
					print "LINE $line_num : Invalid function '$3'\n";
					$num_errors++;

				}
				### start inside block? ###
				elsif($time < $block_time || $time > $block_time+$block_len) {
					if($vars{"ERRORS_TIMING"} !~ /off/) {
						 print ("  LINE $line_num : starttime (".$1.") exceeds block...\n");
					}
				}
				elsif($time + $dur < $block_time || $time + $dur > $block_time+$block_len) {
					if($vars{"ERRORS_TIMING"} !~ /off/) {
						print ("  LINE $line_num : endtime (". ($time + $dur).") exceeds block.:.\n");
					}
				}

				### time or duration ? ###
				else {
					my $f_syntax=$valid_functions{$3};
					if($f_syntax =~/^s/ && $dur>0) {
						print "LINE $line_num : $fname does not like durations like $time\n";
					}
					if($f_syntax =~/^a/ && $dur==0) {
						print "LINE $line_num : $fname should be called with duration\n";
					}

					### params ###
					my @par_array=split(/,/,$params);
					#print @par_array;
					my $i=0;
					while($f_syntax =~/(F|S|I)/g) {
						my $type=$1;
						my $par=$par_array[$i];
						$i++;

						if(!defined($par)) {
							print "LINE $line_num : $fname  not enought parameters ($i)\n";
							$num_errors++;
							next;
						}
						if($type eq "F" && $par !~ /^\s*-?\d*\.*\d*\s*$/ ) {
							print "LINE $line_num : $fname  param $i should be float (is '".$par."')\n";
						}
						if($type eq "I" && $par !~ /^\s*\d*\s*$/ ) {
							print "LINE $line_num : $fname  param $i should be int (is '".$par."')\n";
						}
						if($type eq "S" && "$par" !~ /^\s*&/ ) {
							print "LINE $line_num : $fname  param $i should be string (is '".$par."')\n";
						}


					}
				}
			}
			else {
				print "LINE $line_num : WARNING: invalid syntax:   $line\n";
				$num_errors++;
			}
		}

		### omit line if block not switched on ###
		if(!$block_type || ($vars{$block_type} && $vars{$block_type} eq "ON")) {
			push @lines_completed,$line;
		}
	}




	my $all= join("", @lines_completed);
	my @all_lines=split(/\n/,$all);
	my @all_lines_sorted=sort by_time @all_lines;

	### write sorted lines ommitting comments #########
	print "writing '${script_name}.$lang' ...\n";
	foreach my $nth_line(@all_lines_sorted) {
		if($nth_line && $nth_line !~ /^#/) {
			$nth_line=~s/[\t\s]+/ /g;
			print FH_OUT "$nth_line\n";
		}
	}
}

if($num_errors) {
	print '-'x50;
	print "\nNOTE: $num_errors errors found!\n";
	print "press ENTER to continue...\n";
	print '-'x50;
}





#-------------------------------------------------
# sort lines for time 
#-------------------------------------------------
sub by_time() {
	my $time_a=10000;
	if($a && $a ne "" && $a =~ /^([\d\.]+)\s*/) {
		$time_a=1.0*$1;
		if ($a =~ /\btime\s+\d/) {
			$time_a+=0.001;
		}
	}


	my $time_b=10000;
	if($b && $b ne "" && $b =~ /^([\d\.]+)\s*/) {
		$time_b=1.0*$1;
		if ($b =~ /\btime\s+\d/) {
			$time_b+=0.001;
		}

	}

	if($time_a < $time_b) {
		return -1;
	}
	elsif($time_a == $time_b) {
		return 0;
	}
	else {
		return 1;
	}
}
