#include "main.h"

uint l_uiTextBase = 0;
float l_fCurx = 0.0f, l_fCury = 0.0f;
int l_iFontSize = 24;

uint l_uiLogoImage = 0;

char *l_szMsgs[] = 
{
    "This production", 
    "was brought",
    "to you", 
    "by Zen coders.",
    "",
    "This is", 
    "only for",
    "fun and", 
    "it's our", 
    "first release,", 
    "but not the last.", 
    "",
    "You can", 
    "find us", 
    "on Http://zencoders.ath.cx",
    "",
    "This demo", 
    "is done",
    "by:",
    "Doxxan",
    "Kryssar", 
    "Prone",
    "",
    "Thanks Algar", 
    "for", 
    "the", 
    "music.",
    "",
    "Thanks", 
    "everybody",
    "on", 
    "BIRDIE 15",
    "<end>"
};

void InitText(void)
{
	HFONT	font;										// Windows Font ID

	l_uiTextBase = glGenLists(96);								// Storage For 96 Characters

	font = CreateFont(-l_iFontSize,							// Height Of Font
						0,								// Width Of Font
						0,								// Angle Of Escapement
						0,								// Orientation Angle
						FW_BOLD,						// Font Weight
						FALSE,							// Italic
						FALSE,							// Underline
						FALSE,							// Strikeout
						ANSI_CHARSET,					// Character Set Identifier
						OUT_TT_PRECIS,					// Output Precision
						CLIP_DEFAULT_PRECIS,			// Clipping Precision
						ANTIALIASED_QUALITY,			// Output Quality
						FF_DONTCARE|DEFAULT_PITCH,		// Family And Pitch
						"Arial");					// Font Name

	SelectObject(g_hndDC, font);							// Selects The Font We Want

	wglUseFontBitmaps(g_hndDC, 32, 96, l_uiTextBase);				// Builds 96 Characters Starting At Character 32

    l_uiLogoImage = LoadTGAFile("media/logo.tga");
}

void ScenePrint(char *a_szText, ...)
{
    glLoadIdentity();
    glRasterPos2f(l_fCurx, l_fCury);

	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (a_szText == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, a_szText);									// Parses The String For Variables
	    vsprintf(text, a_szText, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	glPushAttrib(GL_LIST_BIT);							// Pushes The Display List Bits
	glListBase(l_uiTextBase - 32);								// Sets The Base Character to 32
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	glPopAttrib();										// Pops The Display List Bits
}

void DrawText(void)
{
    static float fMsgPos = 0.0f;
    float fRot = 0.0f;
        
    fMsgPos += 20.0f * g_fTimeMod;
    l_fCury = fMsgPos;
    int t = 0;
    while(strcmp(l_szMsgs[t], "<end>") != 0)
    {
//        if(l_fCury < g_iWinHeight - (160.0f + l_iFontSize) && l_fCury > 160.0f)
//        {
            l_fCurx = (g_iWinWidth / 2) - ((strlen(l_szMsgs[t]) / 2) * (l_iFontSize / 2));            
            l_fCurx += cosf(fRot * (3.14f / 180.0f)) * 100.0f;

            glColor4f(0.0f, 0.0f, 0.0f, 0.8f);
            l_fCurx += 2.0f;
            l_fCury -= 2.0f;
            ScenePrint(l_szMsgs[t]);
            l_fCurx -= 2.0f;
            l_fCury += 2.0f;

            if(l_fCury < 200.0f + l_iFontSize)
            {
                float fShade = Interpolate(1.0f, 0.0f, ((200.0f + l_iFontSize) - l_fCury) / (40.0f + l_iFontSize));
                glColor4f(fShade, fShade, fShade, 1.0f);
            }
            else if(l_fCury > g_iWinHeight - (200.0f + l_iFontSize))
            {
                float fShade = Interpolate(1.0f, 0.0f, (l_fCury - (g_iWinHeight - (200.0f + l_iFontSize))) / (40.0f + l_iFontSize));
                glColor4f(fShade, fShade, fShade, 1.0f);
            }
            else glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                               
            ScenePrint(l_szMsgs[t]);
//        }
        l_fCury -= l_iFontSize;
        fRot += 45.0f;
        if(fRot > 360.0f) fRot = 0.0f;
        ++t;
    }

    if(l_fCury > g_iWinHeight - 160.0f)
    {
        static uint uiLastTick = GetTickCount();
        static float fFade = 0.0f;               
        fFade += 0.5f * g_fTimeMod;
        if(fFade > 1.0f) fFade = 1.0f;
        
        glEnable(GL_BLEND);
        glBindTexture(GL_TEXTURE_2D, l_uiLogoImage);
        glLoadIdentity();
        glTranslatef(g_iWinWidth / 2, g_iWinHeight / 2, 0.0f);
        glColor4f(1.0f, 1.0f, 1.0f, fFade);
        glBegin(GL_QUADS);
            glTexCoord2f(0.0f, 0.0f);
            glVertex2d(-256, -64);
            glTexCoord2f(1.0f, 0.0f);
            glVertex2d(256, -64);
            glTexCoord2f(1.0f, 1.0f);
            glVertex2d(256, 64);
            glTexCoord2f(0.0f, 1.0f);
            glVertex2d(-256, 64);
        glEnd();    
        glBindTexture(GL_TEXTURE_2D, 0);
        
        if(GetTickCount() - uiLastTick > 5000) g_bKillApp = true;
    }

    l_fCurx = 0;
    l_fCury = 0;
}
