#include "main.h"

uint l_uiSideListID = 0;
uint l_uiSideImage = 0;

void InitSideBars(void)
{
    l_uiSideImage = LoadTGAFile("media/side.tga"); 
     
    l_uiSideListID = glGenLists(1);
    glNewList(l_uiSideListID, GL_COMPILE);	
        glBegin(GL_QUADS);
            glTexCoord2f(0.0f, 0.0f);
            glVertex2d(-32, -32);
            glTexCoord2f(1.0f, 0.0f);
            glVertex2d(32, -32);
            glTexCoord2f(1.0f, 1.0f);
            glVertex2d(32, 32);
            glTexCoord2f(0.0f, 1.0f);
            glVertex2d(-32, 32);
        glEnd();
    glEndList();
}
 
void DrawSideBars(void)
{
    static float fColor = 0.0f;
    static int iColPos = 0; 
     
    static float fPosMod = 0.0f;
    fPosMod += 40.0f * g_fTimeMod;
    if(fPosMod > 96.0f) fPosMod = 0.0f; 

    fColor += 0.001f;
    if(fColor > 1.0f)
    {
        fColor = 0.0f;
        ++iColPos;
        if(iColPos > 2) iColPos = 0;
    }    

/*    if(iColPos == 0)
        glColor3f(1.0f - fColor, fColor, 0.0f);
    else if(iColPos == 1)
        glColor3f(0.0f, 1.0 - fColor, fColor);
    else if(iColPos == 2)
        glColor3f(fColor, 0.0f, 1.0f - fColor);*/
    
    glColor4f(1.0f, 1.0f, 1.0f, 0.8f);
         
    glBindTexture(GL_TEXTURE_2D, l_uiSideImage);
    for(int t = -1; t < 10; ++t)
    {
        glLoadIdentity();
        glTranslatef(64, (t * 96) + fPosMod, 0.0f);
        glCallList(l_uiSideListID);
    
        glLoadIdentity();
        glTranslatef(g_iWinWidth - 64, (t * 96) - fPosMod, 0.0f);
        glCallList(l_uiSideListID);
    }
    glBindTexture(GL_TEXTURE_2D, 0);
}
