#ifndef _MAIN_H_
#define _MAIN_H_

typedef unsigned int uint;

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <cstdio>
#include <cstdlib>
#include <gl/gl.h>
#include <gl/glu.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <math.h>

//FMOD
#include "../../../fmodapi374win/api/inc/wincompat.h"
#include "../../../fmodapi374win/api/inc/fmod.h"
#include "../../../fmodapi374win/api/inc/fmod_errors.h"
//FMOD

#define WINDOWCLASS "IntroWindow"

extern HWND g_hndWindow;
extern HDC g_hndDC;
extern HGLRC g_hndRC;
extern int g_iWinWidth, g_iWinHeight;
extern bool g_bFullscreen;
extern bool g_bKillApp;
extern int g_iFPS;
extern float g_fTimeMod;

void cprintf(unsigned int a_uiColor, char *a_szString, ...);
float Interpolate(float a_fStart, float a_fStop, float a_fTime);

//App includes.
#include "tgahandler.h"
#include "displaygrid.h"
#include "letterbox.h"
#include "sidebars.h"
#include "vu.h"
#include "sounds.h"
#include "text.h"

#endif
